/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.papyrus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;

public class DiContentDescriptor
extends XMLContentDescriber {
    private static final int MAX_CHAR_READ = 200;
    private static final String SASH_WINDOWS_MNGR = DiPackage.Literals.SASH_WINDOWS_MNGR.getName();

    public int describe(Reader input, IContentDescription description) throws IOException {
        int describe = super.describe(input, description);
        if (describe == 2 && this.hasSashWindowsMngrDecl(input)) {
            return 2;
        }
        return describe;
    }

    public int describe(InputStream input, IContentDescription description) throws IOException {
        int describe = super.describe(input, description);
        if (describe == 2 && this.hasSashWindowsMngrDecl(input, this.getEncoding(input))) {
            return 2;
        }
        return describe;
    }

    private boolean hasSashWindowsMngrDecl(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        String xmlDecl = new String();
        String line = reader.readLine();
        while (xmlDecl.length() < 200 && line != null) {
            xmlDecl = String.valueOf(xmlDecl) + line;
            if (line.indexOf(SASH_WINDOWS_MNGR) != -1) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    private boolean hasSashWindowsMngrDecl(InputStream input, String encoding) throws IOException {
        byte[] sashWindowsMngtBytes = SASH_WINDOWS_MNGR.getBytes(encoding);
        int c = input.read();
        int count = 0;
        while (c != -1) {
            count = c == sashWindowsMngtBytes[count] ? ++count : 0;
            if (count == sashWindowsMngtBytes.length) {
                return true;
            }
            c = input.read();
        }
        return false;
    }

    private String getEncoding(InputStream input) throws IOException {
        byte[] bom = DiContentDescriptor.getByteOrderMark(input);
        String xmlDeclEncoding = "UTF-8";
        input.reset();
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                xmlDeclEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                xmlDeclEncoding = "UTF-16LE";
            }
            input.skip(bom.length);
        }
        return xmlDeclEncoding;
    }

    public static byte[] getByteOrderMark(InputStream input) throws IOException {
        int first = input.read();
        byte[] bom = null;
        if (first == 239) {
            int second = input.read();
            int third = input.read();
            if (second == 187 && third == 191) {
                bom = IContentDescription.BOM_UTF_8;
            }
        } else if (first == 254) {
            if (input.read() == 255) {
                bom = IContentDescription.BOM_UTF_16BE;
            }
        } else if (first == 255 && input.read() == 254) {
            bom = IContentDescription.BOM_UTF_16LE;
        }
        return bom;
    }
}

