/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicObject {
    private final Cache<String, Field> fFieldCache;
    private final Object fTarget;
    private final Class<?> fTargetClass;

    public DynamicObject(Object target) {
        this.fTarget = target;
        this.fTargetClass = target.getClass();
        this.fFieldCache = CacheBuilder.newBuilder().maximumSize(16).build((CacheLoader)new CacheLoader<String, Field>(){

            public Field load(String key) throws Exception {
                return DynamicObject.getField(DynamicObject.this.fTargetClass, key);
            }
        });
    }

    public Object get(String fieldName) {
        Object ret = null;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.get(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void set(String fieldName, Object value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.set(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public double getDouble(String fieldName) {
        double ret = Double.NaN;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.getDouble(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void setDouble(String fieldName, double value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.setDouble(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getInt(String fieldName) {
        int ret = 0;
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            ret = field.getInt(this.fTarget);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ret;
    }

    public void setInt(String fieldName, int value) {
        try {
            Field field = (Field)this.fFieldCache.get((Object)fieldName);
            field.setInt(this.fTarget, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable cause) {
        Throwables.propagate((Throwable)cause);
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            DynamicObject.makeAccessible(declaredField);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return DynamicObject.getField(superClass, fieldName);
            }
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    private static void makeAccessible(Member member) {
        if (!(Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers()) || !(member instanceof AccessibleObject))) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }
}

