/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.EMFCompareIDE;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.actions.save.SaveComparisonModelAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DiffNodeComparer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.compare.ide.ui.logical.EMFSynchronizationModel;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.actions.FilterActionMenu;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.actions.GroupActionMenu;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilterSelectionChangeEvent;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EMFCompareStructureMergeViewer
extends DiffTreeViewer
implements CommandStackListener {
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private final ComposedAdapterFactory fAdapterFactory;
    private final CompareViewerSwitchingPane fParent;
    private Object fRoot;
    private ICompareEditingDomain editingDomain;
    private EMFCompareStructureMergeViewerComparator structureMergeViewerComparator;
    private StructureMergeViewerFilter structureMergeViewerFilter;
    private StructureMergeViewerGrouper structureMergeViewerGrouper;
    private MenuManager groupsMenuManager;
    private MenuManager filtersMenuManager;
    private GroupActionMenu groupActionMenu;
    private DefaultGroupProvider defaultGroupProvider;
    private FilterActionMenu filterActionMenu;
    private EventBus eventBus;
    private IRunnableWithProgress inputChangedTask = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Computing Structure Differences", 100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.done();
        }
    };

    public EMFCompareStructureMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.structureMergeViewerComparator = new EMFCompareStructureMergeViewerComparator();
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider((AdapterFactory)this.fAdapterFactory, (Viewer)this)));
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider((AdapterFactory)this.fAdapterFactory, this.structureMergeViewerGrouper));
        this.fParent = parent instanceof CompareViewerSwitchingPane ? (CompareViewerSwitchingPane)parent : null;
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.setComparer(new DiffNodeComparer(super.getComparer()));
        if (this.eventBus == null) {
            this.eventBus = new EventBus();
            this.eventBus.register((Object)this);
        }
    }

    public ViewerComparator getComparator() {
        return this.structureMergeViewerComparator;
    }

    @Subscribe
    public void recordFilterSelectionChange(IDifferenceFilterSelectionChangeEvent event) {
        Object property = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.SELECTED_FILTERS");
        HashSet<IDifferenceFilter> selectedFilters = property == null ? new HashSet<IDifferenceFilter>() : (HashSet<IDifferenceFilter>)property;
        switch (event.getAction()) {
            case ADD: {
                selectedFilters.add(event.getFilter());
                break;
            }
            case REMOVE: {
                selectedFilters.remove(event.getFilter());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.SELECTED_FILTERS", selectedFilters);
    }

    @Subscribe
    public void recordGroupProviderSelectionChange(IDifferenceGroupProvider differenceGroupProvider) {
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.SELECTED_GROUP", (Object)differenceGroupProvider);
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        EMFCompareStructureMergeViewer.this.inputChangedTask.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        EMFCompareIDEUIPlugin.getDefault().log(e.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    /*
     * Unable to fully structure code
     */
    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        block14: {
            block15: {
                block13: {
                    if (input == null) break block13;
                    if (input instanceof ComparisonNode) {
                        this.compareInputChanged((ComparisonNode)input, monitor);
                    } else if (input instanceof ComparisonScopeInput) {
                        this.compareInputChanged((ComparisonScopeInput)input, monitor);
                    } else {
                        left = input.getLeft();
                        right = input.getRight();
                        origin = input.getAncestor();
                        syncModel = EMFSynchronizationModel.createSynchronizationModel(left, right, origin);
                        config = this.getCompareConfiguration();
                        if (!syncModel.isLeftEditable()) {
                            config.setLeftEditable(false);
                        }
                        if (!syncModel.isRightEditable()) {
                            config.setRightEditable(false);
                        }
                        scope = syncModel.createMinimizedScope();
                        compareResult = EMFCompareIDE.builder().build().compare(scope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
                        leftResourceSet = (ResourceSet)scope.getLeft();
                        rightResourceSet = (ResourceSet)scope.getRight();
                        originResourceSet = (ResourceSet)scope.getOrigin();
                        this.editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
                        if (this.editingDomain == null) {
                            this.editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN", (Object)this.editingDomain);
                        }
                        this.editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
                        this.compareInputChanged(scope, compareResult);
                    }
                    break block14;
                }
                leftResourceSet = null;
                rightResourceSet = null;
                originResourceSet = null;
                if (this.fRoot == null) break block15;
                comparison = (Comparison)((Adapter)this.fRoot).getTarget();
                matchIt = comparison.getMatches().iterator();
                if (!comparison.isThreeWay()) ** GOTO lbl52
                while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet == null) {
                        rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                    }
                    if (originResourceSet != null) continue;
                    originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet != null) continue;
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl52:
                    // 3 sources

                    ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
                }
            }
            if (this.editingDomain != null) {
                this.editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN", null);
                this.editingDomain = null;
            }
            EMFCompareStructureMergeViewer.unload(leftResourceSet);
            EMFCompareStructureMergeViewer.unload(rightResourceSet);
            EMFCompareStructureMergeViewer.unload(originResourceSet);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", null);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.SELECTED_FILTERS", null);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.SELECTED_GROUP", null);
            this.fRoot = null;
        }
    }

    void compareInputChanged(ComparisonNode input, IProgressMonitor monitor) {
        this.editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
        this.editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.compareInputChanged(null, input.getTarget());
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        this.editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
        this.editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        EMFCompare comparator = (EMFCompare)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.COMPARATOR");
        Comparison comparison = comparator.compare(input.getComparisonScope(), BasicMonitor.toMonitor((IProgressMonitor)monitor));
        this.compareInputChanged(null, comparison);
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    void compareInputChanged(IComparisonScope scope, final Comparison comparison) {
        this.fRoot = this.fAdapterFactory.adapt((Notifier)comparison, ICompareInput.class);
        this.groupActionMenu.createActions(scope, comparison);
        this.filterActionMenu.createActions(scope, comparison);
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", (Object)comparison);
        this.getCompareConfiguration().getContainer().runAsynchronously(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String message = null;
                if (comparison.getDifferences().isEmpty()) {
                    message = "No Differences";
                }
                if (Display.getCurrent() != null) {
                    EMFCompareStructureMergeViewer.this.refreshAfterDiff(message, EMFCompareStructureMergeViewer.this.fRoot);
                } else {
                    final String theMessage = message;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EMFCompareStructureMergeViewer.this.refreshAfterDiff(theMessage, EMFCompareStructureMergeViewer.this.fRoot);
                        }
                    });
                }
            }
        });
    }

    private void refreshAfterDiff(String message, Object root) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(root);
    }

    public void setComparer(IElementComparer comparer) {
        super.setComparer((IElementComparer)new DiffNodeComparer(comparer));
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        super.createToolItems(toolbarManager);
        this.groupActionMenu = new GroupActionMenu(this.getStructureMergeViewerGrouper(), this.getGroupsMenuManager(), this.getDefaultGroupProvider());
        this.filterActionMenu = new FilterActionMenu(this.getStructureMergeViewerFilter(), this.getFiltersMenuManager());
        toolbarManager.add((IAction)new SaveComparisonModelAction(this.getCompareConfiguration()));
        toolbarManager.add((IAction)this.groupActionMenu);
        toolbarManager.add((IAction)this.filterActionMenu);
    }

    protected StructureMergeViewerFilter getStructureMergeViewerFilter() {
        if (this.structureMergeViewerFilter == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerFilter = new StructureMergeViewerFilter(this.eventBus);
            this.structureMergeViewerFilter.install((TreeViewer)this);
        }
        return this.structureMergeViewerFilter;
    }

    protected StructureMergeViewerGrouper getStructureMergeViewerGrouper() {
        if (this.structureMergeViewerGrouper == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerGrouper = new StructureMergeViewerGrouper(this.eventBus);
            this.structureMergeViewerGrouper.install((TreeViewer)this);
        }
        return this.structureMergeViewerGrouper;
    }

    public MenuManager getGroupsMenuManager() {
        if (this.groupsMenuManager == null) {
            this.groupsMenuManager = new MenuManager();
        }
        return this.groupsMenuManager;
    }

    public MenuManager getFiltersMenuManager() {
        if (this.filtersMenuManager == null) {
            this.filtersMenuManager = new MenuManager();
        }
        return this.filtersMenuManager;
    }

    public DefaultGroupProvider getDefaultGroupProvider() {
        if (this.defaultGroupProvider == null) {
            this.defaultGroupProvider = new DefaultGroupProvider();
        }
        return this.defaultGroupProvider;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
            if (input != oldInput) {
                this.initialSelection();
            }
        }
    }

    protected void handleDispose(DisposeEvent event) {
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged(null);
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        Command mostRecentCommand = this.editingDomain.getCommandStack().getMostRecentCommand();
        if (mostRecentCommand instanceof ICompareCopyCommand) {
            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
            this.refresh(true);
            if (!affectedObjects.isEmpty()) {
                ArrayList adaptedAffectedObject = Lists.newArrayList();
                for (Object affectedObject : affectedObjects) {
                    adaptedAffectedObject.add(this.fAdapterFactory.adapt(affectedObject, ICompareInput.class));
                }
                this.setSelection((ISelection)new StructuredSelection((List)adaptedAffectedObject), true);
            }
        }
    }

    private static class EMFCompareStructureMergeViewerComparator
    extends ViewerComparator {
        private EMFCompareStructureMergeViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.getLabel(viewer, e1);
            String name2 = this.getLabel(viewer, e2);
            return this.getComparator().compare(name1, name2);
        }

        private String getLabel(Viewer viewer, Object e1) {
            String name1;
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ILabelProvider) {
                    ILabelProvider lprov = (ILabelProvider)prov;
                    name1 = lprov.getText(e1);
                } else {
                    name1 = prov instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)prov).getStyledText(e1).getString() : (prov instanceof DelegatingStyledCellLabelProvider ? ((DelegatingStyledCellLabelProvider)prov).getStyledStringProvider().getStyledText(e1).getString() : e1.toString());
                }
            }
            if (name1 == null) {
                name1 = "";
            }
            return name1;
        }
    }
}

