/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class DiffBuilder
implements IDiffProcessor {
    public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.setMatch(match);
        referenceChange.setReference(reference);
        referenceChange.setValue(value);
        referenceChange.setKind(kind);
        referenceChange.setSource(source);
    }

    public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.setMatch(match);
        attributeChange.setAttribute(attribute);
        attributeChange.setValue(value);
        attributeChange.setKind(kind);
        attributeChange.setSource(source);
    }

    public void featureMapChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
        FeatureMapChange featureMapChange = CompareFactory.eINSTANCE.createFeatureMapChange();
        featureMapChange.setMatch(match);
        featureMapChange.setAttribute(attribute);
        featureMapChange.setValue(value);
        featureMapChange.setKind(kind);
        featureMapChange.setSource(source);
    }

    public void resourceAttachmentChange(Match match, String uri, DifferenceKind kind, DifferenceSource source) {
        ResourceAttachmentChange change = CompareFactory.eINSTANCE.createResourceAttachmentChange();
        change.setMatch(match);
        change.setResourceURI(uri);
        change.setKind(kind);
        change.setSource(source);
    }

    public void resourceLocationChange(MatchResource matchResource, String baseLocation, String changedLocation, DifferenceKind kind, DifferenceSource source) {
        ResourceLocationChange change = CompareFactory.eINSTANCE.createResourceLocationChange();
        change.setBaseLocation(baseLocation);
        change.setChangedLocation(changedLocation);
        change.setKind(kind);
        change.setSource(source);
        matchResource.getLocationChanges().add((Object)change);
    }
}

