/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo levelCombo;
    private Text fileField;
    private Text maxSizeField;
    private Text maxBackupField;
    private final String[] LOG_LEVELS = new String[]{"OFF", "ERROR", "INFO", "DEBUG"};

    public LoggingPreferencePage() {
    }

    public LoggingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public LoggingPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite loggingComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(loggingComposite);
        new Label(loggingComposite, 16384).setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.level"));
        this.levelCombo = new Combo(loggingComposite, 4);
        this.levelCombo.setItems(this.LOG_LEVELS);
        this.levelCombo.setLayoutData((Object)this.getDefaultFieldGridData(100));
        Label fileLabel = new Label(loggingComposite, 16384);
        fileLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file"));
        this.fileField = new Text(loggingComposite, 2052);
        this.fileField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button fileButton = new Button(loggingComposite, 8);
        fileButton.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.filebutton.label"));
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(LoggingPreferencePage.this.getShell(), 8192);
                File file = new File(LoggingPreferencePage.this.fileField.getText());
                dlg.setFileName(file.getName());
                dlg.setFilterPath(file.getParent());
                String fileName = dlg.open();
                if (fileName != null) {
                    LoggingPreferencePage.this.fileField.setText(fileName);
                }
            }
        });
        Label maxSizeLabel = new Label(loggingComposite, 16384);
        maxSizeLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file.size"));
        this.maxSizeField = new Text(loggingComposite, 2052);
        this.maxSizeField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxSizeField.addVerifyListener((VerifyListener)new VerifyIntegerListener());
        Label maxBackupLabel = new Label(loggingComposite, 16384);
        maxBackupLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.backup.count"));
        this.maxBackupField = new Text(loggingComposite, 2052);
        this.maxBackupField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxBackupField.addVerifyListener((VerifyListener)new VerifyIntegerListener());
        this.refreshWidgets();
        return loggingComposite;
    }

    protected GridData getDefaultFieldGridData(int width) {
        GridData gd = new GridData(16384, 128, false, false, 2, 1);
        gd.widthHint = width;
        return gd;
    }

    protected void savePreferences() throws BackingStoreException {
        IEclipsePreferences prefs = EMFCompareRCPPlugin.getDefault().getEMFComparePreferences();
        prefs.put("org.eclipse.emf.compare.log.file.name", this.fileField.getText());
        String item = this.levelCombo.getItem(this.levelCombo.getSelectionIndex());
        prefs.put("org.eclipse.emf.compare.log.level", item);
        prefs.put("org.eclipse.emf.compare.log.backup.count", this.maxBackupField.getText());
        prefs.put("org.eclipse.emf.compare.log.file.max.size", this.maxSizeField.getText());
        prefs.flush();
    }

    protected void resetPreferences() {
        IEclipsePreferences prefs = EMFCompareRCPPlugin.getDefault().getEMFComparePreferences();
        prefs.put("org.eclipse.emf.compare.log.file.name", "");
        prefs.put("org.eclipse.emf.compare.log.level", "OFF");
        prefs.putInt("org.eclipse.emf.compare.log.backup.count", 10);
        prefs.putInt("org.eclipse.emf.compare.log.file.max.size", 100);
    }

    protected void refreshWidgets() {
        IEclipsePreferences prefs = EMFCompareRCPPlugin.getDefault().getEMFComparePreferences();
        String fileName = prefs.get("org.eclipse.emf.compare.log.file.name", "");
        String level = prefs.get("org.eclipse.emf.compare.log.level", "OFF");
        int maxBackupCount = prefs.getInt("org.eclipse.emf.compare.log.backup.count", 10);
        int maxSizeInMB = prefs.getInt("org.eclipse.emf.compare.log.file.max.size", 100);
        this.levelCombo.select(Arrays.asList(this.LOG_LEVELS).indexOf(level));
        this.levelCombo.pack();
        this.fileField.setText(fileName);
        this.maxBackupField.setText(Integer.toString(maxBackupCount));
        this.maxSizeField.setText(Integer.toString(maxSizeInMB));
    }

    public boolean performOk() {
        try {
            this.savePreferences();
            this.refreshWidgets();
            return super.performOk();
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    protected void performDefaults() {
        this.resetPreferences();
        this.refreshWidgets();
        super.performDefaults();
    }

    private static class VerifyIntegerListener
    implements VerifyListener {
        private VerifyIntegerListener() {
        }

        public void verifyText(VerifyEvent evt) {
            try {
                Integer.parseInt(evt.text);
            }
            catch (NumberFormatException numberFormatException) {
                evt.doit = false;
            }
        }
    }
}

