/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceComputationSchedulerTest {
    protected ResourceComputationScheduler<String> scheduler;
    protected boolean flag;

    @Test
    public void testInitializeCanBeCalledSeveralTimes() {
        this.scheduler.initialize();
        this.scheduler.initialize();
    }

    @Test
    public void testIsInitializedBeforeInit() {
        Assert.assertFalse((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testIsInitializedAfterInit() {
        this.scheduler.initialize();
        Assert.assertTrue((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testIsInitializedAfterDispose() {
        this.scheduler.initialize();
        this.scheduler.dispose();
        Assert.assertFalse((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testBasicExecution() throws Exception {
        this.scheduler.initialize();
        this.flag = false;
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 42;
            }
        }, new Runnable(){

            @Override
            public void run() {
                ResourceComputationSchedulerTest.this.flag = true;
            }
        });
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.flag);
    }

    @Test(expected=OperationCanceledException.class)
    public void testInterruptedExceptionInCallCausesOperationCanceledException() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new InterruptedException();
            }
        }, null);
    }

    @Test(expected=OperationCanceledException.class)
    public void testOperationCanceledExceptionCall() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new OperationCanceledException();
            }
        }, null);
    }

    @Test
    public void testPostTreatmentIsCalledWhenExceptionInTreatment() throws Exception {
        this.scheduler.initialize();
        this.flag = false;
        try {
            this.scheduler.call((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    throw new Exception("For test");
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ResourceComputationSchedulerTest.this.flag = true;
                }
            });
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"For test", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.flag);
    }

    @Test
    public void testPostTreatmentCanBeNull() throws Exception {
        this.scheduler.initialize();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 42;
            }
        }, null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testCallableCannotBeNull() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call(null, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Test
    public void testComputedElements() {
        this.scheduler.initialize();
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
        this.scheduler.setComputedElements(Arrays.asList("a", "b", "c"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)this.scheduler.getComputedElements());
        this.scheduler.clearComputedElements();
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testComputeOneSuccess() throws Exception {
        this.scheduler.initialize();
        final CompStatus desc = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll(Arrays.asList(new TestSuccessfulComputation(desc, "comp1")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"comp1"), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        this.checkSuccess(desc);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testComputeSeveralSuccess() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList computations = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            computations.add(new TestSuccessfulComputation(statuses[i], "comp" + i));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int i = 0;
                while (i < 10) {
                    ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)computations);
                    ++i;
                }
                Assert.assertEquals((Object)ImmutableSet.of((Object)"comp0", (Object)"comp1", (Object)"comp2", (Object)"comp3", (Object)"comp4", (Object)"comp5", (Object[])new String[]{"comp6", "comp7", "comp8", "comp9"}), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testPostTreatmentOnFailureIsCalledOnOneFailedComputation() throws Exception {
        this.scheduler.initialize();
        final CompStatus cs = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll(Arrays.asList(new TestFailedComputation(cs, "fail1")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"fail1"), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        this.checkFailure(cs);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testPostTreatmentOnFailureIsCalledOnAllFailingComputations() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList computations = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            computations.add(new TestFailedComputation(statuses[i], "fail" + i));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)computations);
                Assert.assertEquals((Object)ImmutableSet.of((Object)"fail0", (Object)"fail1", (Object)"fail2", (Object)"fail3", (Object)"fail4", (Object)"fail5", (Object[])new String[]{"fail6", "fail7", "fail8", "fail9"}), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkFailure(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testRunOneSuccess() throws Exception {
        this.scheduler.initialize();
        final CompStatus desc = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.runAll(Arrays.asList(new UninterruptibleRunnable(desc)));
                Assert.assertTrue((boolean)ResourceComputationSchedulerTest.this.scheduler.getComputedElements().isEmpty());
                return 42;
            }
        }, null);
        this.checkSuccess(desc);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testRunSeveralSuccess() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList toBeRun = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            toBeRun.add(new UninterruptibleRunnable(statuses[i]));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.runAll((Iterable)toBeRun);
                Assert.assertTrue((boolean)ResourceComputationSchedulerTest.this.scheduler.getComputedElements().isEmpty());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testScheduleComputationCannotRunOutsideCall() throws Exception {
        this.scheduler.initialize();
        CompStatus desc = new CompStatus();
        this.scheduler.scheduleComputation((IComputation)new TestSuccessfulComputation(desc, "comp"));
    }

    protected void checkSuccess(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertFalse((boolean)state.isInterrupted());
        if (!state.isSuccess() || state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkFailure(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertFalse((boolean)state.isInterrupted());
        if (state.isSuccess() || !state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkInterruptedAndSuccess(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertTrue((boolean)state.isInterrupted());
        if (!state.isSuccess() || state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkInterruptedAndFailure(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertTrue((boolean)state.isInterrupted());
        if (state.isSuccess() || !state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    @Before
    public void setUp() {
        this.scheduler = new ResourceComputationScheduler(100, TimeUnit.MILLISECONDS, null);
    }

    @After
    public void tearDown() {
        this.scheduler.dispose();
    }

    protected static class CompStatus {
        private boolean success = false;
        private boolean failed = false;
        private int callCount;
        private boolean interrupted;
        private ResourceComputationScheduler.ShutdownStatus shutdownStatus;
        private String message;

        protected CompStatus() {
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public synchronized void addCall() {
            ++this.callCount;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public void success(String msg) {
            this.success = true;
            this.failed = false;
            this.message = msg;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void fail(String msg) {
            this.failed = true;
            this.success = false;
            this.message = msg;
        }

        public void interrupt() {
            this.interrupted = true;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void setShutdownStatus(ResourceComputationScheduler.ShutdownStatus shutdownStatus) {
            this.shutdownStatus = shutdownStatus;
        }

        public ResourceComputationScheduler.ShutdownStatus getShutdownStatus() {
            return this.shutdownStatus;
        }
    }

    private final class TestFailedComputation
    implements IComputation<String> {
        private final CompStatus cs;
        private final String name;

        private TestFailedComputation(CompStatus desc, String name) {
            this.cs = desc;
            this.name = name;
        }

        public void run() {
            this.cs.addCall();
            throw new RuntimeException("Error for tests in computation " + this.name);
        }

        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    TestFailedComputation.this.cs.fail("as expected");
                }

                public void onSuccess(Object r) {
                    TestFailedComputation.this.cs.success("onSuccess() called on computation " + TestFailedComputation.this.name + ", should have been onFailure().");
                }
            };
        }

        public String getKey() {
            return this.name;
        }
    }

    private final class TestSuccessfulComputation
    implements IComputation<String> {
        private final CompStatus cs;
        private final String name;

        private TestSuccessfulComputation(CompStatus cs, String name) {
            this.cs = cs;
            this.name = name;
        }

        public void run() {
            this.cs.addCall();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.cs.interrupt();
            }
        }

        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    TestSuccessfulComputation.this.cs.fail("onFailure() called on computation " + TestSuccessfulComputation.this.name + ", should have been onSuccess().");
                }

                public void onSuccess(Object r) {
                    TestSuccessfulComputation.this.cs.success("as expected");
                }
            };
        }

        public String getKey() {
            return this.name;
        }
    }

    private final class UninterruptibleRunnable
    implements Runnable {
        private final CompStatus cs;

        private UninterruptibleRunnable(CompStatus desc) {
            this.cs = desc;
        }

        @Override
        public void run() {
            this.cs.addCall();
            this.cs.success("as expected");
        }
    }
}

