/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.mergeviewer;

import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.internal.spec.ConflictSpec;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.jface.viewers.IElementComparer;
import org.junit.Assert;
import org.junit.Test;

public class TableOrTreeMergeViewerElementComparerTest {
    private static final IElementComparer ELEMENT_COMPARER = new AbstractTableOrTreeMergeViewer.ElementComparer();

    @Test
    public void testEqualPseudoConflictEqualAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.PSEUDO);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "aRight", "Ancestor");
        Diff bDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, "bLeft", "bRight", "Ancestor");
        this.assertEquals(leftItem, rightItem, true);
    }

    @Test
    public void testEqualPseudoConflictUnequalAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.PSEUDO);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "aRight", "aAncestor");
        Diff bDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, "bLeft", "bRight", "bAncestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testUnequalPseudoConflictEqualAncestor() {
        Conflict aPseudo = this.createConflict(ConflictKind.PSEUDO);
        Diff aDiff = this.createDiff(aPseudo);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "aRight", "Ancestor");
        Conflict bPseudo = this.createConflict(ConflictKind.PSEUDO);
        Diff bDiff = this.createDiff(bPseudo);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, "bLeft", "bRight", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testEqualRealConflictEqualAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "aRight", "Ancestor");
        Diff bDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, "bLeft", "bRight", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testNullSidesEqualDiff() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff diff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, diff, null, null, "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, diff, null, null, "Ancestor");
        this.assertEquals(leftItem, rightItem, true);
    }

    @Test
    public void testNullSidesUnequalDiff() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, null, null, "Ancestor");
        Diff bDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, null, null, "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testOnlyOneSideDiffEqualLeftRightAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "Right", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, null, "Left", "Right", "Ancestor");
        this.assertEquals(leftItem, rightItem, true);
    }

    @Test
    public void testOnlyOneSideDiffEqualRightAncestorUnequalLeft() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "Right", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, null, "bLeft", "Right", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testOnlyOneSideDiffEqualLeftAncestorUnequalRight() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "aRight", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, null, "Left", "bRight", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testOnlyOneSideDiffEqualLeftRightUnequalAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "Right", "aAncestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, null, "Left", "Right", "bAncestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testAllEqual() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "Right", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, aDiff, "Left", "Right", "Ancestor");
        this.assertEquals(leftItem, rightItem, true);
    }

    @Test
    public void testAllEqualExceptDiff() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "Right", "Ancestor");
        Diff bDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, bDiff, "Left", "Right", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testAllEqualExceptLeft() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "aLeft", "Right", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, aDiff, "bLeft", "Right", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testAllEqualExceptRight() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "aRight", "Ancestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, aDiff, "Left", "bRight", "Ancestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testAllEqualExceptAncestor() {
        Conflict pseudoConflict = this.createConflict(ConflictKind.REAL);
        Diff aDiff = this.createDiff(pseudoConflict);
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, aDiff, "Left", "Right", "aAncestor");
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, aDiff, "Left", "Right", "bAncestor");
        this.assertEquals(leftItem, rightItem, false);
    }

    @Test
    public void testAllEqualNull() {
        IMergeViewerItem leftItem = this.createItem(IMergeViewer.MergeViewerSide.LEFT, null, null, null, null);
        IMergeViewerItem rightItem = this.createItem(IMergeViewer.MergeViewerSide.RIGHT, null, null, null, null);
        this.assertEquals(leftItem, rightItem, true);
    }

    @Test
    public void testFallbackSameObject() {
        String left = "a";
        this.assertEquals(left, left, true);
    }

    @Test
    public void testFallbackEqualObject() {
        String left = "a";
        String right = "a";
        this.assertEquals(left, right, true);
    }

    @Test
    public void testFallbackUnequalObjects() {
        String left = "a";
        String right = "b";
        this.assertEquals(left, right, false);
    }

    protected Conflict createConflict(ConflictKind kind) {
        ConflictSpec conflict = new ConflictSpec();
        conflict.setKind(kind);
        return conflict;
    }

    protected Diff createDiff(Conflict conflict) {
        DiffSpec diff = new DiffSpec();
        diff.setConflict(conflict);
        return diff;
    }

    protected IMergeViewerItem createItem(IMergeViewer.MergeViewerSide side, Diff diff, final Object left, final Object right, final Object ancestor) {
        MergeViewerItem item = new MergeViewerItem(null, diff, left, right, ancestor, side, null){

            public String toString() {
                return left + " - " + right + " - " + ancestor;
            }
        };
        return item;
    }

    protected void assertEquals(Object a, Object b, boolean expected) {
        Assert.assertEquals((String)("{" + a + "} equals {" + b + "}."), (Object)expected, (Object)ELEMENT_COMPARER.equals(a, b));
        Assert.assertEquals((String)("{" + b + "} equals {" + a + "}."), (Object)expected, (Object)ELEMENT_COMPARER.equals(b, a));
    }
}

