/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodeSingleValueAttribute;
import org.eclipse.emf.compare.tests.nodes.impl.NodesFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class ThreeWayAttributeMergeScenario {
    private static final String ROOT_NODE_NAME = "RootNode";
    private static final String NODE_NAME = "Node";
    private final NodesFactoryImpl nodesFactory = new NodesFactoryImpl();
    private final Resource.Factory resourceFactory = new XMIResourceFactoryImpl();
    private final Resource originResource;
    private final Resource leftResource;
    private final Resource rightResource;

    public ThreeWayAttributeMergeScenario(String originValue, String leftValue, String rightValue) throws IOException {
        this.originResource = this.createNodeWithAttributeResource("origin", originValue);
        this.leftResource = this.createNodeWithAttributeResource("left", leftValue);
        this.rightResource = this.createNodeWithAttributeResource("right", rightValue);
    }

    public Resource createNodeWithAttributeResource(String fileName, String attributeValue) {
        URI fakeUri = URI.createFileURI((String)(String.valueOf(fileName) + ".nodes"));
        Resource resource = this.resourceFactory.createResource(fakeUri);
        Node rootNode = this.nodesFactory.createNode();
        rootNode.setName(ROOT_NODE_NAME);
        Node node = this.createSingleValueAttributeNode(attributeValue);
        node.setName(NODE_NAME);
        rootNode.getContainmentRef1().add((Object)node);
        resource.getContents().add((Object)rootNode);
        return resource;
    }

    private Node createSingleValueAttributeNode(String attributeValue) {
        NodeSingleValueAttribute node = this.nodesFactory.createNodeSingleValueAttribute();
        node.setSingleValuedAttribute(attributeValue);
        return node;
    }

    public Resource getOriginResource() {
        return this.originResource;
    }

    public Resource getLeftResource() {
        return this.leftResource;
    }

    public Resource getRightResource() {
        return this.rightResource;
    }

    public String getLeftAttributeValue() {
        return this.getAttributeValue(this.leftResource);
    }

    public String getRightAttributeValue() {
        return this.getAttributeValue(this.rightResource);
    }

    private String getAttributeValue(Resource resource) {
        Node rootNode = (Node)resource.getContents().get(0);
        Node childNode = (Node)rootNode.getContainmentRef1().get(0);
        NodeSingleValueAttribute attNode = (NodeSingleValueAttribute)childNode;
        return attNode.getSingleValuedAttribute();
    }
}

