/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.generators.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.EEFGen.GenEditionContext;
import org.eclipse.emf.eef.EEFGen.GenViewsRepository;
import org.eclipse.emf.eef.codegen.components.DynamicPropertiesEditionComponent;
import org.eclipse.emf.eef.codegen.components.PropertiesEditionComponent;
import org.eclipse.emf.eef.codegen.components.SubPropertiesEditionComponent;
import org.eclipse.emf.eef.codegen.core.launcher.AbstractPropertiesGeneratorLauncher;
import org.eclipse.emf.eef.codegen.core.services.PropertiesGeneratorLaunchersServices;
import org.eclipse.emf.eef.codegen.parts.FormPropertiesEditionPart;
import org.eclipse.emf.eef.codegen.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.codegen.parts.PropertiesEditionPart;
import org.eclipse.emf.eef.codegen.parts.ViewsRepository;
import org.eclipse.emf.eef.codegen.plugin.Plugin_xml;
import org.eclipse.emf.eef.codegen.providers.ContextMessages;
import org.eclipse.emf.eef.codegen.providers.ContextMessagesProperties;
import org.eclipse.emf.eef.codegen.providers.ContextMessagesPropertiesFR;
import org.eclipse.emf.eef.codegen.providers.PackagePropertiesEditionPartProvider;
import org.eclipse.emf.eef.codegen.providers.PackagePropertiesEditionPolicyProvider;
import org.eclipse.emf.eef.codegen.providers.PackagePropertiesEditionProvider;
import org.eclipse.emf.eef.codegen.providers.PropertiesEditionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAll {
    private File targetFolder;
    private EEFGenModel eefGenModel;
    private Set<IContainer> generationTargets;

    public GenerateAll(IContainer targetFolder, EEFGenModel eefGenModel) {
        this.targetFolder = targetFolder.getLocation().toFile();
        this.eefGenModel = eefGenModel;
        this.generationTargets = new HashSet<IContainer>();
        this.generationTargets.add(targetFolder);
    }

    public Set<IContainer> getGenerationTargets() {
        return this.generationTargets;
    }

    public void doGenerate(IProgressMonitor monitor) throws IOException {
        EObject model;
        if (!this.targetFolder.exists()) {
            monitor.subTask("Creating target folder");
            this.targetFolder.mkdirs();
        }
        monitor.worked(1);
        for (GenEditionContext genEditionContext : this.eefGenModel.getEditionContexts()) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(this.getBasePackage(genEditionContext));
            monitor.subTask("Generating simple components");
            SubPropertiesEditionComponent gen1 = new SubPropertiesEditionComponent((EObject)genEditionContext.getPropertiesEditionContext(), this.targetFolder, arguments);
            gen1.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating composed components");
            model = gen1.getModel();
            if (model == null) continue;
            PropertiesEditionComponent gen0 = new PropertiesEditionComponent(model, this.targetFolder, arguments);
            gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating dynamic composed components");
            DynamicPropertiesEditionComponent gen14 = new DynamicPropertiesEditionComponent(model, this.targetFolder, arguments);
            gen14.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating Policies provider");
            PackagePropertiesEditionPolicyProvider gen10 = new PackagePropertiesEditionPolicyProvider(model, this.targetFolder, arguments);
            gen10.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating Global Edition provider");
            PackagePropertiesEditionProvider gen11 = new PackagePropertiesEditionProvider(model, this.targetFolder, arguments);
            gen11.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating Edition provider");
            PropertiesEditionProvider gen12 = new PropertiesEditionProvider(model, this.targetFolder, arguments);
            gen12.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            if (genEditionContext.isDescriptorsGenericPropertiesViews()) {
                monitor.subTask("Generating plugin.xml configuration");
                Plugin_xml gen6 = new Plugin_xml(model, this.targetFolder, arguments);
                gen6.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                monitor.worked(1);
            }
            monitor.subTask("Generating 'SWT' parts");
            PropertiesEditionPart gen4 = new PropertiesEditionPart(model, this.targetFolder, arguments);
            gen4.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating 'Form' parts");
            FormPropertiesEditionPart gen2 = new FormPropertiesEditionPart(model, this.targetFolder, arguments);
            gen2.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
        }
        for (GenViewsRepository genViewsRepository : this.eefGenModel.getViewsRepositories()) {
            monitor.subTask("Generating parts interfaces");
            ArrayList argumentsEmpty = new ArrayList();
            ArrayList<String> arguments2 = new ArrayList<String>();
            arguments2.add(genViewsRepository.getBasePackage());
            IPropertiesEditionPart gen3 = new IPropertiesEditionPart((EObject)genViewsRepository.getViewsRepository(), this.targetFolder, argumentsEmpty);
            gen3.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            model = gen3.getModel();
            monitor.subTask("Generating views repository");
            ViewsRepository gen3b = new ViewsRepository(model, this.targetFolder, argumentsEmpty);
            gen3b.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating internationalization provider");
            ContextMessages gen8 = new ContextMessages(model, this.targetFolder, argumentsEmpty);
            gen8.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating internationalization messages");
            ContextMessagesProperties gen9 = new ContextMessagesProperties(model, this.targetFolder, argumentsEmpty);
            gen9.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            ContextMessagesPropertiesFR gen91 = new ContextMessagesPropertiesFR(model, this.targetFolder, argumentsEmpty);
            gen91.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
            monitor.subTask("Generating Part provider");
            PackagePropertiesEditionPartProvider gen13 = new PackagePropertiesEditionPartProvider(model, this.targetFolder, argumentsEmpty);
            gen13.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(1);
        }
        for (AbstractPropertiesGeneratorLauncher launcher : PropertiesGeneratorLaunchersServices.getInstance().getlaunchers()) {
            launcher.doGenerate(this.eefGenModel, this.targetFolder, monitor);
            if (launcher.getTargetContainer().isEmpty()) continue;
            this.generationTargets.addAll(launcher.getTargetContainer());
        }
    }

    public String getBasePackage(GenEditionContext genEditionContext) throws IOException {
        if (genEditionContext != null && genEditionContext.getBasePackage() != null) {
            return genEditionContext.getBasePackage();
        }
        return "";
    }

    public String getBasePackage(GenViewsRepository genViewsRepository) throws IOException {
        if (genViewsRepository != null && genViewsRepository.getBasePackage() != null) {
            return genViewsRepository.getBasePackage();
        }
        return "";
    }
}

