/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.mapping.components;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.mapping.MappingPackage;
import org.eclipse.emf.eef.mapping.ModelProperty;
import org.eclipse.emf.eef.mapping.StandardPropertyBinding;
import org.eclipse.emf.eef.mapping.parts.MappingViewsRepository;
import org.eclipse.emf.eef.mapping.parts.StandardPropertyBindingPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.filters.EObjectFilter;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class StandardPropertyBindingBasePropertiesEditionComponent
extends StandardPropertiesEditionComponent {
    public static String BASE_PART = "Base";
    private String[] parts = new String[]{BASE_PART};
    private StandardPropertyBinding standardPropertyBinding;
    protected StandardPropertyBindingPropertiesEditionPart basePart;

    public StandardPropertyBindingBasePropertiesEditionComponent(EObject standardPropertyBinding, String editing_mode) {
        if (standardPropertyBinding instanceof StandardPropertyBinding) {
            this.standardPropertyBinding = (StandardPropertyBinding)standardPropertyBinding;
            if ("Live".equals(editing_mode)) {
                this.semanticAdapter = this.initializeSemanticAdapter();
                this.standardPropertyBinding.eAdapters().add((Object)this.semanticAdapter);
            }
        }
        this.editing_mode = editing_mode;
    }

    private AdapterImpl initializeSemanticAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(final Notification msg) {
                if (StandardPropertyBindingBasePropertiesEditionComponent.this.basePart == null) {
                    StandardPropertyBindingBasePropertiesEditionComponent.this.dispose();
                } else {
                    Runnable updateRunnable = new Runnable(){

                        public void run() {
                            StandardPropertyBindingBasePropertiesEditionComponent.this.runUpdateRunnable(msg);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(updateRunnable);
                    } else {
                        updateRunnable.run();
                    }
                }
            }
        };
    }

    protected void runUpdateRunnable(Notification msg) {
        if (MappingPackage.eINSTANCE.getAbstractPropertyBinding_Name().equals(msg.getFeature()) && this.basePart != null) {
            if (msg.getNewValue() != null) {
                this.basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
            } else {
                this.basePart.setName("");
            }
        }
        if (MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views().equals(msg.getFeature())) {
            this.basePart.updateViews((EObject)this.standardPropertyBinding);
        }
        if (MappingPackage.eINSTANCE.getStandardPropertyBinding_Model().equals(msg.getFeature()) && this.basePart != null) {
            this.basePart.setModel((EObject)msg.getNewValue());
        }
    }

    public Class translatePart(String key) {
        if (BASE_PART.equals(key)) {
            return MappingViewsRepository.StandardPropertyBinding.class;
        }
        return super.translatePart(key);
    }

    public String[] partsList() {
        return this.parts;
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.standardPropertyBinding != null && BASE_PART.equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.basePart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(MappingViewsRepository.class)) != null) {
                this.basePart = (StandardPropertyBindingPropertiesEditionPart)provider.getPropertiesEditionPart(MappingViewsRepository.StandardPropertyBinding.class, kind, (IPropertiesEditionComponent)this);
                this.addListener((IPropertiesEditionListener)this.basePart);
            }
            return (IPropertiesEditionPart)this.basePart;
        }
        return null;
    }

    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == MappingViewsRepository.StandardPropertyBinding.class) {
            this.basePart = (StandardPropertyBindingPropertiesEditionPart)propertiesEditionPart;
        }
    }

    public void initPart(Class key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.basePart != null && key == MappingViewsRepository.StandardPropertyBinding.class) {
            ((IPropertiesEditionPart)this.basePart).setContext(elt, allResource);
            StandardPropertyBinding standardPropertyBinding = (StandardPropertyBinding)elt;
            if (standardPropertyBinding.getName() != null) {
                this.basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)standardPropertyBinding.getName()));
            }
            this.basePart.initViews((EObject)standardPropertyBinding, null, MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views());
            this.basePart.initModel(allResource, (EObject)standardPropertyBinding.getModel());
            this.basePart.setModelButtonMode(ButtonsModeEnum.BROWSE);
            this.basePart.addFilterToViews(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof EObject) {
                        return !StandardPropertyBindingBasePropertiesEditionComponent.this.basePart.isContainedInViewsTable((EObject)element);
                    }
                    return element instanceof Resource;
                }
            });
            this.basePart.addFilterToViews((ViewerFilter)new EObjectFilter(ViewsPackage.eINSTANCE.getElementEditor()));
            this.basePart.addFilterToModel(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof ModelProperty;
                }
            });
        }
        this.setInitializing(false);
    }

    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        if (this.standardPropertyBinding != null && this.basePart != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName())));
            List viewsToAddFromViews = this.basePart.getViewsToAdd();
            Iterator iter = viewsToAddFromViews.iterator();
            while (iter.hasNext()) {
                cc.append(AddCommand.create((EditingDomain)editingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views(), iter.next()));
            }
            List viewsToRemoveFromViews = this.basePart.getViewsToRemove();
            Iterator iter2 = viewsToRemoveFromViews.iterator();
            while (iter2.hasNext()) {
                cc.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views(), iter2.next()));
            }
            if (this.standardPropertyBinding.eGet((EStructuralFeature)MappingPackage.eINSTANCE.getStandardPropertyBinding_Model()) == null || !this.standardPropertyBinding.eGet((EStructuralFeature)MappingPackage.eINSTANCE.getStandardPropertyBinding_Model()).equals(this.basePart.getModel())) {
                cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getStandardPropertyBinding_Model(), (Object)this.basePart.getModel()));
            }
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        cc.append((Command)IdentityCommand.INSTANCE);
        return cc;
    }

    public EObject getPropertiesEditionObject(EObject source) {
        if (source instanceof StandardPropertyBinding) {
            StandardPropertyBinding standardPropertyBindingToUpdate = (StandardPropertyBinding)source;
            standardPropertyBindingToUpdate.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName()));
            standardPropertyBindingToUpdate.getViews().addAll((Collection)this.basePart.getViewsToAdd());
            standardPropertyBindingToUpdate.setModel((ModelProperty)this.basePart.getModel());
            return standardPropertyBindingToUpdate;
        }
        return null;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        if (!this.isInitializing()) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (1 == event.getState() && "Live".equals(this.editing_mode) && valueDiagnostic.getSeverity() == 0) {
                CompoundCommand command = new CompoundCommand();
                if (MappingViewsRepository.StandardPropertyBinding.name == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue()))));
                }
                if (MappingViewsRepository.StandardPropertyBinding.views == event.getAffectedEditor()) {
                    if (3 == event.getKind()) {
                        command.append(AddCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views(), (Object)event.getNewValue()));
                    }
                    if (4 == event.getKind()) {
                        command.append(RemoveCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views(), (Object)event.getNewValue()));
                    }
                    if (7 == event.getKind()) {
                        command.append(MoveCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Views(), (Object)event.getNewValue(), (int)event.getNewIndex()));
                    }
                }
                if (MappingViewsRepository.StandardPropertyBinding.model == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.standardPropertyBinding, (Object)MappingPackage.eINSTANCE.getStandardPropertyBinding_Model(), (Object)event.getNewValue()));
                }
                if (!command.isEmpty() && !command.canExecute()) {
                    EEFRuntimePlugin.getDefault().logError("Cannot perform model change command.", null);
                } else {
                    this.liveEditingDomain.getCommandStack().execute((Command)command);
                }
            }
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                Diagnostic validate = this.validate();
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, validate));
            }
            super.firePropertiesChanged(event);
        }
    }

    public boolean isRequired(String key, int kind) {
        return key == MappingViewsRepository.StandardPropertyBinding.name || key == MappingViewsRepository.StandardPropertyBinding.views || key == MappingViewsRepository.StandardPropertyBinding.model;
    }

    public String getHelpContent(String key, int kind) {
        if (key == MappingViewsRepository.StandardPropertyBinding.name) {
            return "The name of this property binding";
        }
        if (key == MappingViewsRepository.StandardPropertyBinding.views) {
            return "The mapped views";
        }
        if (key == MappingViewsRepository.StandardPropertyBinding.model) {
            return "The mapped model property";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            String newStringValue = event.getNewValue().toString();
            try {
                if (MappingViewsRepository.StandardPropertyBinding.name == event.getAffectedEditor()) {
                    Object newValue = EcoreUtil.createFromString((EDataType)MappingPackage.eINSTANCE.getAbstractPropertyBinding_Name().getEAttributeType(), (String)newStringValue);
                    ret = Diagnostician.INSTANCE.validate(MappingPackage.eINSTANCE.getAbstractPropertyBinding_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        if ("Batch".equals(this.editing_mode)) {
            EObject copy = EcoreUtil.copy((EObject)this.standardPropertyBinding);
            copy = this.getPropertiesEditionObject(copy);
            validate = EEFRuntimePlugin.getEEFValidator().validate(copy);
        } else if ("Live".equals(this.editing_mode)) {
            validate = EEFRuntimePlugin.getEEFValidator().validate((EObject)this.standardPropertyBinding);
        }
        return validate;
    }

    public void dispose() {
        if (this.semanticAdapter != null) {
            this.standardPropertyBinding.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    public String getTabText(String p_key) {
        return this.basePart.getTitle();
    }
}

