/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.layout;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;

public class StateSpaceSpringLayouter
extends AdapterImpl {
    private StateSpace stateSpace;
    private List<State> states;
    private int numStates;
    private double[] posX;
    private double[] posY;
    private double[] posZ;
    private double[] center;
    private double shiftX;
    private double shiftY;
    private double shiftZ;
    private double repulsion = 50.0;
    private double attraction = 10.0;
    private double naturalLength = 30.0;
    private double shiftFactor = 0.1;

    public void setStateSpace(StateSpace stateSpace) {
        if (this.stateSpace != null) {
            this.stateSpace.eAdapters().remove((Object)this);
        }
        this.stateSpace = stateSpace;
        this.states = stateSpace.getStates();
        this.reloadPositions();
        this.stateSpace.eAdapters().add((Object)this);
    }

    private void reloadPositions() {
        this.numStates = this.states.size();
        int size = this.arraySize(this.numStates);
        this.posX = new double[size];
        this.posY = new double[size];
        this.posZ = new double[size];
        int i = 0;
        while (i < this.numStates) {
            int[] location = this.states.get(i).getLocation();
            this.posX[i] = location[0];
            this.posY[i] = location[1];
            this.posZ[i] = location[2];
            ++i;
        }
        this.shiftX = 0.0;
        this.shiftY = 0.0;
        this.shiftZ = 0.0;
    }

    public synchronized void notifyChanged(Notification event) {
        if (event.getFeatureID(StateSpace.class) == 2) {
            if (event.getEventType() == 3) {
                if (this.numStates >= this.posX.length) {
                    int size = this.arraySize(this.numStates + 1);
                    this.posX = Arrays.copyOf(this.posX, size);
                    this.posY = Arrays.copyOf(this.posY, size);
                    this.posZ = Arrays.copyOf(this.posZ, size);
                }
                int[] location = ((State)event.getNewValue()).getLocation();
                this.posX[this.numStates] = location[0];
                this.posY[this.numStates] = location[1];
                this.posZ[this.numStates] = location[2];
                ++this.numStates;
            } else if (event.getEventType() == 4) {
                this.reloadPositions();
            }
        }
    }

    public synchronized void update() {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        this.numStates = Math.min(this.posX.length, this.states.size());
        int i = 0;
        while (i < this.numStates) {
            sumX += this.posX[i];
            sumY += this.posY[i];
            sumZ += this.posZ[i];
            State state = this.states.get(i);
            double forceX = 0.0;
            double forceY = 0.0;
            double forceZ = 0.0;
            int j = 0;
            while (j < this.numStates) {
                if (i != j) {
                    double[] repulsion = this.stateRepulsion(i, j);
                    forceX += repulsion[0];
                    forceY += repulsion[1];
                    forceZ += repulsion[2];
                }
                ++j;
            }
            int incoming = state.getIncoming().size();
            int links = incoming + state.getOutgoing().size();
            int j2 = 0;
            while (j2 < links) {
                State otherState;
                State state2 = otherState = j2 < incoming ? ((Transition)state.getIncoming().get(j2)).getSource() : ((Transition)state.getOutgoing().get(j2 - incoming)).getTarget();
                if (otherState != state && otherState != null) {
                    double[] attraction = this.transitionAttraction(i, otherState.getIndex());
                    forceX += attraction[0];
                    forceY += attraction[1];
                    forceZ += attraction[2];
                }
                ++j2;
            }
            int n = i;
            this.posX[n] = this.posX[n] + (forceX + this.shiftX);
            int n2 = i;
            this.posY[n2] = this.posY[n2] + (forceY + this.shiftY);
            int n3 = i++;
            this.posZ[n3] = this.posZ[n3] + (forceZ + this.shiftZ);
        }
        if (this.center != null && this.numStates > 0) {
            this.shiftX = (this.center[0] - sumX / (double)this.numStates) * this.shiftFactor;
            this.shiftY = (this.center[1] - sumY / (double)this.numStates) * this.shiftFactor;
            this.shiftZ = (this.center[2] - sumZ / (double)this.numStates) * this.shiftFactor;
        }
    }

    public void commit() {
        int i = 0;
        while (i < this.numStates) {
            State state = this.states.get(i);
            int[] location = state.getLocation();
            location[0] = (int)this.posX[i];
            location[1] = (int)this.posY[i];
            location[2] = (int)this.posZ[i];
            state.setLocation(location);
            ++i;
        }
    }

    private double[] transitionAttraction(int i1, int i2) {
        double[] direction = this.direction(i2, i1);
        double distance = this.length(direction);
        if (distance > 1.0) {
            double factor = this.attraction * Math.log(distance / this.naturalLength) / distance;
            direction[0] = direction[0] * factor;
            direction[1] = direction[1] * factor;
            direction[2] = direction[2] * factor;
        } else {
            direction[0] = 1.0;
            direction[1] = 1.0;
            direction[2] = 1.0;
        }
        return direction;
    }

    public double[] stateRepulsion(int i1, int i2) {
        double[] direction = this.direction(i1, i2);
        double distance = this.length(direction);
        if (distance > 1.0) {
            double factor = this.repulsion * this.repulsion / (distance * distance * distance);
            direction[0] = direction[0] * factor;
            direction[1] = direction[1] * factor;
            direction[2] = direction[2] * factor;
        } else {
            direction[0] = -1.0;
            direction[1] = -1.0;
            direction[2] = -1.0;
        }
        return direction;
    }

    private double[] direction(int i1, int i2) {
        return new double[]{this.posX[i1] - this.posX[i2], this.posY[i1] - this.posY[i2], this.posZ[i1] - this.posZ[i2]};
    }

    private double length(double[] vector) {
        return Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
    }

    private int arraySize(int states) {
        return (int)(1.5 * (double)states + 16.0);
    }

    public void setStateRepulsion(double repulsion) {
        this.repulsion = repulsion;
    }

    public void setTransitionAttraction(double attraction) {
        this.attraction = attraction;
    }

    public void setNaturalTransitionLength(int naturalLength) {
        this.naturalLength = naturalLength;
    }

    public void setCenter(double[] center) {
        if (center != null && center.length != 3) {
            center = Arrays.copyOf(center, 3);
        }
        this.center = center;
    }

    public synchronized void setPosition(State state, int ... position) {
        int index = state.getIndex();
        if (this.posX != null && this.posX.length > index) {
            if (position.length > 0) {
                this.posX[index] = position[0];
            }
            if (position.length > 1) {
                this.posY[index] = position[1];
            }
            if (position.length > 2) {
                this.posZ[index] = position[2];
            }
        }
    }
}

