/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractAttributeParser;

public class NodeActionParser
extends AbstractAttributeParser {
    public static final char ACTION_QUOTE_LEFT = '\u00ab';
    public static final char ACTION_QUOTE_RIGHT = '\u00bb';

    public NodeActionParser() {
        super(new EAttribute[0]);
    }

    public String getEditString(IAdaptable element, int flags) {
        Node node = (Node)element.getAdapter(EObject.class);
        Action action = node.getAction();
        return action != null ? action.toString() : "unknown";
    }

    public String getPrintString(IAdaptable element, int flags) {
        return NodeActionParser.addActionQuotes(this.getEditString(element, flags));
    }

    public static String addActionQuotes(String string) {
        return String.valueOf('\u00ab') + string + '\u00bb';
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Node node = (Node)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)node);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Node Action", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return NodeActionParser.this.doParsing(value, node);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Node node) {
        try {
            Action action = Action.parse((String)value);
            node.setAction(action);
            RuleEditHelper.setDefaultAction(node.getGraph().getRule(), action);
            return CommandResult.newOKCommandResult();
        }
        catch (Throwable t) {
            HenshinDiagramEditorPlugin.getInstance().logError("Error occurred when trying to set a node action", t);
            return CommandResult.newErrorCommandResult((Throwable)t);
        }
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

