/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.units;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public abstract class Atom
extends Span {
    boolean deleteEdgeConflictAtom = false;
    Set<ConflictReason> minimalConflictReasons;

    public Atom(Atom s) {
        this(s, "A", "Atom");
    }

    protected Atom(Atom s, String tag, String name) {
        super(s, tag, name);
        this.setForbid(s.isForbid);
        this.setRequire(s.isRequire);
    }

    public boolean isDeleteEdgeConflictAtom() {
        return this.deleteEdgeConflictAtom;
    }

    protected Atom(Atom candidate, Set<ConflictReason> minimalConflictReasons, String tag, String name) {
        super(candidate, tag, name);
        this.setForbid(candidate.isForbid);
        this.setRequire(candidate.isRequire);
        this.minimalConflictReasons = minimalConflictReasons;
        for (Reason reason : minimalConflictReasons) {
            reason.addContainedConflictAtom(this);
        }
        if (candidate.getGraph().getNodes().size() == 2) {
            this.deleteEdgeConflictAtom = true;
        }
    }

    protected Atom(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings, String tag, String name) {
        super(rule1Mappings, s1, rule2Mappings, tag, name);
    }

    public static class ChangeConflictAtom
    extends ConflictAtom {
        public ChangeConflictAtom(Atom candidate) {
            super(candidate, candidate.minimalConflictReasons == null ? new HashSet() : candidate.minimalConflictReasons, "ChCA", "Change conflict atom");
            this.sortID = 3;
            this.tag = "Ch";
        }

        public ChangeConflictAtom(Atom candidate, Set<ConflictReason> minimalConflictReasons) {
            super(candidate, minimalConflictReasons, "ChCA", "Change conflict atom");
            this.sortID = 3;
            this.tag = "Ch";
        }

        public ChangeConflictAtom(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings) {
            super(rule1Mappings, s1, rule2Mappings, "ChCA", "Change conflict atom");
            this.sortID = 3;
            this.tag = "Ch";
        }
    }

    public static class ChangeDependencyAtom
    extends DependencyAtom {
        public ChangeDependencyAtom(Atom s) {
            super(s, "ChDA", "Change dependency atom");
            this.sortID = 7;
            this.tag = "Ch";
        }
    }

    public static abstract class ConflictAtom
    extends Atom {
        protected ConflictAtom(Atom s, String tag, String name) {
            super(s, tag, name);
        }

        protected ConflictAtom(Atom candidate, Set<ConflictReason> minimalConflictReasons, String tag, String name) {
            super(candidate, minimalConflictReasons, tag, name);
        }

        protected ConflictAtom(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings, String tag, String name) {
            super(rule1Mappings, s1, rule2Mappings, tag, name);
        }
    }

    public static class CreateConflictAtom
    extends ConflictAtom {
        public CreateConflictAtom(Atom candidate) {
            super(candidate, candidate.minimalConflictReasons == null ? new HashSet() : candidate.minimalConflictReasons, "CCA", "Create use conflict atom");
            this.sortID = 2;
            this.tag = "C";
        }

        public CreateConflictAtom(Atom candidate, Set<ConflictReason> minimalConflictReasons) {
            super(candidate, minimalConflictReasons, "CCA", "Create conflict atom");
            this.sortID = 2;
            this.tag = "C";
        }

        public CreateConflictAtom(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings) {
            super(rule1Mappings, s1, rule2Mappings, "CCA", "Create conflict atom");
            this.sortID = 2;
            this.tag = "C";
        }
    }

    public static class CreateDependencyAtom
    extends DependencyAtom {
        public CreateDependencyAtom(Atom s) {
            super(s, "CDA", "Create dependency atom");
            this.sortID = 5;
            this.tag = "C";
        }
    }

    public static class CreateEdgeDeleteNodeConflictAtom
    extends ConflictAtom {
        public CreateEdgeDeleteNodeConflictAtom(Atom candidate, Set<ConflictReason> minimalConflictReasons) {
            super(candidate, minimalConflictReasons, "CEDNCA", "Create edge delete node conflict atom");
            this.sortID = 4;
            this.tag = "C";
        }
    }

    public static class DeleteConflictAtom
    extends ConflictAtom {
        public DeleteConflictAtom(Atom candidate) {
            super(candidate, candidate.minimalConflictReasons == null ? new HashSet() : candidate.minimalConflictReasons, "DCA", "Delete conflict atom");
            this.sortID = 1;
            this.tag = "D";
        }

        public DeleteConflictAtom(Atom candidate, Set<ConflictReason> minimalConflictReasons) {
            super(candidate, minimalConflictReasons, "DCA", "Delete conflict atom");
            this.sortID = 1;
            this.tag = "D";
        }

        public DeleteConflictAtom(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings) {
            super(rule1Mappings, s1, rule2Mappings, "DCA", "Delete conflict atom");
            this.sortID = 1;
            this.tag = "D";
        }
    }

    public static class DeleteDependencyAtom
    extends DependencyAtom {
        public DeleteDependencyAtom(Atom s) {
            super(s, "DDA", "Delete dependency atom");
            this.sortID = 6;
            this.tag = "C";
        }
    }

    public static class DeleteEdgeDeleteNodeDependencyAtom
    extends DependencyAtom {
        public DeleteEdgeDeleteNodeDependencyAtom(Atom s) {
            super(s, "DEDNDA", "Delete edge delete node dependency atom");
            this.sortID = 8;
            this.tag = "D";
        }
    }

    public static abstract class DependencyAtom
    extends Atom {
        protected DependencyAtom(Atom s, String tag, String name) {
            super(s, s.minimalConflictReasons, tag, name);
        }
    }
}

