/*
 * Decompiled with CFR 0.152.
 */
package mergeSuggestion.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import mergeSuggestion.MergeRuleElement;
import mergeSuggestion.MergeSuggestionPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class MergeRuleElementImpl
extends MinimalEObjectImpl.Container
implements MergeRuleElement {
    protected EList<GraphElement> referenceElements;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;

    protected MergeRuleElementImpl() {
    }

    protected EClass eStaticClass() {
        return MergeSuggestionPackage.Literals.MERGE_RULE_ELEMENT;
    }

    @Override
    public EList<GraphElement> getReferenceElements() {
        if (this.referenceElements == null) {
            this.referenceElements = new EObjectResolvingEList(GraphElement.class, (InternalEObject)this, 0);
        }
        return this.referenceElements;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder();
        if (!this.getReferenceElements().isEmpty()) {
            name.append("[");
            name.append(this.getReferenceElements().size());
            name.append(" ");
            this.appendGraphKind(name);
            name.append(" ");
            name.append(((GraphElement)this.getReferenceElements().iterator().next()).eClass().getName());
            name.append("s] ");
            this.collectNamesOfReferenceElements(name);
        }
        return name.toString();
    }

    private void collectNamesOfReferenceElements(StringBuilder name) {
        Iterator it = this.getReferenceElements().iterator();
        while (it.hasNext()) {
            GraphElement next = (GraphElement)it.next();
            if (next instanceof Node) {
                Node node = (Node)next;
                if (node.getName() != null) {
                    name.append(node.getName());
                }
                name.append(':');
                name.append(node.getType().getName());
            } else if (next instanceof Edge) {
                Edge edge = (Edge)next;
                if (edge.getSource().getName() != null) {
                    name.append(edge.getSource().getName());
                }
                name.append("->");
                if (edge.getTarget().getName() != null) {
                    name.append(edge.getTarget().getName());
                }
                name.append(':');
                name.append(((Edge)next).getType().getName());
            } else if (next instanceof Attribute) {
                Attribute attribute = (Attribute)next;
                name.append(attribute.getType().getName());
                name.append('=');
                if (attribute.getValue() != null) {
                    name.append(attribute.getValue());
                }
            }
            if (!it.hasNext()) continue;
            name.append(", ");
        }
    }

    private void appendGraphKind(StringBuilder name) {
        if (this.isNacElement()) {
            name.append("NAC");
        } else if (this.isPacElement()) {
            name.append("PAC");
        } else if (this.isLhsElement()) {
            name.append("LHS");
        } else if (this.isRhsElement()) {
            name.append("RHS");
        }
        if (this.isMultiRuleElement()) {
            name.append("*");
        }
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public boolean isNacElement() {
        GraphElement any;
        if (!this.getReferenceElements().isEmpty() && (any = (GraphElement)this.getReferenceElements().iterator().next()).getGraph() != null && any.getGraph().isNestedCondition()) {
            NestedCondition nc = (NestedCondition)any.getGraph().eContainer();
            return nc.isNAC();
        }
        return false;
    }

    @Override
    public boolean isPacElement() {
        GraphElement any;
        if (!this.getReferenceElements().isEmpty() && (any = (GraphElement)this.getReferenceElements().iterator().next()).getGraph() != null && any.getGraph().isNestedCondition()) {
            NestedCondition nc = (NestedCondition)any.getGraph().eContainer();
            return nc.isPAC();
        }
        return false;
    }

    @Override
    public boolean isLhsElement() {
        GraphElement any;
        if (!this.getReferenceElements().isEmpty() && (any = (GraphElement)this.getReferenceElements().iterator().next()).getGraph() != null) {
            return any.getGraph().isLhs();
        }
        return false;
    }

    @Override
    public boolean isRhsElement() {
        GraphElement any;
        if (!this.getReferenceElements().isEmpty() && (any = (GraphElement)this.getReferenceElements().iterator().next()).getGraph() != null) {
            return any.getGraph().isRhs();
        }
        return false;
    }

    @Override
    public boolean isMultiRuleElement() {
        GraphElement any;
        return !this.getReferenceElements().isEmpty() && (any = (GraphElement)this.getReferenceElements().iterator().next()).getGraph() != null && any.getGraph().getRule().eContainer() instanceof Rule;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getReferenceElements();
            }
            case 1: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getReferenceElements().clear();
                this.getReferenceElements().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getReferenceElements().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.referenceElements != null && !this.referenceElements.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.isNacElement();
            }
            case 1: {
                return this.isPacElement();
            }
            case 2: {
                return this.isLhsElement();
            }
            case 3: {
                return this.isRhsElement();
            }
            case 4: {
                return this.isMultiRuleElement();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

