/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clone;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.model_clones.detection.ModelCloneReporterMock;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.AbstractCloneGroupDetector;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clone.IsomorphyChecker;
import org.eclipse.emf.henshin.variability.mergein.conqat.ConqatManager;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraphFactory;
import org.eclipse.emf.henshin.variability.mergein.normalize.RuleToHenshinGraphMap;

public class ConqatBasedCloneGroupDetector
extends AbstractCloneGroupDetector {
    boolean includeRhs;
    int minSubCloneSize;

    public ConqatBasedCloneGroupDetector(List<Rule> rules) {
        super(rules);
    }

    public ConqatBasedCloneGroupDetector(List<Rule> rules, boolean includeRhs) {
        super(rules);
        this.includeRhs = includeRhs;
    }

    public ConqatBasedCloneGroupDetector(List<Rule> rules, int minSubCloneSize, boolean includeRhs) {
        super(rules);
        this.minSubCloneSize = minSubCloneSize;
        this.includeRhs = includeRhs;
    }

    @Override
    public void detectCloneGroups() {
        RuleToHenshinGraphMap ruleGraphs = HenshinGraphFactory.getInstance().createIntegratedGraphs(this.rules, this.includeRhs);
        ConqatManager conquatManager = new ConqatManager(ruleGraphs.getHenshinGraphs(), this.minSubCloneSize);
        conquatManager.doCloneDetection();
        ModelCloneReporterMock reporter = conquatManager.getResultReporter();
        this.result = new HashSet();
        for (ModelCloneReporterMock.ModelClone clone : reporter.modelClones) {
            List<HenshinGraph> involvedRuleGraphs = conquatManager.getInvolvedHenshinGraphs(clone);
            Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> henshinEdgeMappings = conquatManager.createHenshinEdgeMappings(clone);
            Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> henshinAttributeMappings = conquatManager.createHenshinAttributeMappings(clone);
            if (henshinEdgeMappings.isEmpty() && henshinAttributeMappings.isEmpty()) continue;
            if (!IsomorphyChecker.cloneIsIsomorphic(henshinEdgeMappings, henshinAttributeMappings)) {
                System.out.println("[Info] Removed an invalid (non-isomorphic) result entry  from the clone detection result!");
                continue;
            }
            List<Rule> involvedRules = this.convertInvolvedRules(involvedRuleGraphs, ruleGraphs);
            Map<Edge, Map<Rule, Edge>> edgeMappings = this.convertEdgeMappings(henshinEdgeMappings, ruleGraphs);
            Map<Attribute, Map<Rule, Attribute>> attributeMappings = this.convertAttributeMappings(henshinAttributeMappings, ruleGraphs);
            if (involvedRules.isEmpty()) continue;
            CloneGroup newCloneGroup = new CloneGroup(involvedRules, edgeMappings, attributeMappings);
            this.result.add(newCloneGroup);
        }
    }
}

