/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.ArrayList;
import java.util.List;
import mergeSuggestion.MergeSuggestion;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroupDetectionResult;
import org.eclipse.emf.henshin.variability.mergein.clustering.BasicMergeSuggestionBuilder;
import org.eclipse.emf.henshin.variability.mergein.clustering.DefaultAgglomerativeRuleClusterer;
import org.eclipse.emf.henshin.variability.mergein.clustering.MergeClusterer;
import org.eclipse.emf.henshin.variability.mergein.clustering.RuleClusterer;

public class GreedyMergeClusterer
extends MergeClusterer {
    private static final double WEIGHT_CARDINALITY = 0.0;
    private static final double WEIGHT_CLONE_SIZE = 1.0;
    private RuleClusterer clusterer = new DefaultAgglomerativeRuleClusterer();

    public GreedyMergeClusterer(CloneGroupDetectionResult cloneGroupDetectionResult) {
        super(cloneGroupDetectionResult);
    }

    public GreedyMergeClusterer(CloneGroupDetectionResult cloneGroupDetectionResult, RuleClusterer clusterer) {
        super(cloneGroupDetectionResult);
        this.clusterer = clusterer;
    }

    public GreedyMergeClusterer() {
    }

    @Override
    public MergeSuggestion createMergeSuggestion() {
        List<CloneGroup> cloneGroups = this.cloneGroupDetectionResult.getCloneGroups();
        List<List<Rule>> clusters = this.clusterer.clusterRules(cloneGroups);
        ArrayList<CloneGroup> basisClones = new ArrayList<CloneGroup>();
        for (List<Rule> cluster : clusters) {
            List<CloneGroup> restrictedCloneGroups = this.getRestrictedCopy(cloneGroups, cluster);
            while (!restrictedCloneGroups.isEmpty()) {
                CloneGroup topCloneGroup = this.getTopCloneGroup(restrictedCloneGroups);
                restrictedCloneGroups.remove(topCloneGroup);
                if (!topCloneGroup.getRules().isEmpty()) {
                    basisClones.add(topCloneGroup);
                }
                for (CloneGroup minorCloneGroup : restrictedCloneGroups) {
                    minorCloneGroup.removeRules(topCloneGroup.getRules());
                }
                this.removeEmptyCloneGroups(restrictedCloneGroups);
            }
        }
        MergeSuggestion result = BasicMergeSuggestionBuilder.getInstance().createFromBasisClones(basisClones);
        return result;
    }

    protected List<CloneGroup> getRestrictedCopy(List<CloneGroup> cloneGroups, List<Rule> rules) {
        ArrayList<CloneGroup> result = new ArrayList<CloneGroup>();
        for (CloneGroup cg : cloneGroups) {
            this.concernsTwoRules(cg, rules);
        }
        return result;
    }

    private boolean concernsTwoRules(CloneGroup cg, List<Rule> rules) {
        int count = 0;
        for (Rule rule : cg.getRules()) {
            if (rules.contains(rule)) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    private void removeEmptyCloneGroups(List<CloneGroup> cloneGroups) {
        ArrayList<CloneGroup> toRemove = new ArrayList<CloneGroup>();
        for (CloneGroup cg : cloneGroups) {
            if (cg.getRules().size() >= 2) continue;
            toRemove.add(cg);
        }
        cloneGroups.removeAll(toRemove);
    }

    protected CloneGroup getTopCloneGroup(List<CloneGroup> cloneGroups) {
        CloneGroup result = cloneGroups.get(0);
        double topScore = -1.0;
        for (CloneGroup cg : cloneGroups) {
            double cgScore = this.calculateScore(cg);
            if (!(cgScore > topScore)) continue;
            result = cg;
            topScore = cgScore;
        }
        return result;
    }

    private double calculateScore(CloneGroup cg) {
        return 0.0 * (double)cg.getRules().size() + 1.0 * cg.getNumberOfCommonLhsEdges();
    }
}

