/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.bridge.wizards.pages.GraphDefLookup;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefSupplier;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.gmf.internal.bridge.wizards.strategy.AccessibleClassNodeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.CompositeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Hierarchy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.LeafNodeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Strategy;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDefFeeder {
    private final GraphDefLookup myGraphDefLookup;
    private final ToolDefSupplier myToolDefLookup;
    private Hierarchy myHierarchy;
    private final WizardInput myInputHolder;
    private List<EClass> myNodeCandidates;
    private List<EObject> myLinkCandidates;

    public MapDefFeeder(WizardInput holder, ToolDefSupplier toolDefSupplier) {
        assert (holder != null);
        this.myInputHolder = holder;
        this.myGraphDefLookup = new GraphDefLookup(holder.getCanvasDef());
        this.myToolDefLookup = toolDefSupplier;
    }

    protected final Mapping getMapping() {
        return this.myInputHolder.getMapping();
    }

    public void feedDefaultMapping() {
        Hierarchy hierarchy = this.getHierarchy();
        this.myNodeCandidates = new UniqueEList(hierarchy.getAllClasses());
        this.createNodeFilter().filter(this.myNodeCandidates, hierarchy);
        this.myLinkCandidates = new ArrayList<EObject>();
        this.createLinkFilter().filter(this.myLinkCandidates, hierarchy);
        this.myLinkCandidates.addAll(hierarchy.getAccessibleReferences(this.myNodeCandidates.iterator()));
        this.getMapping().getNodes().clear();
        this.getMapping().getNodes().addAll(this.nodesFrom(this.myNodeCandidates));
        this.getMapping().getLinks().clear();
        this.getMapping().getLinks().addAll(this.linksFrom(this.myLinkCandidates));
        this.getMapping().getDiagram().setPalette(this.myInputHolder.getToolDef().getPalette());
    }

    private Hierarchy getHierarchy() {
        if (this.myHierarchy == null) {
            this.myHierarchy = new Hierarchy(this.getMapping().getDiagram().getDomainMetaElement());
            this.myHierarchy.collect();
        }
        return this.myHierarchy;
    }

    private Strategy createNodeFilter() {
        return new CompositeStrategy(new AccessibleClassNodeStrategy(), new LeafNodeStrategy());
    }

    private Strategy createLinkFilter() {
        return new Strategy(){

            @Override
            public String getID() {
                throw new UnsupportedOperationException("QuickHack");
            }

            public void filter(Collection<EObject> soFar, Hierarchy hierarchy) {
                HashSet<EClass> linkCandidates = new HashSet<EClass>(hierarchy.getAccessibleLinkClasses());
                Iterator iter = linkCandidates.iterator();
                while (iter.hasNext()) {
                    EClass element = (EClass)iter.next();
                    if (hierarchy.isLeaf(element)) continue;
                    iter.remove();
                }
                soFar.clear();
                soFar.addAll(linkCandidates);
            }
        };
    }

    private List<TopNodeReference> nodesFrom(List<EClass> candidates) {
        ArrayList<TopNodeReference> rv = new ArrayList<TopNodeReference>(candidates.size());
        for (EClass eClass : candidates) {
            NodeMapping nm = GMFMapFactory.eINSTANCE.createNodeMapping();
            nm.setDomainMetaElement(eClass);
            nm.setDiagramNode(this.myGraphDefLookup.findSuitableNode(nm));
            this.addEditFeature((MappingEntry)nm, eClass);
            nm.setTool(this.myToolDefLookup.findTool(nm));
            TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
            tnr.setContainmentFeature(this.getHierarchy().nodeBackRef(eClass));
            tnr.setOwnedChild(nm);
            rv.add(tnr);
        }
        return rv;
    }

    private List<LinkMapping> linksFrom(List<EObject> candidates) {
        ArrayList<LinkMapping> rv = new ArrayList<LinkMapping>(candidates.size());
        for (EObject next : candidates) {
            LinkMapping lm = GMFMapFactory.eINSTANCE.createLinkMapping();
            if (next instanceof EClass) {
                EClass eClass = (EClass)next;
                lm.setDomainMetaElement(eClass);
                lm.setContainmentFeature(this.getHierarchy().linkBackRef(eClass));
                this.addEditFeature((MappingEntry)lm, eClass);
                lm.setLinkMetaFeature((EStructuralFeature)this.getHierarchy().getLinkFeature(eClass));
            } else {
                lm.setLinkMetaFeature((EStructuralFeature)((EReference)next));
            }
            lm.setDiagramLink(this.myGraphDefLookup.findSuitableLink(lm));
            lm.setTool(this.myToolDefLookup.findTool(lm));
            rv.add(lm);
        }
        return rv;
    }

    private void addEditFeature(MappingEntry me, EClass class1) {
        for (EAttribute n : class1.getEAllAttributes()) {
            if (!EcorePackage.eINSTANCE.getEString().equals(n.getEType())) continue;
            FeatureLabelMapping lm = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
            lm.getFeatures().add((Object)n);
            me.getLabelMappings().add((Object)lm);
            return;
        }
    }

    public NodeReference[] getInitialNodes() {
        return this.nodesFrom(this.myNodeCandidates).toArray(new NodeReference[0]);
    }

    public LinkMapping[] getInitialLinks() {
        return this.linksFrom(this.myLinkCandidates).toArray(new LinkMapping[0]);
    }
}

