/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.graphdef.editor.edit.policies.GMFGraphBaseItemSemanticEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;

public class DiagramLabelAccessorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public DiagramLabelAccessorReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof DiagramLabel)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ChildAccess) || !(this.newEnd instanceof DiagramLabel)) {
            return false;
        }
        return GMFGraphBaseItemSemanticEditPolicy.LinkConstraints.canExistDiagramLabelAccessor_4004(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ChildAccess) || !(this.newEnd instanceof ChildAccess)) {
            return false;
        }
        return GMFGraphBaseItemSemanticEditPolicy.LinkConstraints.canExistDiagramLabelAccessor_4004(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().setAccessor(null);
        this.getNewSource().setAccessor(this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().setAccessor(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected DiagramLabel getOldSource() {
        return (DiagramLabel)this.referenceOwner;
    }

    protected DiagramLabel getNewSource() {
        return (DiagramLabel)this.newEnd;
    }

    protected ChildAccess getOldTarget() {
        return (ChildAccess)this.oldEnd;
    }

    protected ChildAccess getNewTarget() {
        return (ChildAccess)this.newEnd;
    }
}

