/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.DecoratorProviderConfiguration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;

public class DecoratorService
extends Service
implements IDecoratorProvider {
    private static final DecoratorService service = new DecoratorService();

    static {
        service.configureProviders(DiagramUIPlugin.getPluginId(), "decoratorProviders");
    }

    public static DecoratorService getInstance() {
        return service;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        this.execute(ExecutionStrategy.REVERSE, new CreateDecoratorsOperation(decoratorTarget));
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private DecoratorProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = DecoratorProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (this.provider == null) {
                if (this.isSupportedInExtention(operation)) {
                    this.providerConfiguration = null;
                    return this.getProvider().provides(operation);
                }
                return false;
            }
            return this.getProvider().provides(operation);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof CreateDecoratorsOperation) {
                CreateDecoratorsOperation o = (CreateDecoratorsOperation)operation;
                return this.providerConfiguration.supports(o.getDecoratorTarget());
            }
            return false;
        }
    }
}

