/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.DefaultSizeAttributes;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.gmf.codegen.gmfgen.StyleAttributes;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Border;
import org.eclipse.gmf.gmfgraph.BorderRef;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.CompoundBorder;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.CustomBorder;
import org.eclipse.gmf.gmfgraph.CustomConnection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.CustomLayout;
import org.eclipse.gmf.gmfgraph.DefaultSizeFacet;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Direction;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutRef;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.ScalablePolygon;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ViewmapProducersTest
extends TestCase {
    private ViewmapProducer myProducer;
    private final GMFGraphFactory eFact = GMFGraphFactory.eINSTANCE;

    public ViewmapProducersTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myProducer = new InnerClassViewmapProducer();
    }

    public void testInnerViewmapProducerBareFigure() {
        Ellipse ellipseFig = this.eFact.createEllipse();
        ellipseFig.setName("elli");
        Node n = ViewmapProducersTest.createNode("n1", (RealFigure)ellipseFig);
        Viewmap v = this.getProducer().create(n);
        ViewmapProducersTest.assertNotNull((Object)v);
        ViewmapProducersTest.assertTrue((String)v.getClass().getName(), (boolean)(v instanceof FigureViewmap));
        ViewmapProducersTest.assertEquals((String)"org.eclipse.draw2d.Ellipse", (String)((FigureViewmap)v).getFigureQualifiedClassName());
    }

    public void testAbleToProcessFigureAccessor() {
        CustomFigure nodeFigure = this.eFact.createCustomFigure();
        Node n = ViewmapProducersTest.createNode("n1", (RealFigure)nodeFigure);
        nodeFigure.setName("ScrollPane");
        nodeFigure.setQualifiedClassName("org.eclipse.draw2d.ScrollPane");
        FigureAccessor figureAccess1 = this.eFact.createFigureAccessor();
        nodeFigure.getCustomChildren().add((Object)figureAccess1);
        figureAccess1.setAccessor("getContents");
        CustomFigure accessor1Type = this.eFact.createCustomFigure();
        accessor1Type.setName("Accessor1Type");
        accessor1Type.setQualifiedClassName("org.eclipse.draw2d.Figure");
        figureAccess1.setTypedFigure((RealFigure)accessor1Type);
        CustomFigure accessor2Type = this.eFact.createCustomFigure();
        accessor2Type.setQualifiedClassName("org.eclipse.draw2d.Viewport");
        FigureAccessor figureAccess2 = this.eFact.createFigureAccessor();
        figureAccess2.setAccessor("getViewport");
        figureAccess2.setTypedFigure((RealFigure)accessor2Type);
        nodeFigure.getCustomChildren().add((Object)figureAccess2);
        DiagramLabel l1 = this.eFact.createDiagramLabel();
        l1.setName("L1");
        l1.setFigure(n.getFigure());
        l1.setAccessor(DiaDefSetup.newAccess(n.getFigure(), figureAccess1.getTypedFigure()));
        DiagramLabel l2 = this.eFact.createDiagramLabel();
        l2.setName("L2");
        l2.setFigure(n.getFigure());
        l2.setAccessor(DiaDefSetup.newAccess(n.getFigure(), figureAccess2.getTypedFigure()));
        Viewmap nodeViewmap = this.getProducer().create(n);
        Viewmap label1Viewmap = this.getProducer().create(l1);
        Viewmap label2Viewmap = this.getProducer().create(l2);
        ViewmapProducersTest.assertNotNull((Object)nodeViewmap);
        ViewmapProducersTest.assertNotNull((Object)label1Viewmap);
        ViewmapProducersTest.assertNotNull((Object)label2Viewmap);
        ViewmapProducersTest.assertTrue((String)label1Viewmap.getClass().getName(), (boolean)(label1Viewmap instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertTrue((String)label2Viewmap.getClass().getName(), (boolean)(label2Viewmap instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertEquals((String)figureAccess1.getAccessor(), (String)((ParentAssignedViewmap)label1Viewmap).getGetterName());
        ViewmapProducersTest.assertNotNull((Object)((ParentAssignedViewmap)label1Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertNull((Object)((ParentAssignedViewmap)label1Viewmap).getSetterName());
        ViewmapProducersTest.assertEquals((String)figureAccess2.getAccessor(), (String)((ParentAssignedViewmap)label2Viewmap).getGetterName());
        ViewmapProducersTest.assertNotNull((Object)((ParentAssignedViewmap)label2Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertEquals((String)((CustomFigure)figureAccess2.getTypedFigure()).getQualifiedClassName(), (String)((ParentAssignedViewmap)label2Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertNull((Object)((ParentAssignedViewmap)label2Viewmap).getSetterName());
    }

    public void testRecognizesParentAssignedCases() {
        RoundedRectangle rootRect = this.eFact.createRoundedRectangle();
        Node n = ViewmapProducersTest.createNode("n1", (RealFigure)rootRect);
        rootRect.setName("RouRe");
        Label lf = this.eFact.createLabel();
        lf.setName("Lf");
        rootRect.getChildren().add((Object)lf);
        DiagramLabel innerLabel = this.eFact.createDiagramLabel();
        innerLabel.setName("DL1");
        innerLabel.setFigure(n.getFigure());
        innerLabel.setAccessor(DiaDefSetup.newAccess(n.getFigure(), (RealFigure)lf));
        Label topLevelLabelFigure = this.eFact.createLabel();
        topLevelLabelFigure.setName("topLevelLabelFigure");
        DiagramLabel externalLabel = this.eFact.createDiagramLabel();
        externalLabel.setName("DL2");
        externalLabel.setFigure(DiaDefSetup.newDescriptor((RealFigure)topLevelLabelFigure));
        ViewmapProducer p = this.getProducer();
        p.create(n);
        Viewmap innerLabelViewmap = p.create(innerLabel);
        Viewmap externalLabelViewmap = p.create(externalLabel);
        ViewmapProducersTest.assertNotNull((Object)innerLabelViewmap);
        ViewmapProducersTest.assertTrue((String)innerLabelViewmap.getClass().getName(), (boolean)(innerLabelViewmap instanceof ParentAssignedViewmap));
        ParentAssignedViewmap pav = (ParentAssignedViewmap)innerLabelViewmap;
        ViewmapProducersTest.assertEquals((String)innerLabel.getAccessor().getAccessor(), (String)pav.getGetterName());
        ViewmapProducersTest.assertNotNull((Object)pav.getFigureQualifiedClassName());
        ViewmapProducersTest.assertEquals((String)"org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel", (String)pav.getFigureQualifiedClassName());
        ViewmapProducersTest.assertNotNull((Object)externalLabelViewmap);
        ViewmapProducersTest.assertFalse((boolean)(externalLabelViewmap instanceof ParentAssignedViewmap));
    }

    public void testFindAncestorGallery() {
        Rectangle external = this.eFact.createRectangle();
        ViewmapProducersTest.assertNull((Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)external));
        FigureGallery figureGallery = this.eFact.createFigureGallery();
        figureGallery.setName("Any");
        Rectangle normal = this.eFact.createRectangle();
        normal.setName("Normal");
        figureGallery.getFigures().add((Object)normal);
        Rectangle deep = this.eFact.createRectangle();
        deep.setName("Deep");
        normal.getChildren().add((Object)deep);
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)normal));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep));
        deep.setBorder((Border)this.eFact.createLineBorder());
        deep.setLayout((Layout)this.eFact.createFlowLayout());
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep.getBorder()));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep.getLayout()));
        FigureDescriptor fd = this.eFact.createFigureDescriptor();
        fd.setActualFigure((Figure)normal);
        figureGallery.getDescriptors().add((Object)fd);
        ViewmapProducersTest.assertFalse((String)"sanity check", (boolean)figureGallery.getFigures().contains((Object)normal));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep.getLayout()));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((EObject)deep.getBorder()));
    }

    public void testFindAllGalleriesForImport() {
        FigureGallery g1 = this.eFact.createFigureGallery();
        g1.setName("G1 - borders");
        FigureGallery g2 = this.eFact.createFigureGallery();
        g2.setName("G2 - layouts");
        FigureGallery g3 = this.eFact.createFigureGallery();
        g3.setName("G3 - figures");
        CustomBorder b1 = this.eFact.createCustomBorder();
        g1.getBorders().add((Object)b1);
        CompoundBorder b2 = this.eFact.createCompoundBorder();
        BorderRef br = this.eFact.createBorderRef();
        br.setActual((Border)b1);
        b2.setOuter((Border)br);
        g1.getBorders().add((Object)b2);
        Rectangle r1 = this.eFact.createRectangle();
        Rectangle r2 = this.eFact.createRectangle();
        g3.getFigures().add((Object)r2);
        FigureDescriptor fd1 = this.eFact.createFigureDescriptor();
        fd1.setActualFigure((Figure)r1);
        FigureDescriptor fd2 = this.eFact.createFigureDescriptor();
        FigureRef fr = this.eFact.createFigureRef();
        fr.setFigure((RealFigure)r2);
        fd2.setActualFigure((Figure)fr);
        g3.getDescriptors().add((Object)fd1);
        g3.getDescriptors().add((Object)fd2);
        Rectangle r1c = this.eFact.createRectangle();
        Rectangle r2c = this.eFact.createRectangle();
        r1.getChildren().add((Object)r1c);
        r2.getChildren().add((Object)r2c);
        br = this.eFact.createBorderRef();
        br.setActual((Border)b2);
        r1c.setBorder((Border)br);
        br = this.eFact.createBorderRef();
        br.setActual((Border)b1);
        r2c.setBorder((Border)br);
        Rectangle r4 = this.eFact.createRectangle();
        g3.getFigures().add((Object)r4);
        r4.setBorder((Border)this.eFact.createLineBorder());
        Iterator r = InnerClassViewmapProducer.findAllGalleriesForImport((Figure)r4).iterator();
        ViewmapProducersTest.assertTrue((r.hasNext() && r.next() == g3 && !r.hasNext() ? 1 : 0) != 0);
        r = InnerClassViewmapProducer.findAllGalleriesForImport((Figure)fd1.getActualFigure()).iterator();
        ViewmapProducersTest.assertTrue((r.hasNext() && r.next() == g3 && r.hasNext() && r.next() == g1 && !r.hasNext() ? 1 : 0) != 0);
        r = InnerClassViewmapProducer.findAllGalleriesForImport((Figure)fd2.getActualFigure()).iterator();
        ViewmapProducersTest.assertTrue((r.hasNext() && r.next() == g3 && r.hasNext() && r.next() == g1 && !r.hasNext() ? 1 : 0) != 0);
        g2.getLayouts().add((Object)this.eFact.createCustomLayout());
        LayoutRef lref = this.eFact.createLayoutRef();
        lref.setActual((Layout)g2.getLayouts().get(0));
        r1c.setLayout((Layout)lref);
        r1c.setBorder(null);
        r = InnerClassViewmapProducer.findAllGalleriesForImport((Figure)fd1.getActualFigure()).iterator();
        ViewmapProducersTest.assertTrue((r.hasNext() && r.next() == g3 && r.hasNext() && r.next() == g2 && !r.hasNext() ? 1 : 0) != 0);
        r2c.setLayout((Layout)lref);
        r = InnerClassViewmapProducer.findAllGalleriesForImport((Figure)fd2.getActualFigure()).iterator();
        ViewmapProducersTest.assertTrue((r.hasNext() && r.next() == g3 && r.hasNext() && r.next() == g2 && r.hasNext() && r.next() == g1 && !r.hasNext() ? 1 : 0) != 0);
    }

    public void testViewmapRequiredPluginIDs() {
        FigureGallery figureGallery = this.eFact.createFigureGallery();
        figureGallery.setName("Any");
        figureGallery.setImplementationBundle("com.mycompany.figures");
        FigureGallery figureGallery2 = this.eFact.createFigureGallery();
        figureGallery2.setName("Any");
        figureGallery2.setImplementationBundle("com.thirparty.figures");
        CustomBorder cb = this.eFact.createCustomBorder();
        cb.setQualifiedClassName("com.thirparty.figures.borders.BorderA");
        figureGallery2.getBorders().add((Object)cb);
        CustomLayout cl = this.eFact.createCustomLayout();
        cl.setQualifiedClassName("com.thirparty.figures.layouts.LA");
        figureGallery2.getLayouts().add((Object)cl);
        CustomFigure customFigure = this.eFact.createCustomFigure();
        customFigure.setName("ExternalFigure");
        customFigure.setQualifiedClassName("com.mycompany.figures.TheFigure");
        Rectangle r = this.eFact.createRectangle();
        r.setName("RectWithCustomBorderAndChild");
        r.getChildren().add((Object)customFigure);
        CompoundBorder b = this.eFact.createCompoundBorder();
        BorderRef br = this.eFact.createBorderRef();
        br.setActual((Border)cb);
        b.setInner((Border)br);
        r.setBorder((Border)b);
        LayoutRef lref = this.eFact.createLayoutRef();
        lref.setActual((Layout)cl);
        r.setLayout((Layout)lref);
        Node node = this.eFact.createNode();
        node.setName("Node");
        node.setFigure(DiaDefSetup.newDescriptor((RealFigure)r));
        figureGallery.getDescriptors().add((Object)node.getFigure());
        Compartment compartment = this.eFact.createCompartment();
        compartment.setName("Compartment");
        compartment.setFigure(DiaDefSetup.newDescriptor((RealFigure)((CustomFigure)EcoreUtil.copy((EObject)customFigure))));
        figureGallery.getDescriptors().add((Object)compartment.getFigure());
        Connection connection = this.eFact.createConnection();
        connection.setName("Link");
        CustomConnection customLinkFigure = this.eFact.createCustomConnection();
        customLinkFigure.setName("ExternalLink");
        customLinkFigure.setQualifiedClassName("com.mycompany.figures.TheLink");
        connection.setFigure(DiaDefSetup.newDescriptor((RealFigure)customLinkFigure));
        figureGallery.getDescriptors().add((Object)connection.getFigure());
        Viewmap viewmap = this.getProducer().create(compartment);
        ViewmapProducersTest.assertNotNull((Object)viewmap);
        ViewmapProducersTest.assertTrue((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.mycompany.figures"));
        ViewmapProducersTest.assertFalse((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.thirparty.figures"));
        viewmap = this.getProducer().create(connection);
        ViewmapProducersTest.assertNotNull((Object)viewmap);
        ViewmapProducersTest.assertTrue((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.mycompany.figures"));
        ViewmapProducersTest.assertFalse((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.thirparty.figures"));
        viewmap = this.getProducer().create(node);
        ViewmapProducersTest.assertNotNull((Object)viewmap);
        ViewmapProducersTest.assertTrue((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.mycompany.figures"));
        ViewmapProducersTest.assertTrue((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.thirparty.figures"));
    }

    public void testInnerViewmapProducerForNode() {
        RoundedRectangle figure = this.eFact.createRoundedRectangle();
        Node node = ViewmapProducersTest.createNode("n1", (RealFigure)figure);
        ConstantColor c = this.eFact.createConstantColor();
        c.setValue(ColorConstants.CYAN_LITERAL);
        figure.setBackgroundColor((Color)c);
        figure.setName("RouRec1");
        Viewmap v = this.getProducer().create(node);
        ViewmapProducersTest.assertNotNull((Object)v);
        ViewmapProducersTest.assertTrue((boolean)(v instanceof InnerClassViewmap));
        InnerClassViewmap icv = (InnerClassViewmap)v;
        ViewmapProducersTest.assertNotNull((Object)icv.getClassName());
        ViewmapProducersTest.assertNotNull((Object)icv.getClassBody());
        TypeDeclaration typeDecl = this.parseFirstType(icv.getClassBody());
        ViewmapProducersTest.assertNotNull((Object)typeDecl);
        String innerClassGenName = typeDecl.getName().getFullyQualifiedName();
        ViewmapProducersTest.assertEquals((String)icv.getClassName(), (String)innerClassGenName);
    }

    public void testPinnedCompartment() {
        Rectangle rect = this.eFact.createRectangle();
        Node rootNode = ViewmapProducersTest.createNode("Root", (RealFigure)rect);
        rect.setName("RootFig");
        Rectangle compartmentPaneA = this.eFact.createRectangle();
        compartmentPaneA.setName("CompartmentA");
        rect.getChildren().add((Object)compartmentPaneA);
        Ellipse intermediate = this.eFact.createEllipse();
        intermediate.setName("Intermediate");
        rect.getChildren().add((Object)intermediate);
        Rectangle compartmentPaneB = this.eFact.createRectangle();
        compartmentPaneB.setName("CompartmentB");
        intermediate.getChildren().add((Object)compartmentPaneB);
        Compartment compartmentA = ViewmapProducersTest.createCompartment("CompartmentA", rootNode.getFigure(), (RealFigure)compartmentPaneA);
        Compartment compartmentB = ViewmapProducersTest.createCompartment("CompartmentB", rootNode.getFigure(), (RealFigure)compartmentPaneB);
        this.getProducer().create(rootNode);
        Viewmap viewmapA = this.getProducer().create(compartmentA);
        Viewmap viewmapB = this.getProducer().create(compartmentB);
        ViewmapProducersTest.assertNotNull((Object)viewmapA);
        ViewmapProducersTest.assertNotNull((Object)viewmapB);
        ViewmapProducersTest.assertTrue((String)viewmapA.getClass().getName(), (boolean)(viewmapA instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertTrue((String)viewmapB.getClass().getName(), (boolean)(viewmapB instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertEquals((String)((ParentAssignedViewmap)viewmapA).getGetterName(), (String)compartmentA.getAccessor().getAccessor());
        ViewmapProducersTest.assertEquals((String)((ParentAssignedViewmap)viewmapB).getGetterName(), (String)compartmentB.getAccessor().getAccessor());
    }

    public void testFloatingCompartment() {
        Compartment compartment = ViewmapProducersTest.createCompartment("Floating", null, (RealFigure)this.eFact.createEllipse());
        Viewmap viewmapFloat = this.getProducer().create(compartment);
        ViewmapProducersTest.assertNotNull((Object)viewmapFloat);
        ViewmapProducersTest.assertFalse((String)ParentAssignedViewmap.class.getName(), (boolean)(viewmapFloat instanceof ParentAssignedViewmap));
        Compartment noFigure = ViewmapProducersTest.createCompartment("NoFigure", null, (RealFigure)this.eFact.createCustomFigure());
        noFigure.setFigure(null);
        Viewmap viewmapNoFigure = this.getProducer().create(noFigure);
        ViewmapProducersTest.assertNotNull((Object)viewmapNoFigure);
        ViewmapProducersTest.assertFalse((String)ParentAssignedViewmap.class.getName(), (boolean)(viewmapNoFigure instanceof ParentAssignedViewmap));
    }

    public void testResizeConstaintsSingleDiagonals() {
        RoundedRectangle f = this.eFact.createRoundedRectangle();
        f.setName("Figure");
        new ResizeConstraintsChecker(new Direction[]{Direction.NORTH_LITERAL, Direction.WEST_LITERAL}).checkNode(ViewmapProducersTest.createNode("NW", (RealFigure)f, Direction.NORTH_WEST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.NORTH_LITERAL, Direction.EAST_LITERAL}).checkNode(ViewmapProducersTest.createNode("NE", (RealFigure)f, Direction.NORTH_EAST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.WEST_LITERAL}).checkNode(ViewmapProducersTest.createNode("SW", (RealFigure)f, Direction.SOUTH_WEST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.EAST_LITERAL}).checkNode(ViewmapProducersTest.createNode("SE", (RealFigure)f, Direction.SOUTH_EAST_LITERAL));
    }

    public void testResizeConstraintsMulty() {
        Node explicitAny = ViewmapProducersTest.createNode("ExplicitAll", (RealFigure)this.eFact.createRoundedRectangle(), Direction.NSEW_LITERAL);
        Node implicitAny = ViewmapProducersTest.createNode("ImplicitAll", (RealFigure)this.eFact.createRoundedRectangle(), null);
        Node horizontal = ViewmapProducersTest.createNode("Horizontal", (RealFigure)this.eFact.createRoundedRectangle(), Direction.EAST_WEST_LITERAL);
        Node vertical = ViewmapProducersTest.createNode("Vertical", (RealFigure)this.eFact.createRoundedRectangle(), Direction.NORTH_SOUTH_LITERAL);
        NoUselessResizeConstraintsChecker allDirectionsChecker = new NoUselessResizeConstraintsChecker();
        allDirectionsChecker.checkNode(implicitAny);
        allDirectionsChecker.checkNode(explicitAny);
        new ResizeConstraintsChecker(new Direction[]{Direction.EAST_LITERAL, Direction.WEST_LITERAL}).checkNode(horizontal);
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.NORTH_LITERAL}).checkNode(vertical);
    }

    public void testResizeConstaintsSingleCartesians() {
        RoundedRectangle f = this.eFact.createRoundedRectangle();
        f.setName("Figure");
        Direction[] CARTESIANS = new Direction[]{Direction.NORTH_LITERAL, Direction.SOUTH_LITERAL, Direction.EAST_LITERAL, Direction.WEST_LITERAL};
        int i = 0;
        while (i < CARTESIANS.length) {
            Direction next = CARTESIANS[i];
            Node node = ViewmapProducersTest.createNode("Single" + next.getName(), (RealFigure)f, next);
            new ResizeConstraintsChecker(next).checkNode(node);
            ++i;
        }
    }

    public void testDefaultSizeAttribute() {
        Dimension DIMENSION = this.eFact.createDimension();
        DIMENSION.setDx(321);
        DIMENSION.setDy(123);
        RoundedRectangle withPrefSize = this.eFact.createRoundedRectangle();
        withPrefSize.setName("WithPreferredSize");
        withPrefSize.setPreferredSize((Dimension)EcoreUtil.copy((EObject)DIMENSION));
        class Checker {
            private final Dimension myExpectedSize;

            public Checker(Figure expected) {
                this(expected.getPreferredSize());
            }

            public Checker(Dimension expected) {
                this.myExpectedSize = expected == null ? null : (Dimension)EcoreUtil.copy((EObject)expected);
            }

            public void check(RealFigure figure) {
                this.check(ViewmapProducersTest.this.getProducer().create(ViewmapProducersTest.createNode(figure.getName(), figure)));
            }

            public void check(Viewmap viewmap) {
                DefaultSizeAttributes actual = (DefaultSizeAttributes)viewmap.find(DefaultSizeAttributes.class);
                if (this.myExpectedSize == null) {
                    ViewmapProducersTest.assertNull((Object)actual);
                } else {
                    ViewmapProducersTest.assertNotNull((Object)actual);
                    ViewmapProducersTest.assertEquals((int)this.myExpectedSize.getDx(), (int)actual.getWidth());
                    ViewmapProducersTest.assertEquals((int)this.myExpectedSize.getDy(), (int)actual.getHeight());
                }
            }
        }
        new Checker((Figure)withPrefSize).check((RealFigure)withPrefSize);
        Rectangle noPrefSize = this.eFact.createRectangle();
        noPrefSize.setName("NoPrefSize");
        new Checker((Figure)noPrefSize).check((RealFigure)noPrefSize);
        Ellipse childHasPrefSizeButFigureDoesNot = this.eFact.createEllipse();
        childHasPrefSizeButFigureDoesNot.setName("Parent");
        Rectangle child = this.eFact.createRectangle();
        child.setName("child");
        child.setPreferredSize((Dimension)EcoreUtil.copy((EObject)DIMENSION));
        new Checker(null).check((RealFigure)childHasPrefSizeButFigureDoesNot);
        new Checker(DIMENSION).check((RealFigure)child);
        ScalablePolygon noPrefSizeButFacet = this.eFact.createScalablePolygon();
        Node facetNode = ViewmapProducersTest.createNode("NoPrefSizeButFacet", (RealFigure)noPrefSizeButFacet);
        DefaultSizeFacet facet = this.eFact.createDefaultSizeFacet();
        facet.setDefaultSize((Dimension)EcoreUtil.copy((EObject)DIMENSION));
        facetNode.getFacets().add((Object)facet);
        new Checker(DIMENSION).check(this.getProducer().create(facetNode));
        Rectangle bothFacetAndPrefSize = this.eFact.createRectangle();
        Node bothSizesNode = ViewmapProducersTest.createNode("BothPrefSizeAndFacet", (RealFigure)bothFacetAndPrefSize);
        facet = this.eFact.createDefaultSizeFacet();
        facet.setDefaultSize(this.eFact.createDimension());
        facet.getDefaultSize().setDx(42);
        facet.getDefaultSize().setDy(42);
        bothSizesNode.getFacets().add((Object)facet);
        Dimension prefSize = this.eFact.createDimension();
        prefSize.setDx(84);
        prefSize.setDy(84);
        bothFacetAndPrefSize.setPreferredSize(prefSize);
        new Checker(facet.getDefaultSize()).check(this.getProducer().create(bothSizesNode));
    }

    public void testViewmapLayoutType() {
        ViewmapLayoutTypeChecker checker = new ViewmapLayoutTypeChecker();
        GMFGraphFactory gmf = this.eFact;
        checker.check(null, ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createCustomLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createGridLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createBorderLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createXYLayout(), ViewmapLayoutType.XY_LAYOUT_LITERAL);
        FlowLayout flow = gmf.createFlowLayout();
        flow.setForceSingleLine(false);
        checker.check((Layout)flow, ViewmapLayoutType.FLOW_LAYOUT_LITERAL);
        FlowLayout toolbar = gmf.createFlowLayout();
        toolbar.setForceSingleLine(true);
        checker.check((Layout)toolbar, ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL);
    }

    public void testStyleAttributes() {
        class Checker {
            Checker() {
            }

            public void check(Viewmap viewmap, boolean font, boolean fore, boolean back) {
                StyleAttributes attributes = (StyleAttributes)viewmap.find(StyleAttributes.class);
                if (font || fore || back) {
                    ViewmapProducersTest.assertNotNull((Object)attributes);
                    ViewmapProducersTest.assertEquals((boolean)font, (boolean)attributes.isFixedFont());
                    ViewmapProducersTest.assertEquals((boolean)fore, (boolean)attributes.isFixedForeground());
                    ViewmapProducersTest.assertEquals((boolean)back, (boolean)attributes.isFixedBackground());
                } else {
                    ViewmapProducersTest.assertNull((Object)attributes);
                }
            }

            public void check(Node node, boolean font, boolean fore, boolean back) {
                Viewmap viewmap = ViewmapProducersTest.this.getProducer().create(node);
                this.check(viewmap, font, fore, back);
            }

            public void check(Connection link, boolean font, boolean fore, boolean back) {
                Viewmap viewmap = ViewmapProducersTest.this.getProducer().create(link);
                this.check(viewmap, font, fore, back);
            }
        }
        Checker checker = new Checker();
        checker.check(ViewmapProducersTest.createNode("NODE_Empty", (RealFigure)this.eFact.createRectangle()), false, false, false);
        checker.check(ViewmapProducersTest.createLink("LINK_Empty", (ConnectionFigure)this.eFact.createPolylineConnection()), false, false, false);
        Rectangle hasFont = this.eFact.createRectangle();
        BasicFont font = this.eFact.createBasicFont();
        font.setFaceName("Arial");
        font.setHeight(12);
        font.setStyle(FontStyle.BOLD_LITERAL);
        hasFont.setFont((Font)font);
        checker.check(ViewmapProducersTest.createNode("NODE_Font", (RealFigure)hasFont), true, false, false);
        Rectangle hasFore = this.eFact.createRectangle();
        hasFore.setForegroundColor(ViewmapProducersTest.createColor(ColorConstants.GRAY_LITERAL));
        checker.check(ViewmapProducersTest.createNode("NODE_Fore_Color", (RealFigure)hasFore), false, true, false);
        Rectangle hasBack = this.eFact.createRectangle();
        hasBack.setBackgroundColor(ViewmapProducersTest.createColor(ColorConstants.LIGHT_BLUE_LITERAL));
        checker.check(ViewmapProducersTest.createNode("NODE_Back_Color", (RealFigure)hasBack), false, false, true);
        PolylineConnection polylineWithFont = this.eFact.createPolylineConnection();
        polylineWithFont.setFont((Font)font);
        checker.check(ViewmapProducersTest.createLink("Link_Font", (ConnectionFigure)polylineWithFont), true, false, false);
        PolylineConnection polylineWithColor = this.eFact.createPolylineConnection();
        polylineWithColor.setForegroundColor(ViewmapProducersTest.createColor(ColorConstants.RED_LITERAL));
        checker.check(ViewmapProducersTest.createLink("Link_Font", (ConnectionFigure)polylineWithColor), false, true, false);
        RoundedRectangle parent = this.eFact.createRoundedRectangle();
        parent.setName("ParentNoColor");
        Ellipse child = this.eFact.createEllipse();
        child.setName("ChildWithColor");
        child.setForegroundColor(ViewmapProducersTest.createColor(ColorConstants.GREEN_LITERAL));
        parent.getChildren().add((Object)child);
        checker.check(ViewmapProducersTest.createNode("ParentOfColoredChild", (RealFigure)parent), false, false, false);
        Label externalWithFont = this.eFact.createLabel();
        externalWithFont.setText("LabelText");
        externalWithFont.setName("ExternalWithFont");
        externalWithFont.setFont((Font)font);
        DiagramLabel diagramExternalLabel = this.eFact.createDiagramLabel();
        diagramExternalLabel.setName("DiagramExternalLabelWithFont");
        diagramExternalLabel.setFigure(DiaDefSetup.newDescriptor((RealFigure)externalWithFont));
        checker.check(this.getProducer().create(diagramExternalLabel), true, false, false);
        Rectangle labelParent = this.eFact.createRectangle();
        labelParent.setName("LabelParent");
        Label innerWithFont = (Label)EcoreUtil.copy((EObject)externalWithFont);
        labelParent.getChildren().add((Object)innerWithFont);
        DiagramLabel diagramInnerLabel = this.eFact.createDiagramLabel();
        diagramInnerLabel.setName("DiagramInnerLabelWithFont");
        FigureDescriptor fd = DiaDefSetup.newDescriptor((RealFigure)labelParent);
        ChildAccess ca = DiaDefSetup.newAccess(fd, (RealFigure)innerWithFont);
        diagramInnerLabel.setFigure(fd);
        diagramInnerLabel.setAccessor(ca);
        checker.check(this.getProducer().create(diagramInnerLabel), true, false, false);
    }

    private TypeDeclaration parseFirstType(String classContents) {
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(classContents.toCharArray());
        p.setKind(8);
        ASTNode astNode = p.createAST(null);
        ViewmapProducersTest.assertEquals((int)15, (int)astNode.getNodeType());
        CompilationUnit cu = (CompilationUnit)astNode;
        ViewmapProducersTest.assertNull((Object)cu.getPackage());
        ViewmapProducersTest.assertTrue((cu.types().size() > 0 ? 1 : 0) != 0);
        ViewmapProducersTest.assertTrue((boolean)(cu.types().get(0) instanceof TypeDeclaration));
        return (TypeDeclaration)cu.types().get(0);
    }

    private static Node createNode(String name, RealFigure figure) {
        return ViewmapProducersTest.createNode(name, figure, null);
    }

    private static Connection createLink(String name, ConnectionFigure connectionFigure) {
        Connection connection = GMFGraphFactory.eINSTANCE.createConnection();
        connectionFigure.setName(name);
        connection.setName(name);
        connection.setFigure(DiaDefSetup.newDescriptor((RealFigure)connectionFigure));
        return connection;
    }

    private static Compartment createCompartment(String name, FigureDescriptor owner, RealFigure figure) {
        ViewmapProducersTest.assertNotNull((Object)name);
        ViewmapProducersTest.assertNotNull((Object)figure);
        Compartment result = GMFGraphFactory.eINSTANCE.createCompartment();
        result.setName(name);
        if (owner == null) {
            result.setFigure(DiaDefSetup.newDescriptor(String.valueOf(name) + "Fig", (Figure)figure));
        } else {
            result.setFigure(owner);
            result.setAccessor(DiaDefSetup.newAccess(owner, figure));
        }
        return result;
    }

    private static Node createNode(String name, RealFigure figure, Direction optionalConstaint) {
        ViewmapProducersTest.assertNotNull((Object)name);
        ViewmapProducersTest.assertNotNull((Object)figure);
        Node result = GMFGraphFactory.eINSTANCE.createNode();
        result.setName(name);
        figure.setName(name);
        result.setFigure(DiaDefSetup.newDescriptor(figure));
        if (optionalConstaint != null) {
            result.setResizeConstraint(optionalConstaint);
        }
        return result;
    }

    protected ViewmapProducer getProducer() {
        return this.myProducer;
    }

    private static Color createColor(ColorConstants color) {
        ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
        result.setValue(color);
        return result;
    }

    private class NoUselessResizeConstraintsChecker
    extends ResizeConstraintsChecker {
        public void checkViewmap(String nodeName, Viewmap v) {
            ViewmapProducersTest.assertNotNull((Object)v);
            ResizeConstraints genConstraint = (ResizeConstraints)v.find(ResizeConstraints.class);
            ViewmapProducersTest.assertNull((String)("Problem node:" + nodeName), (Object)genConstraint);
        }
    }

    private class ResizeConstraintsChecker {
        private final List<String> myExpectedNames;

        public ResizeConstraintsChecker(Direction[] expectedDirectionNames) {
            this.myExpectedNames = new ArrayList<String>(expectedDirectionNames.length);
            int i = 0;
            while (i < expectedDirectionNames.length) {
                this.myExpectedNames.add(expectedDirectionNames[i].getName());
                ++i;
            }
        }

        public ResizeConstraintsChecker(Direction theOnly) {
            this(new Direction[]{theOnly});
        }

        protected ResizeConstraintsChecker() {
            this.myExpectedNames = Collections.emptyList();
        }

        public void checkNode(Node node) {
            Viewmap viewmap = ViewmapProducersTest.this.getProducer().create(node);
            this.checkViewmap(node.getName(), viewmap);
        }

        public void checkViewmap(String nodeName, Viewmap v) {
            ViewmapProducersTest.assertNotNull((Object)v);
            ResizeConstraints genConstraint = (ResizeConstraints)v.find(ResizeConstraints.class);
            ViewmapProducersTest.assertNotNull((String)("Problem node:" + nodeName), (Object)genConstraint);
            ViewmapProducersTest.assertEquals((String)("Problem node:" + nodeName), (int)this.myExpectedNames.size(), (int)genConstraint.getResizeHandleNames().size());
            ViewmapProducersTest.assertTrue((String)("Problem node:" + nodeName), (boolean)genConstraint.getResizeHandleNames().containsAll(this.myExpectedNames));
        }
    }

    private class ViewmapLayoutTypeChecker {
        private final RealFigure myFigure;
        private final Node myNode;

        public ViewmapLayoutTypeChecker() {
            this((RealFigure)viewmapProducersTest.eFact.createRectangle(), viewmapProducersTest.eFact.createNode());
        }

        public ViewmapLayoutTypeChecker(RealFigure figure, Node node) {
            this.myFigure = figure;
            this.myFigure.setName("Figure");
            this.myNode = node;
            this.myNode.setName("Node");
            this.myNode.setFigure(DiaDefSetup.newDescriptor(this.myFigure));
        }

        public void check(Layout graphLayout, ViewmapLayoutType expected) {
            this.myFigure.setLayout(graphLayout);
            ViewmapLayoutType actual = ViewmapProducersTest.this.getProducer().create(this.myNode).getLayoutType();
            ViewmapProducersTest.assertNotNull((Object)actual);
            ViewmapProducersTest.assertEquals((Object)expected, (Object)actual);
        }
    }
}

