/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.figures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.lite.figures.SideAffixedElementPositioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideAffixedFeedbackPositioner
extends SideAffixedElementPositioner {
    private final GraphicalEditPart myHost;
    private IFigure mySiblingsParent;
    private Dimension myProposedSize;

    public SideAffixedFeedbackPositioner(GraphicalEditPart hostEditPart) {
        this.myHost = hostEditPart;
    }

    public void setSiblingsParent(IFigure figure) {
        this.mySiblingsParent = figure;
    }

    protected IFigure getSiblingsParent() {
        if (this.mySiblingsParent == null) {
            return this.myHost.getFigure();
        }
        return this.mySiblingsParent;
    }

    @Override
    public Rectangle getValidLocation(Rectangle proposedLocation) {
        this.myProposedSize = proposedLocation.getSize();
        return super.getValidLocation(proposedLocation);
    }

    @Override
    protected Dimension getBorderItemSize() {
        return this.myProposedSize == null ? new Dimension(-1, -1) : this.myProposedSize;
    }

    @Override
    protected IFigure getHostFigure() {
        return this.myHost.getFigure();
    }

    @Override
    protected Collection<? extends IFigure> getSiblings() {
        List children = this.myHost.getChildren();
        ArrayList<IFigure> result = new ArrayList<IFigure>(children.size());
        for (Object next : children) {
            IFigure nextFigure;
            GraphicalEditPart nextChild = (GraphicalEditPart)next;
            if (!nextChild.isActive() || (nextFigure = nextChild.getFigure()).getParent() != this.getSiblingsParent()) continue;
            result.add(nextChild.getFigure());
        }
        return result;
    }
}

