/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import org.eclipse.gmf.internal.xpand.editor.OawProblemHover;
import org.eclipse.gmf.internal.xpand.editor.XpandContentAssistProcessor;
import org.eclipse.gmf.internal.xpand.editor.XpandEditor;
import org.eclipse.gmf.internal.xpand.editor.scan.CommentScanner;
import org.eclipse.gmf.internal.xpand.editor.scan.ContentScanner;
import org.eclipse.gmf.internal.xpand.editor.scan.TemplateTagScanner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class XpandSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final XpandEditor editor;
    private ContentScanner contentScanner;
    private CommentScanner commentScanner;
    private TemplateTagScanner tagScanner;

    public XpandSourceViewerConfiguration(XpandEditor editor) {
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer aSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__tag", "__comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer aSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        XpandContentAssistProcessor processor = new XpandContentAssistProcessor(this.editor);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__tag");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__comment");
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(500);
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        return contentAssistant;
    }

    public String[] getIndentPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer aSourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getTemplateTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__comment");
        dr = new DefaultDamagerRepairer(this.getContentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private CommentScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new CommentScanner(this.editor.getColorProvider());
        }
        return this.commentScanner;
    }

    protected ITokenScanner getTemplateTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new TemplateTagScanner(this.editor.getColorProvider());
        }
        return this.tagScanner;
    }

    protected ITokenScanner getContentScanner() {
        if (this.contentScanner == null) {
            this.contentScanner = new ContentScanner(this.editor.getColorProvider());
        }
        return this.contentScanner;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new OawProblemHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new OawProblemHover(sourceViewer);
    }
}

