/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleModuleRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.LegacyResolverSupport;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployedImportResolver
extends DelegatingUnitResolver
implements LegacyResolverSupport {
    public static DeployedImportResolver INSTANCE = new DeployedImportResolver(DeployedImportResolver.createModulesRegistry());
    private List<BundleModuleRegistry> bundleModules;

    protected DeployedImportResolver(List<BundleModuleRegistry> bundleRegistryList) {
        if (bundleRegistryList == null) {
            throw new IllegalArgumentException();
        }
        this.bundleModules = bundleRegistryList;
        this.setParent((UnitResolver)BlackboxUnitResolver.DEFAULT);
    }

    protected List<BundleModuleRegistry> getBundleModules() {
        return this.bundleModules;
    }

    public String getPackageName(CFolder folder) {
        if (folder == null) {
            return "";
        }
        return folder.getFullPath().replace('\\', '/').replace('/', '.');
    }

    public CFile resolveImport(String importedUnitName) {
        if (importedUnitName == null || importedUnitName.length() == 0) {
            return null;
        }
        Path fullPath = new Path(String.valueOf(importedUnitName.replace('.', '/')) + ".qvto");
        for (BundleModuleRegistry nextRegistry : this.bundleModules) {
            if (importedUnitName.indexOf(nextRegistry.getBundleSymbolicName()) == 1) {
                fullPath = new Path(importedUnitName.substring(nextRegistry.getBundleSymbolicName().length() + 2));
            } else if (importedUnitName.startsWith("/")) {
                fullPath = new Path(String.valueOf(importedUnitName.substring(1).replace('.', '/')) + ".qvto");
            }
            if (!nextRegistry.fileExists((IPath)fullPath)) continue;
            return new BundleFile((IPath)fullPath, nextRegistry);
        }
        return this.resolveResourcePluginPath(importedUnitName);
    }

    public CFile resolveImport(CFile parentFile, String importedUnitName) {
        if (parentFile == null) {
            return this.resolveImport(importedUnitName);
        }
        String importedFileName = String.valueOf(importedUnitName.replace('.', '/')) + ".qvto";
        URI uri = URI.createURI((String)parentFile.toString()).trimFileExtension().trimSegments(1);
        CFile resolvedFile = null;
        while (resolvedFile == null) {
            String resolvedImportName = String.valueOf(uri.toPlatformString(true)) + '/' + importedFileName;
            resolvedFile = this.resolveImport(resolvedImportName);
            if (resolvedFile != null) {
                InputStream contents = null;
                try {
                    contents = resolvedFile.getContents();
                    if (contents.available() == 0) {
                        resolvedFile = null;
                    }
                }
                catch (Exception exception) {
                    resolvedFile = null;
                }
            }
            if (resolvedFile != null) continue;
            if (uri.segmentCount() <= 1) break;
            uri = uri.trimSegments(1);
        }
        return resolvedFile;
    }

    private CFile resolveResourcePluginPath(String importedUnitName) {
        try {
            URI uri = URI.createURI((String)importedUnitName);
            String[] segments = uri.segments();
            if (segments.length > 0 && Platform.getBundle((String)segments[0]) != null && "qvto".equals(uri.fileExtension())) {
                URI pathUri = URI.createURI((String)"");
                int i = 1;
                while (i < segments.length) {
                    pathUri = pathUri.appendSegment(segments[i]);
                    ++i;
                }
                Path ipath = new Path(pathUri.toFileString());
                BundleModuleRegistry newBundle = new BundleModuleRegistry(segments[0], Collections.singletonList(ipath));
                this.bundleModules.add(newBundle);
                return new BundleFile((IPath)ipath, newBundle);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static List<BundleModuleRegistry> createModulesRegistry() {
        final HashMap allQvtFilesMap = new HashMap();
        QvtTransformationRegistry.getInstance().getTransformations(new TransformationRegistry.Filter(){

            public boolean accept(IConfigurationElement element) {
                String qvtFilePath;
                String namespaceID = element.getNamespaceIdentifier();
                ArrayList<Path> filesValue = (ArrayList<Path>)allQvtFilesMap.get(namespaceID);
                if (filesValue == null) {
                    filesValue = new ArrayList<Path>();
                    allQvtFilesMap.put(namespaceID, filesValue);
                }
                if ((qvtFilePath = element.getAttribute("file")) != null) {
                    filesValue.add(new Path(qvtFilePath));
                }
                return false;
            }
        });
        ArrayList<BundleModuleRegistry> registryEntries = new ArrayList<BundleModuleRegistry>();
        for (String nextID : allQvtFilesMap.keySet()) {
            List qvtFiles = (List)allQvtFilesMap.get(nextID);
            registryEntries.add(new BundleModuleRegistry(nextID, (Collection)qvtFiles));
        }
        return registryEntries;
    }

    public void acceptVisitor(UnitProvider.UnitVisitor visitor, String scopeQualifiedName, int depth, boolean includeExternal) {
        throw new UnsupportedOperationException();
    }

    protected UnitProxy doResolveUnit(String qualifiedName) {
        CFile resolved = this.resolveImport(qualifiedName);
        if (resolved == null) {
            return null;
        }
        BundleFile bundleFile = (BundleFile)resolved;
        return this.createUnit(qualifiedName, DeployedImportResolver.createBundFileURI(bundleFile));
    }

    public UnitProxy resolveDeployedUnitOnly(String qualifiedName) {
        return this.doResolveUnit(qualifiedName);
    }

    public UnitProxy resolveUnit(UnitProxy fromUnit, String qualifiedName) {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        URI parentURI = fromUnit.getURI().trimSegments(1);
        IPath path = new Path(parentURI.toPlatformString(true)).append(qualifiedName.replace('.', '/'));
        URI uri = URI.createPlatformPluginURI((String)path.toString(), (boolean)false).appendFileExtension("qvto");
        while (uri.segmentCount() > 1) {
            if (!uriConverter.exists(uri, Collections.emptyMap())) {
                if (uri.segmentCount() <= 1) break;
                uri = uri.trimSegments(1);
                continue;
            }
            return this.createUnit(qualifiedName, uri);
        }
        return null;
    }

    private static URI createBundFileURI(BundleFile bundleFile) {
        return URI.createPlatformPluginURI((String)(String.valueOf(bundleFile.getBundleSymbolicName()) + "/" + bundleFile.getFullPath()), (boolean)false);
    }

    public UnitProxy createUnit(String qualifiedName, final URI uri) {
        String name = uri.trimFileExtension().lastSegment();
        String namespace = null;
        if (qualifiedName.length() > name.length()) {
            namespace = qualifiedName.substring(0, qualifiedName.length() - name.length() - 1);
        }
        return new UnitProxy(namespace, name, uri){

            public int getContentType() {
                return 0;
            }

            public UnitResolver getResolver() {
                return DeployedImportResolver.this;
            }

            public UnitContents getContents() throws IOException {
                return new UnitContents.CSTContents(){

                    public Reader getContents() throws IOException {
                        return new InputStreamReader(new ExtensibleURIConverterImpl().createInputStream(uri), ResourcesPlugin.getEncoding());
                    }
                };
            }
        };
    }
}

