/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DuplicateAwareNamedFunctionCollection {
    private final Collection<NamedFunction> _allFunctions = new HashSet<NamedFunction>();
    private final Cache<QualifiedName, Collection<NamedFunction>> _byName = new Cache<QualifiedName, Collection<NamedFunction>>(){

        @Override
        protected Collection<NamedFunction> create(QualifiedName key) {
            return new HashSet<NamedFunction>();
        }
    };

    public NamedFunction register(NamedFunction f) {
        NamedFunction result = null;
        for (NamedFunction candidate : this._byName.get(f.getName())) {
            if (!DuplicateAwareNamedFunctionCollection.haveSameSignature(f, candidate)) continue;
            this._byName.get(f.getName()).remove(candidate);
            this._allFunctions.remove(candidate);
            result = candidate;
            break;
        }
        this._byName.get(f.getName()).add(f);
        this._allFunctions.add(f);
        return result;
    }

    public boolean contains(NamedFunction f) {
        for (NamedFunction candidate : this._byName.get(f.getName())) {
            if (!DuplicateAwareNamedFunctionCollection.haveSameSignature(f, candidate)) continue;
            return true;
        }
        return false;
    }

    public Collection<NamedFunction> getFunctions() {
        return this._allFunctions;
    }

    public static boolean haveSameSignature(NamedFunction f1, NamedFunction f2) {
        if (f1.getFunction().getGuard() != null || f2.getFunction().getGuard() != null) {
            return false;
        }
        if (!f1.getName().equals(f2.getName())) {
            return false;
        }
        return f1.getFunction().getParameterTypes().equals(f2.getFunction().getParameterTypes());
    }

    public String toString() {
        return this._allFunctions.toString();
    }
}

