/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.migrationtoreq;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.requirements.sysml14.migrationtoreq.Activator;
import org.eclipse.papyrus.requirements.sysml14.migrationtoreq.MigrationFromSysML14Rules;
import org.eclipse.papyrus.sysml14.requirements.Requirement;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;

public class MigrationToSysML14Requirement {
    private static final String CMD_LABEL_APPLY_ANNOTATION_ON_UML_MODEL = "Apply Annotation on the UML model";
    private static final String ERROR_SERVICE_REAGITRY_SEARCH = "Error during the service registry search";

    public static void executeMigration(final Package rootPackage, final MigrationFromSysML14Rules migrationRules, final Profile targetProfile, final Model topModel) {
        TransactionalEditingDomain domain = MigrationToSysML14Requirement.getTransactionalEditingDomain((Element)rootPackage);
        RecordingCommand applyAnnotationCmd = new RecordingCommand(domain, CMD_LABEL_APPLY_ANNOTATION_ON_UML_MODEL){

            protected void doExecute() {
                if (!topModel.isProfileApplied(targetProfile)) {
                    PackageUtil.applyProfile((Package)topModel, (Profile)targetProfile, (boolean)true);
                }
                if (topModel.isProfileApplied(targetProfile)) {
                    MigrationToSysML14Requirement.walkThroughPackageAndApplyRules(rootPackage, migrationRules);
                }
            }
        };
        try {
            domain.getCommandStack().execute((Command)applyAnnotationCmd);
        }
        catch (IllegalArgumentException exception) {
            Activator.log.error("Error during the the migration from SysML 1.4 model to another domain model", (Throwable)exception);
        }
    }

    protected static void walkThroughPackageAndApplyRules(Package rootPackage, MigrationFromSysML14Rules migrationRules) {
        for (Element element : rootPackage.allOwnedElements()) {
            Requirement sysmlRequirement = (Requirement)UMLUtil.getStereotypeApplication((Element)element, Requirement.class);
            if (sysmlRequirement == null) continue;
            migrationRules.setRequirement(element, sysmlRequirement);
            element.unapplyStereotype(UMLUtil.getStereotype((EObject)sysmlRequirement));
        }
    }

    private static TransactionalEditingDomain getTransactionalEditingDomain(Element element) {
        TransactionalEditingDomain editingDomain = null;
        ServicesRegistry vServiceRegistry = null;
        try {
            vServiceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)element);
        }
        catch (ServiceException exception) {
            Activator.log.error(ERROR_SERVICE_REAGITRY_SEARCH, (Throwable)exception);
        }
        try {
            editingDomain = (TransactionalEditingDomain)vServiceRegistry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException exception) {
            Activator.log.error(ERROR_SERVICE_REAGITRY_SEARCH, (Throwable)exception);
        }
        return editingDomain;
    }
}

