/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.List;
import java.util.function.Function;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.osgi.framework.VersionRange;

public enum DependencyKind {
    REQUIRE_BUNDLE(IRequiredBundleDescription.class, IManifestEditor::getRequiredBundles, IRequiredBundleDescription::getName, IManifestEditor::addDependency),
    IMPORT_PACKAGE(IPackageImportDescription.class, IManifestEditor::getImportedPackages, IPackageImportDescription::getName, IManifestEditor::addImportPackage);

    private final Function<IManifestEditor, List<?>> dependenciesFunction;
    private final Function<?, String> dependencyNameFunction;
    private final DependencyUpdater dependencyUpdater;

    private <T> DependencyKind(Class<T> dependencyType, Function<IManifestEditor, List<?>> dependenciesFunction, Function<T, String> dependencyNameFunction, DependencyUpdater dependencyUpdater) {
        this.dependenciesFunction = dependenciesFunction;
        this.dependencyNameFunction = dependencyNameFunction;
        this.dependencyUpdater = dependencyUpdater;
    }

    String getVersionAttribute() {
        return this == REQUIRE_BUNDLE ? "bundle-version" : "version";
    }

    static DependencyKind forHeader(String headerName) {
        switch (headerName) {
            case "Require-Bundle": {
                return REQUIRE_BUNDLE;
            }
            case "Import-Package": {
                return IMPORT_PACKAGE;
            }
        }
        throw new IllegalArgumentException(headerName);
    }

    public List<?> getDependencies(IManifestEditor manifest) {
        return this.dependenciesFunction.apply(manifest);
    }

    public String getDependencyName(Object dependency) {
        return this.dependencyNameFunction.apply(dependency);
    }

    public void setDependencyRange(IManifestEditor manifest, String dependencyName, VersionRange range) {
        this.dependencyUpdater.setDependencyRange(manifest, dependencyName, range.toString());
    }

    @FunctionalInterface
    private static interface DependencyUpdater {
        public void setDependencyRange(IManifestEditor var1, String var2, String var3);
    }
}

