/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ProjectManagementUtils;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class ElementTypesPluginXMLValidator {
    static final String CATEGORY = "element_types";
    private static final String EXTPT_ELEMENT_TYPE_BINDINGS = "org.eclipse.gmf.runtime.emf.type.core.elementTypeBindings";
    private static final String ELEM_CLIENT_CONTEXT = "clientContext";
    private static final String ATT_ID = "id";
    private final IFile modelFile;

    ElementTypesPluginXMLValidator(IFile modelFile) {
        this.modelFile = modelFile;
    }

    Optional<Element> matchExtension(Element element, String point, ElementTypeSetConfiguration model) {
        switch (point) {
            case "org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration": {
                NodeList children = element.getElementsByTagName("elementTypeSet");
                int i = 0;
                while (i < children.getLength()) {
                    Element typeSet = (Element)children.item(i);
                    if (this.matchElementTypeSet(typeSet, model)) {
                        return Optional.of(typeSet);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    boolean matchElementTypeSet(Element element, ElementTypeSetConfiguration model) {
        String path = element.getAttribute("path");
        return Objects.equals(path, this.modelFile.getProjectRelativePath().toString());
    }

    void checkExtension(Element element, String point, ElementTypeSetConfiguration model, PluginErrorReporter.ProblemReport problems) {
        switch (element.getTagName()) {
            case "elementTypeSet": {
                String clientContextID = element.getAttribute("clientContextID");
                if (clientContextID == null || clientContextID.isBlank()) {
                    problems.reportProblem(4, element, Messages.ElementTypesPluginXMLValidator_0, 16715841, CATEGORY, null);
                    break;
                }
                if (this.findArchitectureContext(clientContextID) || this.findGMFClientContext(clientContextID)) break;
                problems.reportProblem(2, element, NLS.bind((String)Messages.ElementTypesPluginXMLValidator_1, (Object)clientContextID), 16715842, CATEGORY, null);
                break;
            }
        }
    }

    private boolean findArchitectureContext(String id) {
        return ArchitectureDomainManager.getInstance().getArchitectureContextById(id) != null;
    }

    private boolean findGMFClientContext(String id) {
        return ElementTypesPluginXMLValidator.getClientContextRegistration(id).isPresent();
    }

    public static Optional<IPluginElement> getClientContextRegistration(String clientContextID) {
        return ProjectManagementUtils.findExtensionElement((String)EXTPT_ELEMENT_TYPE_BINDINGS, (String)ELEM_CLIENT_CONTEXT, (String[])new String[]{ATT_ID, clientContextID});
    }

    int problemID(String point, ElementTypeSetConfiguration typesSet) {
        switch (point) {
            case "org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration": {
                return 16715840;
            }
        }
        return -1;
    }
}

