/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.listeners.StereotypeElementListener;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypePropertyReferenceEdgeCleaningEditPolicy
extends AbstractEditPolicy
implements EditPolicy,
NotificationListener {
    private String featureToSet;
    private String stereotypeQualifyName;
    public static final String EDIT_POLICY_KEY = "REMOVE_INVALID_STEREOTYPE_REFERENCE_EDGE_EDIT_POLICY";

    public void activate() {
        Edge edge = (Edge)this.getHost().getModel();
        EAnnotation eAnnotation = edge.getEAnnotation("StereotypePropertyReferenceEdge");
        if (eAnnotation != null) {
            this.stereotypeQualifyName = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
            this.featureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
        }
        DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
        diagramEventBroker.addNotificationListener((EObject)this.getSourceElement(), (NotificationListener)this);
        diagramEventBroker.addNotificationListener((EObject)this.getTargetElement(), (NotificationListener)this);
        if (this.stereotypeQualifyName == null || this.featureToSet == null || !this.checkSourceStereotype() || !this.checkTargetStereotype()) {
            this.destroyView();
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getTargetElement() {
        Edge edge = (Edge)this.getHost().getModel();
        View target = edge.getTarget();
        return target == null ? null : (Element)target.getElement();
    }

    protected Element getSourceElement() {
        Edge edge = (Edge)this.getHost().getModel();
        View source = edge.getSource();
        return source == null ? null : (Element)source.getElement();
    }

    private boolean checkTargetStereotype() {
        boolean targetOk = false;
        Stereotype sourceStereotype = this.getSourceElement().getApplicableStereotype(this.stereotypeQualifyName);
        Property attribute = sourceStereotype.getAttribute(this.featureToSet, null);
        if (attribute != null) {
            Type targetType = attribute.getType();
            targetOk = targetType instanceof Stereotype ? ElementUtil.hasStereotypeApplied((Element)this.getTargetElement(), (String)targetType.getQualifiedName()) : true;
        }
        return targetOk;
    }

    public boolean checkSourceStereotype() {
        return this.getSourceElement() != null && ElementUtil.hasStereotypeApplied((Element)this.getSourceElement(), (String)this.stereotypeQualifyName);
    }

    public void notifyChanged(Notification notification) {
        if (!(!(notification instanceof StereotypeElementListener.StereotypeExtensionNotification) || this.getSourceElement() == null || this.getTargetElement() == null || this.stereotypeQualifyName != null && this.featureToSet != null && this.checkSourceStereotype() && this.checkTargetStereotype())) {
            this.destroyView();
        }
    }

    protected Command getDeleteViewCommand(View view) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, view));
    }

    protected void destroyView() {
        Command deleteViewCommand;
        EditPart host = this.getHost();
        View view = (View)host.getModel();
        if (host instanceof IGraphicalEditPart && (deleteViewCommand = this.getDeleteViewCommand(view)) != null && deleteViewCommand.canExecute()) {
            this.executeCommand(deleteViewCommand);
        }
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.undo();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getSourceElement(), (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getTargetElement(), (NotificationListener)this);
    }
}

