/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.sorting;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import java.text.Collator;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.editor.welcome.nattable.ServiceConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.widgets.Text;

public class ColumnHeaderHelper<T> {
    private final IConfigRegistry configRegistry;
    private final ILayer viewportLayer;
    private final SelectionLayer selectionLayer;
    private IColumnPropertyAccessor<T> columnAccessor;
    private IDataProvider headerProvider;
    private DataLayer headerData;
    private SortHeaderLayer<T> sortHeaders;
    private SortedList<T> sortedData;
    private FilterMatcherEditor filterMatcher;

    public ColumnHeaderHelper(IConfigRegistry configRegistry, ILayer viewportLayer, SelectionLayer selectionLayer) {
        this.configRegistry = configRegistry;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    public ILayer createHeaderLayer(SortedList<T> data, IColumnPropertyAccessor<T> columnAccessor, String ... columnHeadings) {
        this.columnAccessor = columnAccessor;
        this.sortedData = data;
        this.headerProvider = new DefaultColumnHeaderDataProvider(columnHeadings);
        this.headerData = new DataLayer(this.headerProvider);
        ColumnHeaderLayer headers = new ColumnHeaderLayer((IUniqueIndexLayer)this.headerData, this.viewportLayer, this.selectionLayer);
        GlazedListsSortModel sortModel = new GlazedListsSortModel(this.sortedData, columnAccessor, this.configRegistry, (ILayer)this.headerData);
        this.sortHeaders = new SortHeaderLayer((ILayer)headers, (ISortModel)sortModel, false);
        return this.sortHeaders;
    }

    public FilterRowHeaderComposite<T> createFilterLayer(FilterList<T> filteredData) {
        DefaultGlazedListsStaticFilterStrategy filterStrategy = new DefaultGlazedListsStaticFilterStrategy(filteredData, this.columnAccessor, this.configRegistry);
        this.filterMatcher = new FilterMatcherEditor();
        filterStrategy.addStaticFilter((MatcherEditor)this.filterMatcher);
        FilterRowHeaderComposite result = new FilterRowHeaderComposite((IFilterStrategy)filterStrategy, this.sortHeaders, this.headerProvider, this.configRegistry);
        result.setFilterRowVisible(false);
        return result;
    }

    public void configureSorting() {
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)this.headerData);
        this.headerData.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        int i = 0;
        while (i < this.columnAccessor.getColumnCount()) {
            String label = this.sortLabel(i);
            labelAccumulator.registerColumnOverrides(i, new String[]{label});
            this.configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, this.getByLabelOrdering(), DisplayMode.NORMAL, label);
            ++i;
        }
    }

    public void configureHeaders(ICellPainter cellPainter, IStyle style) {
        this.sortHeaders.addConfiguration((IConfiguration)new SingleClickSortConfiguration((ICellPainter)new SortableHeaderTextPainter(cellPainter, CellEdgeEnum.LEFT, true, 3, true)));
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter, DisplayMode.NORMAL, "COLUMN_HEADER");
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, DisplayMode.NORMAL, "COLUMN_HEADER");
        int i = 0;
        while (i < this.columnAccessor.getColumnCount()) {
            String label = this.sortLabel(i);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter, DisplayMode.NORMAL, label);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, DisplayMode.NORMAL, label);
            ++i;
        }
    }

    String sortLabel(int columnIndex) {
        return ColumnHeaderHelper.sortLabel(this.columnAccessor.getColumnProperty(columnIndex));
    }

    static String sortLabel(String propertyName) {
        return "sortBy:" + propertyName;
    }

    private Comparator<Object> getByLabelOrdering() {
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        return (a, b) -> collator.compare(this.getLabel(a), this.getLabel(b));
    }

    private String getLabel(Object object) {
        LabelProviderService labels = ServiceConfigAttributes.getService(LabelProviderService.class, this.configRegistry, DisplayMode.NORMAL, new String[0]);
        Object value = object instanceof IObservableValue ? ((IObservableValue)object).getValue() : object;
        ILabelProvider labelProvider = value == null ? null : labels.getLabelProvider(value);
        return labelProvider == null ? null : labelProvider.getText(value);
    }

    public void setFilterField(Text filterField) {
        if (filterField != null) {
            filterField.addModifyListener(__ -> this.filterMatcher.setFilter(filterField.getText()));
        }
    }

    class FilterMatcherEditor
    extends AbstractMatcherEditor<T> {
        FilterMatcherEditor() {
        }

        void setFilter(String filterText) {
            ca.odell.glazedlists.matchers.Matcher matcher = Matchers.trueMatcher();
            if (filterText != null && !filterText.isEmpty()) {
                filterText = filterText.replaceAll("\\*{2,}", "*");
                String[] sections = filterText.split("\\*");
                Pattern pattern = Pattern.compile(Stream.of(sections).map(Pattern::quote).collect(Collectors.joining(".*")), 2);
                Matcher regex = pattern.matcher("");
                matcher = item -> {
                    boolean match = false;
                    int cols = ColumnHeaderHelper.this.columnAccessor.getColumnCount();
                    int i = 0;
                    while (!match && i < cols) {
                        String label = ColumnHeaderHelper.this.getLabel(ColumnHeaderHelper.this.columnAccessor.getDataValue(item, i));
                        if (label != null) {
                            regex.reset(label);
                            match = regex.find();
                        }
                        ++i;
                    }
                    return match;
                };
            }
            this.fireChanged(matcher);
            ColumnHeaderHelper.this.viewportLayer.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent(ColumnHeaderHelper.this.viewportLayer));
        }
    }
}

