/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.diagram.common.sheet.ImageLocationCellEditor;
import org.eclipse.uml2.diagram.common.sheet.ReferenceDialogCellEditor;
import org.eclipse.uml2.diagram.common.sheet.chooser.MultiReferenceElementChooserDialog;
import org.eclipse.uml2.diagram.common.sheet.chooser.ReferencedElementChooserDialog;
import org.eclipse.uml2.uml.UMLPackage;

public class ReferencePropertyDescriptor
extends PropertyDescriptor {
    private final AdapterFactory myItemProvidersAdapterFactory;
    private final IDialogSettings myDialogSettings;
    private final IPreferenceStore myPreferenceStore;
    private final IItemPropertyDescriptor myItemPropertyDescriptor;
    private final Object mySourceObject;

    public ReferencePropertyDescriptor(Object sourceObject, IItemPropertyDescriptor itemPropertyDescriptor, AdapterFactory itemProvidersAdapterFactory, IDialogSettings dialogSettings, IPreferenceStore store) {
        super(sourceObject, itemPropertyDescriptor);
        this.mySourceObject = sourceObject;
        this.myItemPropertyDescriptor = itemPropertyDescriptor;
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
        this.myDialogSettings = dialogSettings;
        this.myPreferenceStore = store;
    }

    public CellEditor createPropertyEditor(final Composite composite) {
        final EStructuralFeature feature = (EStructuralFeature)this.myItemPropertyDescriptor.getFeature(this.mySourceObject);
        if (UMLPackage.eINSTANCE.getImage_Location().equals(feature)) {
            return new ImageLocationCellEditor((EObject)this.object, composite, this.getEditLabelProvider());
        }
        if (this.itemPropertyDescriptor.getFeature(this.object) instanceof EReference && !this.myItemPropertyDescriptor.getChoiceOfValues(this.mySourceObject).isEmpty()) {
            if (this.itemPropertyDescriptor.isMany(this.object)) {
                return new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        MultiReferenceElementChooserDialog dialog = new MultiReferenceElementChooserDialog(composite.getShell(), ReferencePropertyDescriptor.this.myDialogSettings, ReferencePropertyDescriptor.this.myItemProvidersAdapterFactory, (EObject)ReferencePropertyDescriptor.this.object, feature);
                        dialog.open();
                        return dialog.getResult();
                    }
                };
            }
            if (this.useDialogNotComboCellEditor()) {
                ReferencedElementChooserDialog dialog = new ReferencedElementChooserDialog(composite.getShell(), this.myDialogSettings, this.myItemProvidersAdapterFactory, (EObject)this.object, feature);
                Collection choiceOfValues = this.myItemPropertyDescriptor.getChoiceOfValues(this.mySourceObject);
                return new ReferenceDialogCellEditor(composite, dialog, choiceOfValues, this.getLabelProvider());
            }
        }
        return super.createPropertyEditor(composite);
    }

    private boolean useDialogNotComboCellEditor() {
        String value = this.myPreferenceStore.getString("propertysheet.reference");
        if (value == null || "".equals(value)) {
            return true;
        }
        return "propertysheet.reference.dialog".equals(value);
    }
}

