/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.stereo.ApplyProfileAction;
import org.eclipse.uml2.diagram.common.stereo.ApplyProfileInfoAction;
import org.eclipse.uml2.diagram.common.stereo.ProfileRegistry;
import org.eclipse.uml2.diagram.common.stereo.ProfileUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicableProfilesItemProvider
extends AbstractContributionItemProvider
implements IProvider {
    public static final String MENU_APPLY_PROFILE = "menu_apply_unapply_profile";

    protected IMenuManager createMenuManager(String menuId, IWorkbenchPartDescriptor partDescriptor) {
        if (!MENU_APPLY_PROFILE.equals(menuId)) {
            return super.createMenuManager(menuId, partDescriptor);
        }
        MenuManager menuManager = new MenuManager(Messages.ApplicableProfilesItemProvider_apply_profile_menu);
        MenuBuilder builder = new MenuBuilder(partDescriptor);
        builder.buildMenu((IMenuManager)menuManager);
        menuManager.addMenuListener((IMenuListener)builder);
        return menuManager;
    }

    private List<Profile> getProfiles(Package package_) {
        ArrayList<Profile> choiceOfValues = new ArrayList<Profile>();
        ResourceSet resourceSet = package_.eResource().getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            Profile profile = ProfileUtil.getProfile(resource);
            if (profile == null) continue;
            choiceOfValues.add(profile);
        }
        return choiceOfValues;
    }

    private Collection<ProfileRegistry.ProfileInfo> getProfilesFromRegistry(Package package_) {
        return ProfileRegistry.getInstance().getProfiles();
    }

    private class MenuBuilder
    implements IMenuListener {
        private final IWorkbenchPartDescriptor myWorkbenchPart;

        public MenuBuilder(IWorkbenchPartDescriptor workbenchPart) {
            this.myWorkbenchPart = workbenchPart;
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.buildMenu(manager);
        }

        public void buildMenu(IMenuManager manager) {
            manager.removeAll();
            GraphicalEditPart selected = (GraphicalEditPart)ApplicableProfilesItemProvider.this.getSelectedObject(this.myWorkbenchPart);
            Package package_ = (Package)selected.getNotationView().getElement();
            this.loadProfilesFromUML2Registry(package_);
            List profiles = ApplicableProfilesItemProvider.this.getProfiles(package_);
            for (Profile profile : profiles) {
                ApplyProfileAction action = new ApplyProfileAction(this.getWorkbenchPage(), package_, profile);
                action.init();
                manager.add((IAction)action);
            }
            Collection profilesFromRegistry = ApplicableProfilesItemProvider.this.getProfilesFromRegistry(package_);
            ArrayList<String> loadedProfileUris = new ArrayList<String>(profiles.size());
            for (Profile profile : profiles) {
                loadedProfileUris.add(EcoreUtil.getURI((EObject)profile).toString());
            }
            for (ProfileRegistry.ProfileInfo profileInfo : profilesFromRegistry) {
                if (loadedProfileUris.contains(profileInfo.uri)) continue;
                ApplyProfileInfoAction action = new ApplyProfileInfoAction(this.getWorkbenchPage(), package_, profileInfo);
                action.init();
                manager.add((IAction)action);
            }
        }

        private void loadProfilesFromUML2Registry(Package package_) {
            ResourceSet resourceSet = package_.eResource().getResourceSet();
            for (URI profileURI : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
                try {
                    resourceSet.getResource(profileURI.trimFragment(), true);
                }
                catch (Exception exception) {}
            }
        }

        private IWorkbenchPage getWorkbenchPage() {
            return this.myWorkbenchPart.getPartPage();
        }
    }
}

