/*******************************************************************************
 * Copyright (c) 2018, 2019 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.qvtd.atl.atl2qvtr.utilities;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.m2m.atl.common.ATL.Module;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractTernaryOperation;

public class Helper4getPackage extends AbstractTernaryOperation
{
	public static final @NonNull Helper4getPackage INSTANCE = new Helper4getPackage();

	@Override
	public org.eclipse.ocl.pivot.@Nullable Package evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object selfValue, @Nullable Object sourceValue, @Nullable Object argumentValue) {
		Module atlModule = (Module)sourceValue;
		assert atlModule != null;
		assert argumentValue != null;
		return HelperUtils.getPackage(executor, atlModule, (String) argumentValue);
	}
}
