/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownTypesScope
extends AbstractScope {
    private final List<JvmType> types;
    private final AbstractScope parent;

    public KnownTypesScope(List<JvmType> types, AbstractScope parent) {
        this.types = types;
        this.parent = parent;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return result;
        }
        return this.parent.getSingleElement(name);
    }

    protected IEObjectDescription doGetSingleElement(QualifiedName name) {
        JvmType result = null;
        int index = -1;
        String firstSegment = name.getFirstSegment();
        int dollar = firstSegment.indexOf(36);
        if (dollar > 0) {
            firstSegment = firstSegment.substring(0, dollar);
        }
        int i = 0;
        while (i < this.types.size()) {
            JvmType type = this.types.get(i);
            JvmType exactMatch = this.getExactMatch(type, index, name);
            if (exactMatch != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)exactMatch);
            }
            if (this.isMatch(i, type, firstSegment, name)) {
                JvmType resolved = this.getUnambiguousResult(result, index, type, i, name);
                if (resolved == null) {
                    return null;
                }
                if (resolved != result) {
                    result = type;
                    index = i;
                }
            }
            ++i;
        }
        if (result != null) {
            JvmType actualResult;
            JvmType jvmType = actualResult = dollar > 0 || name.getSegmentCount() > 0 ? this.findNestedType(result, index, name) : result;
            if (actualResult != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)actualResult);
            }
        }
        return null;
    }

    protected JvmType getExactMatch(JvmType type, int index, QualifiedName name) {
        QualifiedName typeName = QualifiedName.create((List)Strings.split((String)type.getQualifiedName(), (char)'.'));
        if (name.equals((Object)typeName)) {
            return type;
        }
        if (name.startsWith(typeName)) {
            JvmType result = this.findNestedType(type, index, name.skipFirst(typeName.getSegmentCount() - 1));
            return result;
        }
        if (name.getSegmentCount() > typeName.getSegmentCount() && typeName.skipLast(1).equals((Object)name.skipLast(1)) && typeName.getLastSegment().equals(name.skipFirst(typeName.getSegmentCount() - 1).toString("$"))) {
            return type;
        }
        return null;
    }

    protected JvmType getUnambiguousResult(JvmType current, int currentIndex, JvmType next, int nextIndex, QualifiedName name) {
        if (current != null && current != next) {
            return null;
        }
        return next;
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        int i = 0;
        while (i < this.types.size()) {
            JvmType knownType = this.types.get(i);
            if (EcoreUtil.isAncestor((EObject)knownType, (EObject)type)) {
                this.doGetDescriptions(type, knownType, i, result);
            }
            ++i;
        }
        this.parent.doGetElements(type, result);
    }

    protected void doGetDescriptions(JvmType type, JvmType knownType, int i, List<IEObjectDescription> result) {
        if (type == knownType) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)type.getSimpleName()), (EObject)type));
        } else if (type.eContainer() == knownType) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String[])new String[]{knownType.getSimpleName(), type.getSimpleName()}), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)(String.valueOf(knownType.getSimpleName()) + '$' + type.getSimpleName())), (EObject)type));
        } else {
            String knownTypeName = knownType.getQualifiedName();
            String withDollar = type.getQualifiedName('$');
            String withDot = type.getQualifiedName('.');
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((List)Strings.split((String)withDot.substring(knownTypeName.length()), (char)'.')), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)withDollar.substring(knownTypeName.length())), (EObject)type));
        }
    }

    protected JvmType findNestedType(JvmType result, int index, QualifiedName name) {
        List segments = name.getSegmentCount() == 1 ? Strings.split((String)name.getFirstSegment(), (char)'$') : name.getSegments();
        int i = 1;
        while (i < segments.size() && result instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)result;
            String simpleName = (String)segments.get(i);
            for (JvmMember member : declaredType.getMembers()) {
                if (!(member instanceof JvmType) || !simpleName.equals(member.getSimpleName())) continue;
                result = (JvmType)member;
                break;
            }
            if (declaredType == result) {
                return null;
            }
            ++i;
        }
        return result;
    }

    protected boolean isMatch(int index, JvmType type, String simpleName, QualifiedName relativeName) {
        return simpleName.equals(type.getSimpleName());
    }
}

