/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.LookAheadInfo;
import org.eclipse.xtext.nodemodel.impl.InvariantChecker;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.testing.GlobalRegistries;
import org.eclipse.xtext.testing.serializer.SerializerTestHelper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

@Beta
public abstract class AbstractXtextTests
extends Assert {
    private Injector injector;
    private boolean canCreateInjector;
    private boolean isSerializerTestDisabled = false;
    private GlobalRegistries.GlobalStateMemento globalStateMemento;
    public static final int EXPECT_ERRORS = -2;
    public static final int UNKNOWN_EXPECTATION = Integer.MIN_VALUE;

    static {
        GlobalRegistries.initializeDefaults();
    }

    @Before
    public void setUp() throws Exception {
        this.canCreateInjector = true;
        this.isSerializerTestDisabled = false;
        this.globalStateMemento = GlobalRegistries.makeCopyOfGlobalState();
    }

    @After
    public void tearDown() throws Exception {
        this.injector = null;
        this.isSerializerTestDisabled = false;
        this.globalStateMemento.restoreGlobalState();
    }

    public String serialize(EObject obj) {
        return this.getSerializer().serialize(obj);
    }

    protected void with(Module ... modules) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        this.setInjector(Guice.createInjector((Module[])modules));
    }

    protected void with(Class<? extends ISetup> setupClazz) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        ISetup instance = setupClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.setInjector(instance.createInjectorAndDoEMFRegistration());
    }

    public void with(ISetup setup) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        this.setInjector(setup.createInjectorAndDoEMFRegistration());
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    public final Injector getInjector() {
        if (this.injector == null) {
            throw new IllegalStateException("No injector set. Did you forget to call something like 'with(new YourStadaloneSetup())'?");
        }
        return this.injector;
    }

    public <T> T get(Class<T> clazz) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        return (T)this.injector.getInstance(clazz);
    }

    public <T> T get(Key<T> key) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        return (T)this.injector.getInstance(key);
    }

    public void injectMembers(Object object) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        this.injector.injectMembers(object);
    }

    protected IParser getParser() {
        return (IParser)this.getInjector().getInstance(IParser.class);
    }

    protected ILinkingService getLinkingService() {
        return (ILinkingService)this.getInjector().getInstance(ILinkingService.class);
    }

    protected IAstFactory getASTFactory() {
        return (IAstFactory)this.getInjector().getInstance(IAstFactory.class);
    }

    protected IGrammarAccess getGrammarAccess() {
        return (IGrammarAccess)this.getInjector().getInstance(IGrammarAccess.class);
    }

    protected IResourceFactory getResourceFactory() {
        return (IResourceFactory)this.getInjector().getInstance(IResourceFactory.class);
    }

    protected IValueConverterService getValueConverterService() {
        return (IValueConverterService)this.getInjector().getInstance(IValueConverterService.class);
    }

    protected ISerializer getSerializer() {
        return (ISerializer)this.getInjector().getInstance(ISerializer.class);
    }

    protected INodeModelFormatter getNodeModelFormatter() {
        return (INodeModelFormatter)this.getInjector().getInstance(INodeModelFormatter.class);
    }

    protected IScopeProvider getScopeProvider() {
        return (IScopeProvider)this.getInjector().getInstance(IScopeProvider.class);
    }

    protected InvariantChecker getInvariantChecker() {
        return (InvariantChecker)this.getInjector().getInstance(InvariantChecker.class);
    }

    protected InputStream getAsStream(String model) {
        return this.getAsStream(model, Charset.defaultCharset());
    }

    protected InputStream getAsStream(String model, Charset encoding) {
        return new LazyStringInputStream(model, encoding.name());
    }

    public EObject getModel(String model) throws Exception {
        return this.getModel(this.getAsStream(model));
    }

    public final EObject getModel(InputStream model) throws Exception {
        XtextResource resource = this.getResource(model);
        return this.getModel(resource);
    }

    public final EObject getModelAndExpect(String model, int errors) throws Exception {
        return this.getModelAndExpect(this.getAsStream(model), errors);
    }

    public final EObject getModelAndExpect(InputStream model, int errors) throws Exception {
        XtextResource resource = this.getResourceAndExpect(model, errors);
        return this.getModel(resource);
    }

    protected EObject getModel(XtextResource resource) {
        return resource.getParseResult().getRootASTElement();
    }

    protected final XtextResource getResourceFromString(String model) throws Exception {
        return this.getResource(this.getAsStream(model));
    }

    protected final XtextResource getResourceFromStringAndExpect(String model, int errors) throws Exception {
        return this.getResourceAndExpect(this.getAsStream(model), errors);
    }

    public final XtextResource getResource(InputStream in) throws Exception {
        return this.getResource(in, URI.createURI((String)("mytestmodel." + this.getCurrentFileExtension())));
    }

    protected String getCurrentFileExtension() {
        String instance = (String)this.getInjector().getInstance(Key.get(String.class, (Annotation)Names.named((String)"file.extensions")));
        if (instance.indexOf(44) == -1) {
            return instance;
        }
        return instance.split(",")[0];
    }

    public final XtextResource getResourceFor(InputStream stream) {
        try {
            return this.getResourceAndExpect(stream, Integer.MIN_VALUE);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final XtextResource getResourceAndExpect(InputStream in, int errors) throws Exception {
        return this.getResourceAndExpect(in, this.getTestModelURI(), errors);
    }

    protected URI getTestModelURI() {
        return URI.createURI((String)("mytestmodel." + this.getCurrentFileExtension()));
    }

    public final XtextResource getResource(InputStream in, URI uri) throws Exception {
        return this.getResourceAndExpect(in, uri, 0);
    }

    public final XtextResource getResource(String contents, String uri) throws Exception {
        return this.getResource(this.getAsStream(contents), URI.createURI((String)uri));
    }

    public final XtextResource getResourceAndExpect(InputStream in, URI uri, int expectedErrors) throws Exception {
        XtextResource resource = this.doGetResource(in, uri);
        this.checkNodeModel(resource);
        if (expectedErrors != Integer.MIN_VALUE) {
            if (expectedErrors == -2) {
                AbstractXtextTests.assertFalse((String)Joiner.on((char)'\n').join((Iterable)resource.getErrors()), (boolean)resource.getErrors().isEmpty());
            } else {
                AbstractXtextTests.assertEquals((String)Joiner.on((char)'\n').join((Iterable)resource.getErrors()), (long)expectedErrors, (long)resource.getErrors().size());
            }
        }
        for (Resource.Diagnostic d : resource.getErrors()) {
            if (!(d instanceof ExceptionDiagnostic)) continue;
            AbstractXtextTests.fail((String)d.getMessage());
        }
        if (expectedErrors == 0 && resource.getContents().size() > 0 && this.shouldTestSerializer(resource)) {
            SerializerTestHelper tester = this.get(SerializerTestHelper.class);
            EObject obj = (EObject)resource.getContents().get(0);
            tester.assertSerializeWithNodeModel(obj);
            tester.assertSerializeWithoutNodeModel(obj);
        }
        return resource;
    }

    protected void checkNodeModel(XtextResource resource) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ICompositeNode rootNode = parseResult.getRootNode();
            this.getInvariantChecker().checkInvariant((INode)rootNode);
            new LookAheadInfo(rootNode).checkConsistency();
        }
    }

    protected boolean shouldTestSerializer(XtextResource resource) {
        return !this.isSerializerTestDisabled && !"org.eclipse.xtext.Xtext".equals(resource.getLanguageName());
    }

    protected void disableSerializerTest() {
        this.isSerializerTestDisabled = true;
    }

    protected Object getClasspathURIContext() {
        return ((Object)((Object)this)).getClass();
    }

    protected XtextResource doGetResource(InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = this.get(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClasspathURIContext());
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }

    protected final ICompositeNode getRootNode(InputStream model) throws Exception {
        XtextResource resource = this.getResource(model);
        return this.getRootNode(resource);
    }

    protected final ICompositeNode getRootNodeAndExpect(InputStream model, int errors) throws Exception {
        XtextResource resource = this.getResourceAndExpect(model, errors);
        return this.getRootNode(resource);
    }

    protected final ICompositeNode getRootNode(XtextResource resource) {
        return resource.getParseResult().getRootNode();
    }

    protected final IParseResult getParseResult(String model) throws Exception {
        return this.getResourceFromString(model).getParseResult();
    }

    protected final IParseResult getParseResultAndExpect(String model, int errors) throws Exception {
        return this.getResourceFromStringAndExpect(model, errors).getParseResult();
    }

    protected final ICompositeNode getRootNode(String model) throws Exception {
        return this.getRootNode(this.getAsStream(model));
    }

    protected final ICompositeNode getRootNodeAndExpect(String model, int errors) throws Exception {
        return this.getRootNodeAndExpect(this.getAsStream(model), errors);
    }

    protected String readFileIntoString(String filePath) throws IOException {
        block9: {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            URL url = classLoader.getResource(filePath);
            if (url == null) {
                AbstractXtextTests.fail((String)("Could not read resource: '" + filePath + "'. Is your file system case sensitive?"));
            } else {
                String canonicalPath = new File(new File(url.getPath()).getCanonicalPath()).toURI().getPath();
                if (!canonicalPath.endsWith(filePath)) {
                    throw new RuntimeException(filePath + " -> " + canonicalPath + ":\nThe file does not exist exactly as it was named.\nThe test is likely to cause trouble on the build server.\nIs your filesystem case insensitive? Please verify the spelling.");
                }
                try (InputStream resourceAsStream = classLoader.getResourceAsStream(filePath);){
                    String model;
                    if (resourceAsStream == null) {
                        AbstractXtextTests.fail((String)("Could not read resource: '" + filePath + "'. Is your file system case sensitive?"));
                        break block9;
                    }
                    byte[] buffer = new byte[2048];
                    int bytesRead = 0;
                    StringBuffer b = new StringBuffer();
                    do {
                        if ((bytesRead = resourceAsStream.read(buffer)) == -1) continue;
                        b.append(new String(buffer, 0, bytesRead));
                    } while (bytesRead != -1);
                    String string = model = b.toString();
                    return string;
                }
            }
        }
        throw new IllegalStateException("May not happen, but helps to suppress false positives in eclipse' control flow analysis.");
    }

    protected Grammar load(URI uri) {
        XtextResourceSet rs = new XtextResourceSet();
        return (Grammar)rs.getResource(uri, true).getContents().get(0);
    }

    protected List<Pair<EObject, ICompositeNode>> detachNodeModel(EObject eObject) {
        EcoreUtil.resolveAll((EObject)eObject);
        ArrayList result = Lists.newArrayList();
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)eObject.eResource(), (boolean)false);
        block0: while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            Iterator adapters = object.eAdapters().iterator();
            while (adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof ICompositeNode)) continue;
                adapters.remove();
                result.add(Tuples.create((Object)object, (Object)((ICompositeNode)adapter)));
                continue block0;
            }
        }
        return result;
    }

    public static final class Keys {
        private static final TypeLiteral<Provider<XtextResourceSet>> resourceSetLiteral = new TypeLiteral<Provider<XtextResourceSet>>(){};
        public static final Key<Provider<XtextResourceSet>> RESOURCE_SET_KEY = Key.get(resourceSetLiteral);
    }
}

