/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.util;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class InMemoryURIHandler
implements URIHandler {
    public static final String SCHEME = "inmemory";
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<URI, InMemFile> files = CollectionLiterals.newHashMap();

    public boolean canHandle(URI uri) {
        String _scheme = uri.scheme();
        return Objects.equal((Object)_scheme, (Object)SCHEME);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return CollectionLiterals.emptyMap();
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getInMemoryFile(uri).createInputStream();
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getInMemoryFile(uri).createOutputstream();
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        InMemFile _inMemoryFile = this.getInMemoryFile(uri);
        _inMemoryFile.exists = false;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.getInMemoryFile(uri).exists;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return CollectionLiterals.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }

    public InMemFile getInMemoryFile(URI uri) {
        InMemFile result = this.files.get(uri);
        if (result == null) {
            InMemFile _inMemFile;
            result = _inMemFile = new InMemFile(uri);
            this.files.put(uri, result);
        }
        return result;
    }

    @Pure
    public Map<URI, InMemFile> getFiles() {
        return this.files;
    }

    @Accessors
    @FinalFieldsConstructor
    public static class InMemFile {
        private final URI uri;
        private byte[] contents;
        private boolean exists;

        public OutputStream createOutputstream() {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    InMemFile.access$002(this, this.toByteArray());
                    exists = true;
                }
            };
        }

        public InputStream createInputStream() {
            try {
                if (this.contents == null || !this.exists) {
                    throw new IOException("File " + this.uri + " does not exist.");
                }
                return new ByteArrayInputStream(this.contents);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public InMemFile(URI uri) {
            this.uri = uri;
        }

        @Pure
        public URI getUri() {
            return this.uri;
        }

        @Pure
        public byte[] getContents() {
            return this.contents;
        }

        public void setContents(byte[] contents) {
            this.contents = contents;
        }

        @Pure
        public boolean isExists() {
            return this.exists;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }

        static /* synthetic */ byte[] access$002(InMemFile x0, byte[] x1) {
            x0.contents = x1;
            return x1;
        }
    }
}

