/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EOF;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.util.internal.CodeGenUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.AbstractValidationMessageAcceptor;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.GrammarWithoutLeftRecursionInspector;
import org.eclipse.xtext.xtext.KeywordInspector;
import org.eclipse.xtext.xtext.OverriddenValueInspector;
import org.eclipse.xtext.xtext.PredicateUsesUnorderedGroupInspector;
import org.eclipse.xtext.xtext.RuleWithoutInstantiationInspector;
import org.eclipse.xtext.xtext.ValidEntryRuleInspector;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;

public class XtextValidator
extends AbstractDeclarativeValidator {
    @Inject
    private IValueConverterService valueConverter;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IResourceScopeCache cache;
    private KeywordInspector keywordHidesTerminalInspector;
    public static final String EMPTY_GENERATED_PACKAGE = "XtextValidator.checkGeneratedPackageNotEmpty";

    @Override
    protected List<EPackage> getEPackages() {
        return Collections.singletonList(XtextPackage.eINSTANCE);
    }

    @Check
    public void checkOrderOfArguments(RuleCall call) {
        AbstractRule rule = call.getRule();
        if (rule instanceof ParserRule) {
            HashSet usedParameters = Sets.newHashSet();
            boolean hasError = false;
            boolean hasPositionalArgument = false;
            boolean hasNamedArgument = false;
            for (NamedArgument argument : call.getArguments()) {
                Parameter parameter = argument.getParameter();
                if (parameter == null || parameter.eIsProxy()) {
                    hasError = true;
                } else if (!usedParameters.add(parameter)) {
                    hasError = true;
                    this.error("Duplicate value for parameter " + parameter.getName(), argument, (EStructuralFeature)XtextPackage.Literals.NAMED_ARGUMENT__PARAMETER);
                }
                if (!argument.isCalledByName()) {
                    hasPositionalArgument = true;
                    continue;
                }
                hasNamedArgument = true;
            }
            if (hasError) {
                return;
            }
            EList<Parameter> parameters = ((ParserRule)rule).getParameters();
            if (!hasPositionalArgument) {
                if (usedParameters.size() != parameters.size()) {
                    StringBuilder missing = new StringBuilder();
                    int count = 0;
                    for (Parameter parameter : parameters) {
                        if (usedParameters.contains(parameter)) continue;
                        if (count > 0) {
                            missing.append(", ");
                        }
                        missing.append(parameter.getName());
                        ++count;
                    }
                    if (count == 1) {
                        this.error("Missing argument for parameter " + missing, call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE);
                    } else {
                        this.error(count + " missing arguments for the following parameters: " + missing, call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE);
                    }
                }
            } else if (usedParameters.size() != parameters.size()) {
                this.error(String.format("Expected %d arguments but got %d", parameters.size(), usedParameters.size()), call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE);
            } else if (hasNamedArgument) {
                int max = usedParameters.size();
                for (int i = 0; i < max; ++i) {
                    NamedArgument argument = (NamedArgument)call.getArguments().get(i);
                    Parameter param = (Parameter)parameters.get(i);
                    if (!argument.isCalledByName() || argument.getParameter() == param) continue;
                    this.error("Out of sequence named argument. Expected value for " + param.getName(), argument, (EStructuralFeature)XtextPackage.Literals.NAMED_ARGUMENT__PARAMETER);
                }
            }
        }
    }

    @Check
    public void checkGrammarUsesMaxOneOther(Grammar grammar) {
        if (grammar.getUsedGrammars().size() > 1) {
            for (int i = 1; i < grammar.getUsedGrammars().size(); ++i) {
                this.error("You may not use more than one other grammar.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__USED_GRAMMARS, i);
            }
        }
    }

    @Check
    public void checkGrammarRecursiveReference(Grammar grammar) {
        HashSet visitedGrammars = Sets.newHashSet((Object[])new Grammar[]{grammar});
        for (int i = 0; i < grammar.getUsedGrammars().size(); ++i) {
            Grammar usedGrammar = (Grammar)grammar.getUsedGrammars().get(i);
            if (this.doCheckGrammarRecursiveReference(grammar, usedGrammar, i, visitedGrammars)) continue;
            return;
        }
    }

    private boolean doCheckGrammarRecursiveReference(Grammar grammarToCheck, Grammar currentGrammar, int idx, Set<Grammar> visitedGrammars) {
        if (Strings.equal((String)grammarToCheck.getName(), (String)currentGrammar.getName())) {
            this.error("Invalid recursive reference of grammar.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__USED_GRAMMARS, idx);
            return false;
        }
        if (!visitedGrammars.add(currentGrammar)) {
            return true;
        }
        for (Grammar usedGrammar : currentGrammar.getUsedGrammars()) {
            if (this.doCheckGrammarRecursiveReference(grammarToCheck, usedGrammar, idx, visitedGrammars)) continue;
            return false;
        }
        return true;
    }

    @Check
    public void checkGrammarName(Grammar g) {
        String name = g.getName();
        if (name == null) {
            return;
        }
        String[] split = name.split("\\.");
        if (split.length == 1) {
            this.error("You must use a namespace.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
        }
        for (int i = 0; i < split.length - 1; ++i) {
            String nsEle = split[i];
            if (!Character.isUpperCase(nsEle.charAt(0))) continue;
            this.warning("Namespace elements should start with a lower case letter.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
        }
        String ele = split[split.length - 1];
        if (!Character.isUpperCase(ele.charAt(0))) {
            this.error("The last element should start with an upper case letter.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
        }
    }

    @Check
    public void checkFirstRule(Grammar g) {
        if (g.getRules().isEmpty()) {
            return;
        }
        AbstractRule firstRule = (AbstractRule)g.getRules().get(0);
        if (!(firstRule instanceof ParserRule)) {
            if (!this.containsAnyParserRule(g, new HashSet<Grammar>())) {
                return;
            }
            this.error("The first rule must be a parser rule.", firstRule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, -1);
        } else if (GrammarUtil.isDatatypeRule((ParserRule)firstRule)) {
            if (!this.containsAnyParserRule(g, new HashSet<Grammar>())) {
                return;
            }
            this.error("The first rule must be a parser rule, but is a data type rule.", firstRule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, -1);
        } else if (((ParserRule)firstRule).isFragment()) {
            this.addIssue("The first rule must not be a fragment", (EObject)firstRule, (EStructuralFeature)XtextPackage.Literals.PARSER_RULE__FRAGMENT, "org.eclipse.xtext.grammar.InvalidFragmentFirstRule", new String[0]);
        }
    }

    private boolean containsAnyParserRule(Grammar g, Set<Grammar> visited) {
        if (!visited.add(g)) {
            return false;
        }
        for (AbstractRule rule : g.getRules()) {
            if (!(rule instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)rule)) continue;
            return true;
        }
        for (Grammar used : g.getUsedGrammars()) {
            if (!this.containsAnyParserRule(used, visited)) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkGeneratedMetamodel(GeneratedMetamodel metamodel) {
        if (metamodel.getName() != null && metamodel.getName().length() != 0 && Character.isUpperCase(metamodel.getName().charAt(0))) {
            this.addIssue("Metamodel names should start with a lower case letter.", (EObject)metamodel, (EStructuralFeature)XtextPackage.Literals.GENERATED_METAMODEL__NAME, "org.eclipse.xtext.grammar.InvalidMetaModelName", metamodel.getName());
        }
    }

    @Check
    public void checkGeneratedPackage(GeneratedMetamodel metamodel) {
        Diagnostician diagnostician;
        Map<Object, Object> context = this.getContext();
        if (context != null && (diagnostician = (Diagnostician)context.get(EValidator.class)) != null) {
            this.checkGeneratedPackage(metamodel, diagnostician, context);
        }
    }

    public void checkGeneratedPackage(GeneratedMetamodel metamodel, Diagnostician diagnostician, Map<?, ?> params) {
        EPackage pack = metamodel.getEPackage();
        if (pack != null) {
            Diagnostic packageValidationResult = diagnostician.validate((EObject)pack, params);
            AbstractValidationMessageAcceptor filter = new AbstractValidationMessageAcceptor(){
                Set<Triple<EObject, EStructuralFeature, String>> accepted = Sets.newHashSet();

                @Override
                public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptInfo(message, object, feature, index, code, issueData);
                    }
                }

                @Override
                public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptWarning(message, object, feature, index, code, issueData);
                    }
                }

                @Override
                public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptError(message, object, feature, index, code, issueData);
                    }
                }
            };
            this.propageValidationResult(packageValidationResult, metamodel, filter);
        }
    }

    @Check
    public void checkGeneratedPackageForNameClashes(GeneratedMetamodel metamodel) {
        EPackage pack = metamodel.getEPackage();
        HashMultimap constantNameToElement = HashMultimap.create();
        HashMultimap accessorNameToElement = HashMultimap.create();
        if (pack != null) {
            for (EClassifier classifier : pack.getEClassifiers()) {
                String accessorName = classifier.getName();
                if ("Class".equals(accessorName) || "Name".equals(accessorName)) {
                    accessorName = accessorName + "_";
                }
                accessorNameToElement.put((Object)("get" + accessorName), (Object)classifier);
                String classifierConstantName = CodeGenUtil2.format((String)classifier.getName(), (char)'_', null, (boolean)true, (boolean)true).toUpperCase();
                constantNameToElement.put((Object)classifierConstantName, (Object)classifier);
                if (!(classifier instanceof EClass)) continue;
                for (EStructuralFeature feature : ((EClass)classifier).getEAllStructuralFeatures()) {
                    String featureConstantPart = CodeGenUtil2.format((String)feature.getName(), (char)'_', null, (boolean)false, (boolean)false).toUpperCase();
                    String featureConstantName = classifierConstantName + "__" + featureConstantPart;
                    constantNameToElement.put((Object)featureConstantName, (Object)feature);
                    String featureAccessorName = "get" + classifier.getName() + "_" + Strings.toFirstUpper((String)feature.getName());
                    accessorNameToElement.put((Object)featureAccessorName, (Object)feature);
                }
            }
        }
        this.createMessageForNameClashes((Multimap<String, ENamedElement>)constantNameToElement);
        this.createMessageForNameClashes((Multimap<String, ENamedElement>)accessorNameToElement);
    }

    @Check
    public void checkGeneratedPackageNotEmpty(GeneratedMetamodel metamodel) {
        EPackage pack = metamodel.getEPackage();
        if (pack != null && pack.getEClassifiers().isEmpty()) {
            this.getMessageAcceptor().acceptError("Generated package '" + metamodel.getName() + "' may not be empty.", (EObject)metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, -1, EMPTY_GENERATED_PACKAGE, new String[0]);
        }
    }

    public void createMessageForNameClashes(Multimap<String, ENamedElement> nameToElement) {
        for (Map.Entry entry : nameToElement.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1 || Iterables.isEmpty((Iterable)Iterables.filter((Iterable)((Iterable)entry.getValue()), EStructuralFeature.class)) || Iterables.isEmpty((Iterable)Iterables.filter((Iterable)((Iterable)entry.getValue()), EClassifier.class))) continue;
            String constantName = (String)entry.getKey();
            String message = "Name clash in generated code: '" + constantName + "'.";
            for (ENamedElement element : (Collection)entry.getValue()) {
                String myMessage = message;
                if (element.getName().indexOf(95) >= 0) {
                    myMessage = myMessage + " Try to avoid underscores in names to prevent conflicts.";
                }
                this.createMessageForSource(myMessage, null, 4, (EObject)element, this.getMessageAcceptor());
            }
        }
    }

    private void propageValidationResult(Diagnostic diagnostic, GeneratedMetamodel metamodel, ValidationMessageAcceptor acceptor) {
        if (diagnostic.getSeverity() != 0) {
            List data;
            if (diagnostic.getCode() != 0 && !(data = diagnostic.getData()).isEmpty() && data.get(0) instanceof EObject) {
                this.doPropagateValidationResult(diagnostic, metamodel, acceptor);
            }
            for (Diagnostic child : diagnostic.getChildren()) {
                this.propageValidationResult(child, metamodel, acceptor);
            }
        }
    }

    private void doPropagateValidationResult(Diagnostic diagnostic, GeneratedMetamodel metamodel, ValidationMessageAcceptor acceptor) {
        boolean foundEObject = false;
        Object firstData = null;
        for (Object data : diagnostic.getData()) {
            if (firstData == null) {
                firstData = diagnostic.getData().get(0);
            }
            if (!(data instanceof EObject)) continue;
            if (this.createMessageForSource(diagnostic, (EObject)data, acceptor)) {
                foundEObject = true;
            }
            if (!(data instanceof EStructuralFeature) || ((EStructuralFeature)data).getEContainingClass() == firstData) continue;
            EClass containingClass = ((EStructuralFeature)data).getEContainingClass();
            this.createMessageForSource(diagnostic, (EObject)containingClass, acceptor);
        }
        if (!foundEObject) {
            this.doCreateMessage(diagnostic, metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, acceptor);
        }
    }

    public boolean createMessageForSource(Diagnostic diagnostic, EObject object, ValidationMessageAcceptor acceptor) {
        String code = XtextValidator.class.getName() + ".PackageValidation." + diagnostic.getCode();
        int severity = diagnostic.getSeverity();
        if (diagnostic.getCode() == 29 || diagnostic.getCode() == 32) {
            severity = 4;
        }
        String message = diagnostic.getMessage();
        return this.createMessageForSource(message, code, severity, object, acceptor);
    }

    public void doCreateMessage(Diagnostic diagnostic, EObject object, EStructuralFeature feature, ValidationMessageAcceptor acceptor) {
        String code = XtextValidator.class.getName() + ".PackageValidation." + diagnostic.getCode();
        int severity = diagnostic.getSeverity();
        if (diagnostic.getCode() == 29 || diagnostic.getCode() == 32) {
            severity = 4;
        }
        String message = diagnostic.getMessage();
        this.doCreateMessage(message, code, severity, object, feature, acceptor);
    }

    public boolean createMessageForSource(String message, String code, int severity, EObject object, ValidationMessageAcceptor acceptor) {
        SourceAdapter sourceAdapter = SourceAdapter.find(object);
        boolean result = false;
        if (sourceAdapter != null) {
            for (EObject source : sourceAdapter.getSources()) {
                this.doCreateMessage(message, code, severity, source, null, acceptor);
                result = true;
            }
        }
        return result;
    }

    public void doCreateMessage(String message, String code, int severity, EObject context, EStructuralFeature feature, ValidationMessageAcceptor acceptor) {
        if (severity == 2) {
            acceptor.acceptWarning(message, context, feature, -1, code, new String[0]);
        } else if (severity == 4) {
            acceptor.acceptError(message, context, feature, -1, code, new String[0]);
        } else if (severity == 1) {
            acceptor.acceptInfo(message, context, feature, -1, code, new String[0]);
        }
    }

    @Check
    public void checkReferencedMetamodel(ReferencedMetamodel metamodel) throws ValueConverterException {
        if (metamodel.getEPackage() == null) {
            return;
        }
        String nsURI = metamodel.getEPackage().getNsURI();
        List<GeneratedMetamodel> allGeneratedMetamodels = this.getInheritedGeneratedMetamodels(metamodel);
        String text = this.getUsedUri(metamodel);
        for (GeneratedMetamodel generatedMetamodel : allGeneratedMetamodels) {
            EPackage generatedPackage = generatedMetamodel.getEPackage();
            if (generatedPackage == null || !nsURI.equals(generatedPackage.getNsURI())) continue;
            if (!text.equals(nsURI)) {
                this.addIssue("Metamodels that have been generated by a super grammar must be referenced by nsURI: " + nsURI, (EObject)metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.inherited", nsURI);
                return;
            }
            return;
        }
        this.checkExternalPackage(metamodel, text);
    }

    protected void checkExternalPackage(ReferencedMetamodel metamodelReference, String importURI) {
        EPackage referencedPackage = metamodelReference.getEPackage();
        if (referencedPackage.eIsProxy() || this.isRuntime(metamodelReference)) {
            return;
        }
        if (this.isRegisteredPackage(referencedPackage)) {
            this.addIssue("The imported package is not on the classpath of this project which may lead to follow-up errors.", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.notOnClasspath", importURI);
            return;
        }
        if (!importURI.equals(referencedPackage.getNsURI())) {
            IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(metamodelReference.eResource());
            Iterable<IEObjectDescription> packagesInIndex = descriptions.getExportedObjects(EcorePackage.Literals.EPACKAGE, QualifiedName.create(referencedPackage.getNsURI()), false);
            if (!Iterables.isEmpty(packagesInIndex)) {
                this.addIssue("Packages should be imported by their namespace URI.", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.external", referencedPackage.getNsURI());
            } else {
                if (!ClasspathUriUtil.isClasspathUri(URI.createURI((String)importURI))) {
                    this.addIssue("The imported package is not on the classpath of this project which may lead to follow-up errors.", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.notOnClasspath", importURI);
                    return;
                }
                return;
            }
        }
        Map allReferences = EcoreUtil.CrossReferencer.find(Collections.singletonList(referencedPackage));
        HashSet allReferencedInstances = Sets.newHashSet();
        for (EStructuralFeature.Setting setting : Iterables.concat(allReferences.values())) {
            EPackage transitive;
            Object referenced = setting.get(true);
            if (!allReferencedInstances.add(referenced) || !(referenced instanceof EObject) || !this.isRegisteredPackage(transitive = EcoreUtil2.getContainerOfType((EObject)referenced, EPackage.class)) || referenced instanceof EDataType || referenced == EcorePackage.Literals.EOBJECT) continue;
            IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(metamodelReference.eResource());
            Iterable<IEObjectDescription> packagesInIndex = descriptions.getExportedObjects(EcorePackage.Literals.EPACKAGE, QualifiedName.create(importURI), false);
            if (!Iterables.isEmpty(packagesInIndex)) {
                if (setting.getEObject().eResource().getURI().isPlatformResource()) {
                    this.addIssue("The imported package refers to elements in the package registry instead of using the instances from the workspace", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.external", referencedPackage.getNsURI());
                } else {
                    this.addIssue("The imported package refers to elements in the package registry instead of using the instances from the workspace", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.external", new String[0]);
                }
                return;
            }
            this.addIssue("The imported package refers to elements that are not on the classpath of this project. The package '" + transitive.getNsURI() + "' was loaded from the registry.", (EObject)metamodelReference, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, "org.eclipse.xtext.grammar.InvalidPackageReference.notOnClasspath", referencedPackage.getNsURI());
            return;
        }
    }

    private boolean isRuntime(ReferencedMetamodel metamodelReference) {
        ResourceSet resourceSet = metamodelReference.eResource().getResourceSet();
        if (resourceSet instanceof XtextResourceSet) {
            Object context = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            boolean result = context == null || context instanceof Class || context instanceof ClassLoader;
            return result;
        }
        return false;
    }

    protected boolean isRegisteredPackage(EPackage ePackage) {
        return ePackage != null && (ePackage.eResource() == null || ePackage.getNsURI().equals(ePackage.eResource().getURI().toString()));
    }

    protected String getUsedUri(ReferencedMetamodel metamodel) {
        List<INode> nodes = NodeModelUtils.findNodesForFeature(metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE);
        if (nodes.size() != 1) {
            throw new IllegalArgumentException();
        }
        String text = nodes.get(0).getText();
        text = (String)this.valueConverter.toValue(text, "STRING", nodes.get(0));
        return text;
    }

    protected List<GeneratedMetamodel> getInheritedGeneratedMetamodels(ReferencedMetamodel metamodel) {
        ArrayList<GeneratedMetamodel> allGeneratedMetamodels = new ArrayList<GeneratedMetamodel>();
        Grammar grammar = GrammarUtil.getGrammar(metamodel);
        HashSet visited = Sets.newHashSet();
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            Iterables.addAll(allGeneratedMetamodels, this.getAllGeneratedMetamodels(usedGrammar, visited));
        }
        if (allGeneratedMetamodels.isEmpty()) {
            return Collections.emptyList();
        }
        return allGeneratedMetamodels;
    }

    private Iterable<GeneratedMetamodel> getAllGeneratedMetamodels(Grammar grammar, Set<Grammar> visited) {
        Iterable result = Iterables.filter(grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        for (Grammar gr : grammar.getUsedGrammars()) {
            if (!visited.add(gr)) continue;
            result = Iterables.concat((Iterable)result, this.getAllGeneratedMetamodels(gr, visited));
        }
        return result;
    }

    @Check
    public void checkMetamodelUris(final AbstractMetamodelDeclaration declaration) {
        if (declaration.getEPackage() == null || declaration.getEPackage().getNsURI() == null) {
            return;
        }
        Grammar grammar = GrammarUtil.getGrammar(declaration);
        Iterable nsUris = Iterables.transform(grammar.getMetamodelDeclarations(), (Function)new Function<AbstractMetamodelDeclaration, String>(){

            public String apply(AbstractMetamodelDeclaration param) {
                if (param.getEPackage() != null) {
                    return param.getEPackage().getNsURI();
                }
                return null;
            }
        });
        int count = Iterables.size((Iterable)Iterables.filter((Iterable)nsUris, (Predicate)new Predicate<String>(){

            public boolean apply(String param) {
                return declaration.getEPackage().getNsURI().equals(param);
            }
        }));
        if (count != 1) {
            this.error("EPackage with ns-uri '" + declaration.getEPackage().getNsURI() + "' is used twice.", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE);
        }
    }

    @Check
    public void checkCrossReferenceTerminal(CrossReference reference) {
        if (reference.getTerminal() != null && reference.getTerminal() instanceof RuleCall) {
            RuleCall call = (RuleCall)reference.getTerminal();
            this.checkCrossReferenceTerminal(call);
        }
    }

    public boolean checkCrossReferenceTerminal(RuleCall call) {
        if (call.getRule() != null && call.getRule().getType() != null) {
            EClassifier type = call.getRule().getType().getClassifier();
            EDataType dataType = GrammarUtil.findEString(GrammarUtil.getGrammar(call));
            if (dataType == null) {
                dataType = EcorePackage.Literals.ESTRING;
            }
            if (type != null && dataType != type) {
                this.error("The rule '" + call.getRule().getName() + "' is not valid for a cross reference since it does not return an EString. You'll have to wrap it in a data type rule.", (EObject)call, null, -1, null, new String[0]);
                return true;
            }
        }
        return false;
    }

    @Check
    public void checkRuleName(AbstractRule rule) {
        Grammar grammar = GrammarUtil.getGrammar(rule);
        Multimap<String, AbstractRule> rules = this.getAllRules(grammar, rule.getName());
        rules.remove((Object)rule.getName(), (Object)rule);
        if (!rules.isEmpty()) {
            TreeSet names = Sets.newTreeSet((Iterable)rules.keySet());
            if (names.size() == 1) {
                String name = (String)names.first();
                if (name.equals(rule.getName())) {
                    String message = "A rule's name has to be unique.";
                    this.error("A rule's name has to be unique.", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
                    return;
                }
                String message = "A rule's name has to be unique even case insensitive.";
                boolean superGrammar = false;
                for (AbstractRule otherRule : rules.get((Object)name)) {
                    if (GrammarUtil.getGrammar(otherRule) == grammar) continue;
                    message = message + " A used grammar contains another rule '" + name + "'.";
                    superGrammar = true;
                    break;
                }
                if (!superGrammar) {
                    message = message + " This grammar contains another rule '" + name + "'.";
                }
                this.error(message, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
                return;
            }
            String message = "A rule's name has to be unique even case insensitive.";
            StringBuilder builder = new StringBuilder((rule.getName().length() + 4) * names.size() - 2);
            int i = 0;
            for (String name : names) {
                if (builder.length() != 0) {
                    if (i < names.size() - 1) {
                        builder.append(", ");
                    } else {
                        builder.append(" and ");
                    }
                }
                ++i;
                builder.append("'").append(name).append("'");
            }
            this.error(message + " The conflicting rules are " + builder + ".", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
            return;
        }
        if ("super".equals(rule.getName())) {
            this.addIssue("Discouraged rule name 'super'", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.DiscouragedName", new String[0]);
        }
    }

    private Multimap<String, AbstractRule> getAllRules(Grammar grammar, String name) {
        ArrayListMultimap result = ArrayListMultimap.create();
        HashSet<Grammar> grammars = new HashSet<Grammar>();
        HashSet<String> validNames = new HashSet<String>();
        this.collectRules(grammar, (Multimap<String, AbstractRule>)result, grammars, name, validNames);
        return result;
    }

    private void collectRules(Grammar grammar, Multimap<String, AbstractRule> result, Set<Grammar> visited, String name, Set<String> validNames) {
        if (!visited.add(grammar)) {
            return;
        }
        ArrayList<String> allNames = new ArrayList<String>();
        for (AbstractRule rule : grammar.getRules()) {
            if (validNames.contains(rule.getName())) continue;
            allNames.add(rule.getName());
            if (!rule.getName().equalsIgnoreCase(name)) continue;
            result.put((Object)rule.getName(), (Object)rule);
        }
        validNames.addAll(allNames);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.collectRules(usedGrammar, result, visited, name, validNames);
        }
    }

    @Check
    public void checkUnassignedActionAfterAssignment(Action action) {
        if (action.getFeature() == null) {
            this.checkCurrentMustBeUnassigned(action);
        }
    }

    @Check
    public void checkUnassignedRuleCallAllowed(RuleCall call) {
        if (call.getRule() != null && !call.getRule().eIsProxy() && GrammarUtil.containingAssignment(call) == null) {
            AbstractRule container = GrammarUtil.containingRule(call);
            if (call.getRule() instanceof ParserRule) {
                if (container instanceof TerminalRule) {
                    this.getMessageAcceptor().acceptError("Cannot call parser rule from terminal rule.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
                } else {
                    ParserRule parserRule = (ParserRule)call.getRule();
                    if (!GrammarUtil.isDatatypeRule(parserRule) && !parserRule.isFragment()) {
                        this.checkCurrentMustBeUnassigned(call);
                    }
                }
            }
            if (call.getRule() instanceof EnumRule && container instanceof TerminalRule) {
                this.getMessageAcceptor().acceptError("Cannot call enum rule from terminal rule.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
            }
        }
    }

    @Check
    public void checkTerminalFragmentCalledFromTerminalRule(RuleCall call) {
        AbstractRule container;
        if (call.getRule() != null && !call.getRule().eIsProxy() && call.getRule() instanceof TerminalRule && ((TerminalRule)call.getRule()).isFragment() && !((container = GrammarUtil.containingRule(call)) instanceof TerminalRule)) {
            this.getMessageAcceptor().acceptError("Only terminal rules may use terminal fragments.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, "org.eclipse.xtext.grammar.InvalidTerminalFragmentRuleReference", new String[0]);
        }
    }

    private void checkCurrentMustBeUnassigned(final AbstractElement element) {
        final ParserRule rule = GrammarUtil.containingParserRule(element);
        if (GrammarUtil.isDatatypeRule(rule)) {
            return;
        }
        XtextSwitch<Boolean> visitor = new XtextSwitch<Boolean>(){
            private boolean isNull;
            {
                this.isNull = !rule.isFragment();
            }

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                return this.isNull;
            }

            @Override
            public Boolean caseAlternatives(Alternatives object) {
                boolean wasIsNull;
                boolean localIsNull = wasIsNull = this.isNull;
                for (AbstractElement element2 : object.getElements()) {
                    this.isNull = wasIsNull;
                    localIsNull &= ((Boolean)this.doSwitch(element2)).booleanValue();
                }
                this.isNull = localIsNull;
                return this.isNull;
            }

            @Override
            public Boolean caseUnorderedGroup(UnorderedGroup object) {
                boolean wasIsNull;
                boolean localIsNull = wasIsNull = this.isNull;
                for (AbstractElement element2 : object.getElements()) {
                    this.isNull = wasIsNull;
                    localIsNull |= ((Boolean)this.doSwitch(element2)).booleanValue();
                }
                this.isNull = localIsNull;
                return this.isNull;
            }

            @Override
            public Boolean caseAssignment(Assignment object) {
                this.isNull = false;
                return this.isNull;
            }

            @Override
            public Boolean caseGroup(Group object) {
                for (AbstractElement element2 : object.getElements()) {
                    this.doSwitch(element2);
                }
                return this.isNull;
            }

            @Override
            public Boolean caseAction(Action object) {
                if (object == element && (!this.isNull || this.isMany(object))) {
                    XtextValidator.this.error("An unassigned action is not allowed, when the 'current' was already created.", object, null);
                    XtextValidator.this.checkDone();
                }
                this.isNull = false;
                return this.isNull;
            }

            @Override
            public Boolean caseRuleCall(RuleCall object) {
                if (object == element) {
                    AbstractRule calledRule = object.getRule();
                    if (calledRule instanceof ParserRule && ((ParserRule)calledRule).isFragment()) {
                        this.isNull = false;
                        return this.isNull;
                    }
                    if (!this.isNull || this.isMany(object)) {
                        XtextValidator.this.error("An unassigned rule call is not allowed, when the 'current' was already created.", object, null);
                        XtextValidator.this.checkDone();
                    }
                }
                return (Boolean)this.doSwitch(object.getRule());
            }

            @Override
            public Boolean caseParserRule(ParserRule object) {
                this.isNull &= GrammarUtil.isDatatypeRule(object);
                return this.isNull;
            }

            @Override
            public Boolean caseTerminalRule(TerminalRule object) {
                return this.isNull;
            }

            public boolean isMany(AbstractElement element2) {
                return GrammarUtil.isMultipleCardinality(element2) || element2.eContainer() instanceof AbstractElement && this.isMany((AbstractElement)element2.eContainer());
            }
        };
        visitor.doSwitch(rule.getAlternatives());
    }

    @Check
    public void checkAssignedActionAfterAssignment(final Action action) {
        if (action.getFeature() != null) {
            ParserRule rule = GrammarUtil.containingParserRule(action);
            if (rule.isFragment() && !rule.isWildcard()) {
                this.error("An action is not allowed in fragments.", action, null);
                return;
            }
            XtextSwitch<Boolean> visitor = new XtextSwitch<Boolean>(){
                private boolean assignedActionAllowed = false;

                @Override
                public Boolean caseAbstractElement(AbstractElement object) {
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAlternatives(Alternatives object) {
                    boolean wasActionAllowed = this.assignedActionAllowed;
                    boolean localActionAllowed = true;
                    for (AbstractElement element : object.getElements()) {
                        this.assignedActionAllowed = wasActionAllowed;
                        localActionAllowed &= ((Boolean)this.doSwitch(element)).booleanValue();
                    }
                    this.assignedActionAllowed = wasActionAllowed || localActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseUnorderedGroup(UnorderedGroup object) {
                    boolean wasActionAllowed = this.assignedActionAllowed;
                    boolean localActionAllowed = false;
                    for (AbstractElement element : object.getElements()) {
                        this.assignedActionAllowed = wasActionAllowed;
                        localActionAllowed |= ((Boolean)this.doSwitch(element)).booleanValue();
                    }
                    this.assignedActionAllowed = wasActionAllowed || localActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAssignment(Assignment object) {
                    this.assignedActionAllowed = this.assignedActionAllowed || !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseGroup(Group object) {
                    boolean wasAssignedActionAllowed = this.assignedActionAllowed;
                    for (AbstractElement element : object.getElements()) {
                        this.doSwitch(element);
                    }
                    this.assignedActionAllowed = wasAssignedActionAllowed || this.assignedActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAction(Action object) {
                    if (object == action && !this.assignedActionAllowed) {
                        XtextValidator.this.error("An action is not allowed in fragments and when the current may still be unassigned.", object, null);
                        XtextValidator.this.checkDone();
                    }
                    this.assignedActionAllowed = true;
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseRuleCall(RuleCall object) {
                    if (object.getRule() == null) {
                        return this.assignedActionAllowed;
                    }
                    this.assignedActionAllowed = this.assignedActionAllowed || (Boolean)this.doSwitch(object.getRule()) != false && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseParserRule(ParserRule object) {
                    this.assignedActionAllowed = !GrammarUtil.isDatatypeRule(object) && !object.isFragment();
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseTerminalRule(TerminalRule object) {
                    return this.assignedActionAllowed;
                }
            };
            visitor.doSwitch(rule.getAlternatives());
        }
    }

    @Check
    public void checkEnumLiteralIsUnique(EnumLiteralDeclaration decl) {
        EnumRule rule = GrammarUtil.containingEnumRule(decl);
        List<EnumLiteralDeclaration> declarations = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
        String literal = decl.getLiteral().getValue();
        if (literal != null) {
            for (EnumLiteralDeclaration otherDecl : declarations) {
                if (otherDecl == decl || !literal.equals(otherDecl.getLiteral().getValue())) continue;
                this.error("Enum literal '" + literal + "' is used multiple times in enum rule '" + rule.getName() + "'.", (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__LITERAL);
            }
        }
    }

    @Check
    public void checkGeneratedEnumIsValid(EnumLiteralDeclaration decl) {
        EnumRule rule = GrammarUtil.containingEnumRule(decl);
        if (!(rule.getType().getMetamodel() instanceof GeneratedMetamodel)) {
            return;
        }
        if (!(rule.getType().getClassifier() instanceof EEnum)) {
            return;
        }
        EEnum eEnum = (EEnum)rule.getType().getClassifier();
        List<EnumLiteralDeclaration> declarations = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
        if (declarations.size() == eEnum.getELiterals().size()) {
            return;
        }
        for (EnumLiteralDeclaration otherDecl : declarations) {
            if (decl == otherDecl) {
                return;
            }
            if (otherDecl.getEnumLiteral() != decl.getEnumLiteral()) continue;
            if (!decl.getEnumLiteral().getLiteral().equals(decl.getLiteral().getValue())) {
                this.addIssue("Enum literal '" + decl.getEnumLiteral().getName() + "' has already been defined with literal '" + decl.getEnumLiteral().getLiteral() + "'.", (EObject)decl, (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__ENUM_LITERAL, "org.eclipse.xtext.grammar.DuplicateEnumLiteral", new String[0]);
            }
            return;
        }
    }

    @Check
    public void checkEnumLiteralIsValid(EnumLiteralDeclaration decl) {
        if ("".equals(decl.getLiteral().getValue())) {
            this.addIssue("Enum literal must not be an empty string.", (EObject)decl, (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__LITERAL, "org.eclipse.xtext.grammar.EmptyEnumLiteral", decl.getEnumLiteral().getName());
        }
    }

    @Check
    public void checkForOverriddenValue(ParserRule rule) {
        OverriddenValueInspector inspector = new OverriddenValueInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkInstanceCreated(ParserRule rule) {
        RuleWithoutInstantiationInspector inspector = new RuleWithoutInstantiationInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkInstanceCreatedForEntryRule(ParserRule rule) {
        ValidEntryRuleInspector inspector = new ValidEntryRuleInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkKeywordNotEmpty(Keyword keyword) {
        if (keyword.getValue().length() == 0 && !(keyword.eContainer() instanceof EnumLiteralDeclaration)) {
            this.addIssue("A keyword cannot be empty.", (EObject)keyword, null, "org.eclipse.xtext.grammar.EmptyKeyword", new String[0]);
        }
    }

    @Check
    public void checkKeywordNoSpaces(Keyword keyword) {
        if (keyword.getValue() != null && !(keyword.eContainer() instanceof EnumLiteralDeclaration) && !(GrammarUtil.containingRule(keyword) instanceof TerminalRule) && (keyword.getValue().contains(" ") || keyword.getValue().contains("\t"))) {
            this.addIssue("A keyword should not contain spaces.", (EObject)keyword, null, "org.eclipse.xtext.grammar.SpacesInKeyword", new String[0]);
        }
    }

    @Check
    public void checkKeywordHidesTerminalRule(Keyword keyword) {
        if (this.keywordHidesTerminalInspector == null) {
            this.keywordHidesTerminalInspector = new KeywordInspector(this, this.cache);
        }
        this.keywordHidesTerminalInspector.inspectKeywordHidesTerminalRule(keyword);
    }

    @Check
    public void checkForLeftRecursion(Grammar grammar) {
        GrammarWithoutLeftRecursionInspector inspector = new GrammarWithoutLeftRecursionInspector(this);
        inspector.inspect(grammar);
    }

    @Check
    public void checkActionInUnorderedGroup(Action action) {
        if (EcoreUtil2.getContainerOfType(action, UnorderedGroup.class) != null) {
            this.addIssue("Actions may not be used in unordered groups.", (EObject)action, null, "org.eclipse.xtext.grammar.InvalidActionUsage", new String[0]);
        }
    }

    @Check
    public void checkRuleCallInUnorderedGroup(RuleCall call) {
        if (call.getRule() == null || call.getRule().eIsProxy() || !(call.getRule() instanceof ParserRule)) {
            return;
        }
        if (GrammarUtil.isDatatypeRule((ParserRule)call.getRule())) {
            return;
        }
        if (GrammarUtil.isAssigned(call)) {
            return;
        }
        if (EcoreUtil2.getContainerOfType(call, UnorderedGroup.class) != null) {
            this.error("Unassigned rule calls may not be used in unordered groups.", (EObject)call, null, -1, null, new String[0]);
        }
    }

    @Check
    public void checkCrossReferenceType(CrossReference reference) {
        this.checkTypeIsEClass(reference.getType());
    }

    @Check
    public void checkCrossReferenceNotInAlternatives(Alternatives alternatives) {
        int numOfCrossRefs = IterableExtensions.size((Iterable)IterableExtensions.filter(alternatives.getElements(), CrossReference.class));
        if (numOfCrossRefs > 1) {
            String errorMessage = "Cross references using the pattern 'feature=([SomeClass|ID] | [SomeClass|STRING])' are not allowed. Use the pattern '(feature=[SomeClass|ID] | feature=[SomeClass|STRING])' instead.";
            this.error(errorMessage, (EObject)alternatives, null, -1, "org.eclipse.xtext.grammar.CrossReferenceInAlternatives", new String[0]);
        }
    }

    private void checkTypeIsEClass(TypeRef type) {
        EClassifier classifier;
        if (type != null && (classifier = type.getClassifier()) != null && !classifier.eIsProxy() && !(classifier instanceof EClass)) {
            this.error("Type of cross reference must be an EClass.", (EObject)type, null, -1, null, new String[0]);
        }
    }

    @Check
    public void checkInstantiatedType(Action action) {
        this.checkTypeIsEClass(action.getType());
    }

    @Check
    public void checkHiddenTokenIsNotAFragment(ParserRule rule) {
        if (rule.isDefinesHiddenTokens()) {
            this.checkHiddenTokenIsNotAFragment(rule, (List<AbstractRule>)rule.getHiddenTokens(), XtextPackage.Literals.PARSER_RULE__HIDDEN_TOKENS);
        }
    }

    @Check
    public void checkHiddenTokenIsNotAFragment(Grammar grammar) {
        if (grammar.isDefinesHiddenTokens()) {
            this.checkHiddenTokenIsNotAFragment(grammar, (List<AbstractRule>)grammar.getHiddenTokens(), XtextPackage.Literals.GRAMMAR__HIDDEN_TOKENS);
        }
    }

    protected void checkHiddenTokenIsNotAFragment(EObject owner, List<AbstractRule> hiddenTokens, EReference reference) {
        for (int i = 0; i < hiddenTokens.size(); ++i) {
            AbstractRule hiddenToken = hiddenTokens.get(i);
            if (hiddenToken instanceof TerminalRule) {
                if (!((TerminalRule)hiddenToken).isFragment()) continue;
                this.addIssue("Cannot use terminal fragments as hidden tokens.", owner, (EStructuralFeature)reference, i, "org.eclipse.xtext.grammar.InvalidHiddenTokenFragment", String.valueOf(i));
                continue;
            }
            this.addIssue("Only terminal rules may be used as hidden tokens.", owner, (EStructuralFeature)reference, i, "org.eclipse.xtext.grammar.InvalidHiddenToken", String.valueOf(i));
        }
    }

    @Check
    public void checkUnorderedGroupIsNotPredicated(Grammar grammar) {
        PredicateUsesUnorderedGroupInspector inspector = new PredicateUsesUnorderedGroupInspector(this.getMessageAcceptor());
        inspector.inspect(grammar);
    }

    @Check
    public void checkJavaPackageNamingConventions(GeneratedMetamodel metamodel) {
        Severity severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity("org.eclipse.xtext.grammar.InvalidJavaPackageName");
        if (severity == null || severity == Severity.IGNORE) {
            return;
        }
        String metamodelName = Strings.emptyIfNull((String)metamodel.getName());
        if (!Strings.equal((String)metamodelName, (String)metamodelName.toLowerCase())) {
            this.addIssue("The generated metamodel name must not contain uppercase characters", (EObject)metamodel, (EStructuralFeature)XtextPackage.eINSTANCE.getGeneratedMetamodel_Name(), "org.eclipse.xtext.grammar.InvalidJavaPackageName", metamodel.getName());
        }
    }

    @Check
    public void checkTerminalRuleNamingConventions(TerminalRule terminalRule) {
        if (!terminalRule.getName().equals(terminalRule.getName().toUpperCase())) {
            this.addIssue("TerminalRule must be written in uppercase.", (EObject)terminalRule, (EStructuralFeature)XtextPackage.eINSTANCE.getAbstractRule_Name(), "org.eclipse.xtext.grammar.InvalidTerminalRuleName", terminalRule.getName());
        }
    }

    @Check
    public void checkTerminalRuleAnnotations(AbstractRule rule) {
        if (rule instanceof TerminalRule || rule instanceof EnumRule) {
            if (this.hasAnnotation(rule, "Exported")) {
                this.error("Rule cannot be exported!", (EObject)rule, (EStructuralFeature)XtextPackage.eINSTANCE.getAbstractRule_Name(), "org.eclipse.xtext.grammar.InvalidAnnotation", new String[0]);
            }
            if (this.hasAnnotation(rule, "Deprecated")) {
                this.error("Rule cannot be deprecated!", (EObject)rule, (EStructuralFeature)XtextPackage.eINSTANCE.getAbstractRule_Name(), "org.eclipse.xtext.grammar.InvalidAnnotation", new String[0]);
            }
        }
    }

    @Check
    public void checkOppositeReferenceUsed(Assignment assignment) {
        EReference reference;
        EStructuralFeature feature;
        Severity severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity("org.eclipse.xtext.grammar.BidirectionalReference");
        if (severity == null || severity == Severity.IGNORE) {
            return;
        }
        EClassifier classifier = GrammarUtil.findCurrentType(assignment);
        if (classifier instanceof EClass && (feature = ((EClass)classifier).getEStructuralFeature(assignment.getFeature())) instanceof EReference && (reference = (EReference)feature).getEOpposite() != null && !reference.isContainment() && !reference.isContainer()) {
            this.addIssue("The feature '" + assignment.getFeature() + "' is a bidirectional reference. This may cause problems in the linking process.", (EObject)assignment, (EStructuralFeature)XtextPackage.eINSTANCE.getAssignment_Feature(), "org.eclipse.xtext.grammar.BidirectionalReference", new String[0]);
        }
    }

    @Check
    public void checkCallToDeprecatedParserRule(RuleCall ruleCall) {
        AbstractRule calledRule = ruleCall.getRule();
        if (this.hasAnnotation(calledRule, "Deprecated")) {
            this.addIssue("The called rule is marked as deprecated.", (EObject)ruleCall, (EStructuralFeature)XtextPackage.eINSTANCE.getRuleCall_Rule(), "org.eclipse.xtext.grammar.UsageOfDeprecatedRule", new String[0]);
        }
    }

    @Check
    public void checkOverridingRule(AbstractRule rule) {
        String name = rule.getName();
        EList<Grammar> superGrammars = GrammarUtil.getGrammar(rule).getUsedGrammars();
        boolean isOverride = this.hasAnnotation(rule, "Override");
        if (isOverride && superGrammars.isEmpty()) {
            this.error("This grammar has no super grammar and therefore cannot override any rules.", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.ExplicitOverrideInvalid", new String[0]);
        }
        for (Grammar g : superGrammars) {
            AbstractRule r = GrammarUtil.findRuleForName(g, rule.getName());
            if (r != null) {
                if (this.hasAnnotation(r, "Deprecated")) {
                    this.warning("This rule overrides " + name + " in " + GrammarUtil.getGrammar(r).getName() + " which is deprecated.", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.UsageOfDeprecatedRule", new String[0]);
                }
                if (this.hasAnnotation(r, "Final")) {
                    this.error("This rule illegally overrides " + name + " in " + GrammarUtil.getGrammar(r).getName() + " which is final.", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.ExplicitOverrideInvalid", new String[0]);
                    break;
                }
                if (isOverride) continue;
                this.warning("This rule overrides " + name + " in " + GrammarUtil.getGrammar(r).getName() + " and thus should be annotated with @Override.", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.ExplicitOverrideMissing", new String[0]);
                break;
            }
            if (!isOverride) continue;
            this.error("The rule " + name + " does not override a rule from a super grammar.", (EObject)rule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, "org.eclipse.xtext.grammar.ExplicitOverrideInvalid", new String[0]);
            break;
        }
    }

    @Check
    public void checkNegatedTokenNotEOF(NegatedToken token) {
        for (EOF eof : EcoreUtil2.getAllContentsOfType(token, EOF.class)) {
            this.error("It is not possible to negate EOF", eof, null);
        }
    }

    protected boolean hasAnnotation(AbstractRule rule, String annotationName) {
        if (rule == null) {
            return false;
        }
        return rule.getAnnotations().stream().anyMatch(e -> annotationName.equals(e.getName()));
    }
}

