/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.containers.AbstractProjectsStateHelper;

@Singleton
public class WorkspaceProjectsStateHelper
extends AbstractProjectsStateHelper {
    private static final Logger log = Logger.getLogger(WorkspaceProjectsStateHelper.class);

    public String initHandle(URI uri) {
        if (!uri.isPlatform()) {
            return null;
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        return project.getName();
    }

    public Collection<URI> initContainedURIs(String containerHandle) {
        block4: {
            try {
                IPath projectPath = new Path(null, containerHandle).makeAbsolute();
                if (projectPath.segmentCount() != 1) {
                    return Collections.emptySet();
                }
                IProject project = this.getWorkspaceRoot().getProject(containerHandle);
                if (project != null && this.isAccessibleXtextProject(project)) {
                    Map<URI, IStorage> entries = this.getMapper().getAllEntries((IContainer)project);
                    return entries.keySet();
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Cannot init contained URIs for containerHandle '" + containerHandle + "'"), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    public List<String> initVisibleHandles(String handle) {
        block7: {
            try {
                IProject project = this.getWorkspaceRoot().getProject(handle);
                if (this.isAccessibleXtextProject(project)) {
                    try {
                        IProject[] referencedProjects = project.getReferencedProjects();
                        ArrayList result = Lists.newArrayListWithExpectedSize((int)referencedProjects.length);
                        result.add(handle);
                        IProject[] iProjectArray = referencedProjects;
                        int n = referencedProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject referencedProject = iProjectArray[n2];
                            if (this.isAccessibleXtextProject(referencedProject)) {
                                result.add(referencedProject.getName());
                            }
                            ++n2;
                        }
                        return result;
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("Cannot init visible handles for containerHandle '" + handle + "'"), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }
}

