/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;

@Singleton
public class QueuedBuildData {
    private LinkedList<URI> uris;
    private LinkedList<URI> urisCopy;
    private Collection<IResourceDescription.Delta> deltas;
    private Collection<IResourceDescription.Delta> deltasCopy;
    private Map<String, LinkedList<URI>> projectNameToChangedResource;
    private Map<String, LinkedList<URI>> projectNameToChangedResourceCopy;
    private IQueuedBuildDataContribution contribution = new NullContribution();
    private final IStorage2UriMapper mapper;

    @Inject
    public QueuedBuildData(IStorage2UriMapper mapper) {
        this.mapper = mapper;
        this.reset();
    }

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contribution = this.getContribution((ImmutableList<? extends IQueuedBuildDataContribution>)registry.getContributedInstances(IQueuedBuildDataContribution.class));
        this.reset();
    }

    public QueuedBuildData(IStorage2UriMapper mapper, IQueuedBuildDataContribution contribution) {
        this.mapper = mapper;
        this.contribution = contribution;
        this.reset();
    }

    private IQueuedBuildDataContribution getContribution(ImmutableList<? extends IQueuedBuildDataContribution> contributions) {
        switch (contributions.size()) {
            case 0: {
                return new NullContribution();
            }
            case 1: {
                return (IQueuedBuildDataContribution)contributions.get(0);
            }
        }
        return new CompositeContribution((List<? extends IQueuedBuildDataContribution>)contributions);
    }

    public void reset() {
        this.uris = Lists.newLinkedList();
        this.deltas = Lists.newArrayList();
        this.projectNameToChangedResource = Maps.newHashMap();
        this.contribution.reset();
    }

    public void reset(IProject project) {
        this.projectNameToChangedResource.remove(project.getName());
        this.contribution.reset(project);
    }

    public synchronized boolean needRebuild(IProject project) {
        return this.contribution.needsRebuild(project, this.deltas);
    }

    public synchronized void queueChanges(List<IResourceDescription.Delta> deltas) {
        int i = 0;
        int size = deltas.size();
        while (i < size) {
            this.queueChange(deltas.get(i));
            ++i;
        }
    }

    public synchronized void queueChange(IResourceDescription.Delta delta) {
        if (!this.contribution.queueChange(delta)) {
            this.deltas.add(delta);
        }
    }

    public synchronized void queueURIs(Collection<URI> uris) {
        if (uris != null && !uris.isEmpty()) {
            for (URI uri : uris) {
                this.queueURI(uri);
            }
        }
    }

    public void queueURI(URI uri) {
        Iterable iterable = this.mapper.getStorages(uri);
        boolean associatedWithProject = false;
        for (Pair pair : iterable) {
            IProject project = (IProject)pair.getSecond();
            if (!XtextProjectHelper.hasNature((IProject)project) || !XtextProjectHelper.hasBuilder((IProject)project)) continue;
            String projectName = project.getName();
            LinkedList list = this.projectNameToChangedResource.get(projectName);
            if (list == null) {
                list = Lists.newLinkedList();
                this.projectNameToChangedResource.put(projectName, list);
            }
            if (!list.contains(uri)) {
                list.add(uri);
            }
            associatedWithProject = true;
        }
        if (!associatedWithProject && !this.uris.contains(uri)) {
            this.uris.add(uri);
        }
    }

    public synchronized Collection<IResourceDescription.Delta> getAndRemovePendingDeltas() {
        Collection<IResourceDescription.Delta> result = this.deltas;
        this.deltas = Lists.newArrayList();
        return result;
    }

    public boolean isEmpty(String projectName) {
        return this.deltas.isEmpty() && this.getQueue(projectName).isEmpty();
    }

    public Queue<URI> getQueue(String projectName) {
        final LinkedList<URI> list = this.projectNameToChangedResource.get(projectName);
        if (list == null) {
            return this.uris;
        }
        return new AbstractQueue<URI>(){

            @Override
            public boolean offer(URI o) {
                return list.offer(o);
            }

            @Override
            public URI poll() {
                if (QueuedBuildData.this.uris.isEmpty()) {
                    return (URI)list.poll();
                }
                return (URI)QueuedBuildData.this.uris.poll();
            }

            @Override
            public URI peek() {
                if (QueuedBuildData.this.uris.isEmpty()) {
                    return (URI)list.peek();
                }
                return (URI)QueuedBuildData.this.uris.peek();
            }

            @Override
            public Iterator<URI> iterator() {
                return Iterators.concat(QueuedBuildData.this.uris.iterator(), list.iterator());
            }

            @Override
            public int size() {
                return QueuedBuildData.this.uris.size() + list.size();
            }
        };
    }

    public Iterable<URI> getAllRemainingURIs() {
        return Iterables.concat(this.uris, (Iterable)Iterables.concat(this.projectNameToChangedResource.values()));
    }

    public void createCheckpoint() {
        this.deltasCopy = new ArrayList<IResourceDescription.Delta>(this.deltas);
        this.urisCopy = new LinkedList<URI>(this.uris);
        this.projectNameToChangedResourceCopy = new HashMap<String, LinkedList<URI>>(this.projectNameToChangedResource);
        this.contribution.createCheckpoint();
    }

    public void discardCheckpoint() {
        this.deltasCopy = null;
        this.urisCopy = null;
        this.projectNameToChangedResourceCopy = null;
        this.contribution.discardCheckpoint();
    }

    public void rollback() {
        this.deltas.clear();
        this.deltas.addAll(this.deltasCopy);
        this.uris.clear();
        this.uris.addAll(this.urisCopy);
        this.projectNameToChangedResource.clear();
        this.projectNameToChangedResource.putAll(this.projectNameToChangedResourceCopy);
        this.contribution.rollback();
    }

    public static class CompositeContribution
    implements IQueuedBuildDataContribution {
        private final List<? extends IQueuedBuildDataContribution> components;

        public CompositeContribution(List<? extends IQueuedBuildDataContribution> components) {
            this.components = components;
        }

        @Override
        public void reset() {
            int i = 0;
            while (i < this.components.size()) {
                this.components.get(i).reset();
                ++i;
            }
        }

        @Override
        public void reset(IProject project) {
            int i = 0;
            while (i < this.components.size()) {
                this.components.get(i).reset(project);
                ++i;
            }
        }

        @Override
        public boolean queueChange(IResourceDescription.Delta delta) {
            int i = 0;
            while (i < this.components.size()) {
                IQueuedBuildDataContribution contribution = this.components.get(i);
                if (contribution.queueChange(delta)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean needsRebuild(IProject project, Collection<IResourceDescription.Delta> deltas) {
            boolean result = false;
            int i = 0;
            while (i < this.components.size()) {
                IQueuedBuildDataContribution contribution = this.components.get(i);
                if (contribution.needsRebuild(project, deltas)) {
                    result = true;
                }
                ++i;
            }
            return result;
        }

        @Override
        public void createCheckpoint() {
            int i = 0;
            while (i < this.components.size()) {
                IQueuedBuildDataContribution contribution = this.components.get(i);
                contribution.createCheckpoint();
                ++i;
            }
        }

        @Override
        public void discardCheckpoint() {
            int i = 0;
            while (i < this.components.size()) {
                IQueuedBuildDataContribution contribution = this.components.get(i);
                contribution.discardCheckpoint();
                ++i;
            }
        }

        @Override
        public void rollback() {
            int i = 0;
            while (i < this.components.size()) {
                IQueuedBuildDataContribution contribution = this.components.get(i);
                contribution.rollback();
                ++i;
            }
        }
    }

    public static class NullContribution
    implements IQueuedBuildDataContribution {
        @Override
        public void reset() {
        }

        @Override
        public void reset(IProject project) {
        }

        @Override
        public boolean queueChange(IResourceDescription.Delta delta) {
            return false;
        }

        @Override
        public boolean needsRebuild(IProject project, Collection<IResourceDescription.Delta> deltas) {
            return false;
        }

        @Override
        public void createCheckpoint() {
        }

        @Override
        public void discardCheckpoint() {
        }

        @Override
        public void rollback() {
        }
    }
}

