/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit.serializer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.junit.serializer.AssertNodeModelAcceptor;
import org.eclipse.xtext.junit.serializer.AssertStructureAcceptor;
import org.eclipse.xtext.junit.serializer.DebugSequenceAcceptor;
import org.eclipse.xtext.junit.util.ParseHelper;
import org.eclipse.xtext.junit.validation.ValidationTestHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.serializer.acceptor.DelegatingSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.StringBufferSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.WhitespaceAddingSequenceAcceptor;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.ContextFinder;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Deprecated
public class SerializerTester {
    @Inject
    protected ContextFinder contextFinder;
    @Inject
    protected IFormatter formatter;
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected Provider<IHiddenTokenSequencer> hiddenTokenSequencerProvider;
    @Inject
    protected ParseHelper<EObject> parseHelper;
    @Inject
    protected Provider<ISemanticSequencer> semanticSequencerProvider;
    @Inject
    protected ISerializer serializer;
    @Inject
    protected Provider<ISyntacticSequencer> syntacticSequencerProvider;
    @Inject
    protected ValidationTestHelper validationHelper;

    protected void assertEqualWithEmfFormatter(EObject semanticObject, EObject parsed) {
        String expected = EmfFormatter.objToStr((Object)semanticObject, (EStructuralFeature[])new EStructuralFeature[0]);
        String actual = EmfFormatter.objToStr((Object)parsed, (EStructuralFeature[])new EStructuralFeature[0]);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public void assertSerializable(EObject semanticObject) {
        this.assertSerializeWithNodeModel(semanticObject);
        this.assertSerializeWithoutNodeModel(semanticObject);
    }

    public void assertSerializable(String semanticObject) {
        this.assertSerializeWithNodeModel(semanticObject);
        this.assertSerializeWithoutNodeModel(semanticObject);
    }

    public void assertSerializeWithNodeModel(EObject semanticObject) {
        String expected = this.getTextFromNodeModel(semanticObject);
        String actual = this.serializeWithNodeModel(semanticObject);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public void assertSerializeWithNodeModel(String semanticModel) {
        try {
            EObject semanticObject = this.parseHelper.parse(semanticModel);
            this.validationHelper.assertNoErrors(semanticObject);
            this.assertSerializeWithNodeModel(semanticObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assertSerializeWithoutNodeModel(EObject semanticObject) {
        try {
            EObject parsed;
            if (semanticObject.eResource().getContents().contains((Object)semanticObject)) {
                List<Pair<EObject, ICompositeNode>> nodes = this.detachNodeModel(semanticObject);
                String serialized = this.serializeWithoutNodeModel(semanticObject);
                parsed = this.parseHelper.parse(serialized, semanticObject.eResource().getResourceSet());
                this.reattachNodes(nodes);
            } else {
                ICompositeNode oldNode = NodeModelUtils.getNode((EObject)semanticObject);
                String oldtext = oldNode.getRootNode().getText();
                String oldURI = semanticObject.eResource().getURIFragment(semanticObject);
                List<Pair<EObject, ICompositeNode>> nodes = this.detachNodeModel(semanticObject);
                String serialized = this.serializeWithoutNodeModel(semanticObject);
                ITextRegion oldRegion = oldNode.getTextRegion();
                String newtext = String.valueOf(oldtext.substring(0, oldRegion.getOffset())) + serialized + oldtext.substring(oldRegion.getOffset() + oldRegion.getLength());
                EObject newmodel = this.parseHelper.parse(newtext, semanticObject.eResource().getResourceSet());
                parsed = newmodel.eResource().getEObject(oldURI);
                this.reattachNodes(nodes);
            }
            EcoreUtil.resolveAll((EObject)parsed);
            Assert.assertTrue((String)parsed.eResource().getErrors().toString(), (boolean)parsed.eResource().getErrors().isEmpty());
            this.assertEqualWithEmfFormatter(semanticObject, parsed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assertSerializeWithoutNodeModel(String semanticModel) {
        try {
            EObject semanticObject = this.parseHelper.parse(semanticModel);
            this.validationHelper.assertNoErrors(semanticObject);
            this.assertSerializeWithoutNodeModel(semanticObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Pair<EObject, ICompositeNode>> detachNodeModel(EObject eObject) {
        EcoreUtil.resolveAll((EObject)eObject);
        ArrayList result = Lists.newArrayList();
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)eObject.eResource(), (boolean)false);
        block0: while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            Iterator adapters = object.eAdapters().iterator();
            while (adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof ICompositeNode)) continue;
                adapters.remove();
                result.add(Tuples.create((Object)object, (Object)((ICompositeNode)adapter)));
                continue block0;
            }
        }
        return result;
    }

    protected EObject getContext(EObject semanticObject) {
        Iterable contexts = this.contextFinder.findContextsByContentsAndContainer(semanticObject, null);
        if (Iterables.size((Iterable)contexts) != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("One context is expected, but " + Iterables.size((Iterable)contexts) + " have been found\n");
            msg.append("Contexts: " + Joiner.on((String)", ").join(Iterables.transform((Iterable)contexts, (Function)new Context2NameFunction())));
            msg.append("Semantic Object: " + EmfFormatter.objPath((EObject)semanticObject));
            Assert.fail((String)msg.toString());
        }
        return (EObject)contexts.iterator().next();
    }

    protected String getTextFromNodeModel(EObject semanticObject) {
        Resource res = semanticObject.eResource();
        if (res instanceof XtextResource && res.getContents().contains((Object)semanticObject)) {
            return ((XtextResource)res).getParseResult().getRootNode().getText();
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)semanticObject);
        Assert.assertNotNull((Object)node);
        return node.getText();
    }

    protected void reattachNodes(List<Pair<EObject, ICompositeNode>> nodes) {
        for (Pair<EObject, ICompositeNode> pair : nodes) {
            ((EObject)pair.getFirst()).eAdapters().add((Object)((Adapter)pair.getSecond()));
        }
    }

    protected String serialize(EObject semanticObject, DelegatingSequenceAcceptor ... acceptors) {
        Object debug = null;
        try {
            StringBufferSequenceAcceptor result;
            ISerializationDiagnostic.Acceptor errors = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
            ISemanticSequencer semantic = (ISemanticSequencer)this.semanticSequencerProvider.get();
            ISyntacticSequencer syntactic = (ISyntacticSequencer)this.syntacticSequencerProvider.get();
            IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)this.hiddenTokenSequencerProvider.get();
            Object out = result = new StringBufferSequenceAcceptor();
            DelegatingSequenceAcceptor[] delegatingSequenceAcceptorArray = acceptors;
            int n = acceptors.length;
            int n2 = 0;
            while (n2 < n) {
                DelegatingSequenceAcceptor delegate = delegatingSequenceAcceptorArray[n2];
                delegate.setDelegate((ISequenceAcceptor)out);
                out = delegate;
                ++n2;
            }
            debug = new DebugSequenceAcceptor((ISemanticSequenceAcceptor)out);
            out = debug;
            semantic.init((ISemanticSequenceAcceptor)syntactic, errors);
            EObject context = this.getContext(semanticObject);
            syntactic.init(context, semanticObject, (ISyntacticSequenceAcceptor)hidden, errors);
            hidden.init(context, semanticObject, (ISequenceAcceptor)out, errors);
            semantic.createSequence(context, semanticObject);
            return result.toString();
        }
        catch (Exception t) {
            if (debug != null) {
                System.out.println("Serializer debug output:");
                System.out.println(debug.toString());
            }
            throw new RuntimeException(t);
        }
    }

    protected String serializeWithNodeModel(EObject semanticObject) {
        return this.serialize(semanticObject, new AssertStructureAcceptor(), new AssertNodeModelAcceptor());
    }

    protected String serializeWithoutNodeModel(EObject semanticObject) {
        return this.serialize(semanticObject, new DelegatingSequenceAcceptor[]{new WhitespaceAddingSequenceAcceptor(), new AssertStructureAcceptor()});
    }
}

