/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.htmltext.commands.formatting;

import org.eclipse.mylyn.htmltext.HtmlComposer;
import org.eclipse.mylyn.htmltext.commands.Command;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;

public class SetSizeCommand
extends Command {
    private String setSelectedSize;
    private String sizeOfSelection;

    @Override
    public String getCommandIdentifier() {
        return "setsize";
    }

    @Override
    public String getCommand() {
        return "integration.format.setSize(" + this.setSelectedSize + ");";
    }

    public String[] getAvailableSizes() {
        String sizeString = String.valueOf(this.composer.evaluate("return integration.format.getAvailableSizes();"));
        String[] split = sizeString.split(";");
        String[] returnValue = new String[split.length];
        int i = 0;
        int n = split.length;
        while (i < n) {
            returnValue[i] = split[i].split("/")[0];
            ++i;
        }
        return returnValue;
    }

    public void setSizeToWidget(String selectedFormat) {
        this.setSelectedSize = selectedFormat;
    }

    public String getSizeOfSelection() {
        return this.sizeOfSelection;
    }

    @Override
    public void setComposer(HtmlComposer composer) {
        super.setComposer(composer);
        new FormatChangeFunction(composer.getBrowser());
    }

    public void setSizeOfSelection(String sizeOfSelection) {
        String oldValue = this.sizeOfSelection;
        this.sizeOfSelection = sizeOfSelection;
        this.firePropertyChange("sizeOfSelection", oldValue, sizeOfSelection);
    }

    @Override
    protected boolean trackCommand() {
        return false;
    }

    private class FormatChangeFunction
    extends BrowserFunction {
        public FormatChangeFunction(Browser browser) {
            super(browser, "_delegate_selectedsize");
        }

        public Object function(Object[] arguments) {
            SetSizeCommand.this.setSizeOfSelection(String.valueOf(arguments[0]));
            return null;
        }
    }
}

