/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.TreeMap;
import org.eclipse.mylyn.internal.sandbox.ui.GroupBy;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;

public class GroupedTaskListContentProvider
extends TaskListContentProvider {
    public static final String MEMENTO_KEY_GROUP_BY = "groupBy";
    private GroupBy groupBy = GroupBy.None;

    public GroupedTaskListContentProvider(TaskListView taskListView, GroupBy groupBy) {
        super(taskListView);
        this.groupBy = groupBy;
    }

    public Object[] getChildren(Object parent) {
        Object[] children = super.getChildren(parent);
        if (parent instanceof IRepositoryElement && (parent instanceof IRepositoryQuery || parent instanceof AbstractTaskCategory) && this.groupBy != GroupBy.None) {
            return this.getGroups((IRepositoryElement)parent, children);
        }
        if (parent instanceof TaskGroup) {
            return ((TaskGroup)parent).getChildren().toArray();
        }
        return children;
    }

    private TaskGroup[] getGroups(IRepositoryElement parent, Object[] children) {
        TreeMap<String, TaskGroup> groups = new TreeMap<String, TaskGroup>();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object container = objectArray[n2];
            if (container instanceof ITask) {
                TaskGroup group;
                AbstractTask task = (AbstractTask)container;
                String key = this.groupBy.getKey((ITask)task);
                if (key == null || key.length() == 0) {
                    key = "<unknown>";
                }
                if ((group = (TaskGroup)groups.get(key)) == null) {
                    group = new TaskGroup(parent.getHandleIdentifier(), key, this.groupBy.name());
                    groups.put(key, group);
                }
                group.internalAddChild(task);
            }
            ++n2;
        }
        return groups.values().toArray(new TaskGroup[groups.size()]);
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }
}

