/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.internal.breakpoints;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ModificationWatchpointEvent;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class OTJavaWatchpoint
extends JavaWatchpoint {
    private Hashtable _threadToObjectRefTable = new Hashtable();

    public OTJavaWatchpoint(IResource resource, String typeName, String fieldName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, String searchString) throws DebugException {
        super(resource, typeName, fieldName, lineNumber, charStart, charEnd, hitCount, register, attributes);
    }

    public boolean handleBreakpointEvent(Event event, JDIThread thread, boolean suspendVote) {
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modEvent = (ModificationWatchpointEvent)event;
            Value currentValue = modEvent.valueCurrent();
            Value valueToBe = modEvent.valueToBe();
            ObjectReference objectRef = modEvent.object();
            Hashtable objectRefs = !this._threadToObjectRefTable.containsKey(thread) ? new Hashtable() : (Hashtable)this._threadToObjectRefTable.get(thread);
            Value[] values = !objectRefs.containsKey(objectRef) ? new Value[2] : (Value[])objectRefs.get(objectRef);
            values[0] = currentValue;
            values[1] = valueToBe;
            objectRefs.put(objectRef, values);
            this._threadToObjectRefTable.put(thread, objectRefs);
        }
        return super.handleBreakpointEvent(event, thread, suspendVote);
    }

    public Value getValueToBe(IJavaThread thread, IJavaVariable variable) throws DebugException {
        Value[] values = this.getValues(thread, variable);
        if (values != null && values.length >= 2) {
            return values[1];
        }
        return null;
    }

    public Value getCurrentValue(IJavaThread thread, IJavaVariable variable) throws DebugException {
        Value[] values = this.getValues(thread, variable);
        if (values != null && values.length >= 2) {
            return values[0];
        }
        return null;
    }

    private Value[] getValues(IJavaThread thread, IJavaVariable variable) throws DebugException {
        Hashtable objRefTable = (Hashtable)this._threadToObjectRefTable.get(thread);
        for (ObjectReference objRef : objRefTable.keySet()) {
            JDIObjectValue value = (JDIObjectValue)variable.getValue();
            if (!value.getUnderlyingObject().equals(objRef)) continue;
            return (Value[])objRefTable.get(objRef);
        }
        return null;
    }
}

