/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.net.URL;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class SetupLabelProvider
extends AdapterFactoryLabelProvider.FontAndColorProvider {
    private final Color DARK_GRAY;

    public SetupLabelProvider(Viewer viewer) {
        this((AdapterFactory)BaseEditUtil.createAdapterFactory(), viewer);
    }

    public SetupLabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
        super(adapterFactory, viewer);
        this.DARK_GRAY = viewer.getControl().getDisplay().getSystemColor(16);
    }

    public Color getForeground(Object object) {
        if (SetupLabelProvider.isDisabled(object)) {
            return this.DARK_GRAY;
        }
        return super.getForeground(object);
    }

    public Font getFont(Object object) {
        Font font = super.getFont(object);
        return font == null ? this.getDefaultFont() : font;
    }

    public static boolean isDisabled(Object object) {
        if (object instanceof EObject) {
            SetupTask setupTask;
            EObject eObject = (EObject)object;
            if (eObject instanceof SetupTask && (setupTask = (SetupTask)eObject).isDisabled()) {
                return true;
            }
            EObject eContainer = eObject.eContainer();
            if (eContainer != null) {
                return SetupLabelProvider.isDisabled(eContainer);
            }
        }
        return false;
    }

    public static ImageDescriptor getImageDescriptor(ItemProviderAdapter itemProvider, EObject object) {
        Object key = itemProvider.getImage((Object)object);
        if (key instanceof ComposedImage) {
            ComposedImage composedImage = (ComposedImage)key;
            List images = composedImage.getImages();
            key = images.get(0);
        }
        return ImageDescriptor.createFromURL((URL)((URL)key));
    }

    public static String getText(ItemProviderAdapter itemProvider, EObject object) {
        EClass eClass = object.eClass();
        if (eClass == SetupPackage.Literals.USER || eClass == SetupPackage.Literals.INSTALLATION || eClass == SetupPackage.Literals.WORKSPACE) {
            return SetupEditPlugin.getPlugin().getString("_UI_" + eClass.getName() + "_type");
        }
        if (object instanceof Index) {
            return "Catalog " + itemProvider.getText((Object)object);
        }
        if (object instanceof Product) {
            Product product = (Product)object;
            return String.valueOf(SetupLabelProvider.getText(itemProvider, (EObject)product.getProductCatalog())) + " - " + itemProvider.getText((Object)product);
        }
        if (object instanceof ProductVersion) {
            ProductVersion version = (ProductVersion)object;
            return String.valueOf(SetupLabelProvider.getText(itemProvider, (EObject)version.getProduct())) + " - " + itemProvider.getText((Object)version);
        }
        if (object instanceof Project) {
            Project project = (Project)object;
            return String.valueOf(SetupLabelProvider.getText(itemProvider, (EObject)project.getProjectContainer())) + " - " + itemProvider.getText((Object)project);
        }
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            return String.valueOf(SetupLabelProvider.getText(itemProvider, (EObject)stream.getProject())) + " - " + itemProvider.getText((Object)stream);
        }
        return itemProvider.getText((Object)object);
    }
}

