/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;

public class PreferenceFilterImpl
extends ModelElementImpl
implements PreferenceFilter {
    protected PreferenceNode preferenceNode;
    protected static final Pattern INCLUSIONS_EDEFAULT = (Pattern)ProjectConfigFactory.eINSTANCE.createFromString(ProjectConfigPackage.eINSTANCE.getPattern(), ".*");
    protected Pattern inclusions = INCLUSIONS_EDEFAULT;
    protected static final Pattern EXCLUSIONS_EDEFAULT = (Pattern)ProjectConfigFactory.eINSTANCE.createFromString(ProjectConfigPackage.eINSTANCE.getPattern(), "");
    protected Pattern exclusions = EXCLUSIONS_EDEFAULT;

    protected PreferenceFilterImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectConfigPackage.Literals.PREFERENCE_FILTER;
    }

    @Override
    public PreferenceNode getPreferenceNode() {
        if (this.preferenceNode != null && this.preferenceNode.eIsProxy()) {
            InternalEObject oldPreferenceNode = (InternalEObject)this.preferenceNode;
            this.preferenceNode = (PreferenceNode)this.eResolveProxy(oldPreferenceNode);
            if (this.preferenceNode != oldPreferenceNode && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldPreferenceNode, (Object)this.preferenceNode));
            }
        }
        return this.preferenceNode;
    }

    public PreferenceNode basicGetPreferenceNode() {
        return this.preferenceNode;
    }

    @Override
    public void setPreferenceNode(PreferenceNode newPreferenceNode) {
        PreferenceNode oldPreferenceNode = this.preferenceNode;
        this.preferenceNode = newPreferenceNode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldPreferenceNode, (Object)this.preferenceNode));
        }
    }

    @Override
    public PreferenceProfile getPreferenceProfile() {
        if (this.eContainerFeatureID() != 2) {
            return null;
        }
        return (PreferenceProfile)this.eInternalContainer();
    }

    public NotificationChain basicSetPreferenceProfile(PreferenceProfile newPreferenceProfile, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newPreferenceProfile, 2, msgs);
        return msgs;
    }

    @Override
    public void setPreferenceProfile(PreferenceProfile newPreferenceProfile) {
        if (newPreferenceProfile != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newPreferenceProfile != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newPreferenceProfile)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newPreferenceProfile != null) {
                msgs = ((InternalEObject)newPreferenceProfile).eInverseAdd((InternalEObject)this, 1, PreferenceProfile.class, msgs);
            }
            if ((msgs = this.basicSetPreferenceProfile(newPreferenceProfile, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newPreferenceProfile, (Object)newPreferenceProfile));
        }
    }

    @Override
    public Pattern getInclusions() {
        return this.inclusions;
    }

    @Override
    public void setInclusions(Pattern newInclusions) {
        Pattern oldInclusions = this.inclusions;
        this.inclusions = newInclusions;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldInclusions, (Object)this.inclusions));
        }
    }

    @Override
    public Pattern getExclusions() {
        return this.exclusions;
    }

    @Override
    public void setExclusions(Pattern newExclusions) {
        Pattern oldExclusions = this.exclusions;
        this.exclusions = newExclusions;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldExclusions, (Object)this.exclusions));
        }
    }

    @Override
    public EList<Property> getProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : this.getPreferenceNode().getProperties()) {
            if (!this.matches(property.getName())) continue;
            properties.add(property);
        }
        int size = properties.size();
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_FILTER__PROPERTIES, size, (Object[])properties.toArray(new Property[size]));
    }

    @Override
    public boolean matches(String value) {
        return this.getInclusions().matcher(value).matches() && !this.getExclusions().matcher(value).matches();
    }

    @Override
    public Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetPreferenceProfile((PreferenceProfile)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetPreferenceProfile(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, PreferenceProfile.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (resolve) {
                    return this.getPreferenceNode();
                }
                return this.basicGetPreferenceNode();
            }
            case 2: {
                return this.getPreferenceProfile();
            }
            case 3: {
                return this.getInclusions();
            }
            case 4: {
                return this.getExclusions();
            }
            case 5: {
                return this.getProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setPreferenceNode((PreferenceNode)newValue);
                return;
            }
            case 2: {
                this.setPreferenceProfile((PreferenceProfile)newValue);
                return;
            }
            case 3: {
                this.setInclusions((Pattern)newValue);
                return;
            }
            case 4: {
                this.setExclusions((Pattern)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setPreferenceNode(null);
                return;
            }
            case 2: {
                this.setPreferenceProfile(null);
                return;
            }
            case 3: {
                this.setInclusions(INCLUSIONS_EDEFAULT);
                return;
            }
            case 4: {
                this.setExclusions(EXCLUSIONS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.preferenceNode != null;
            }
            case 2: {
                return this.getPreferenceProfile() != null;
            }
            case 3: {
                return INCLUSIONS_EDEFAULT == null ? this.inclusions != null : !INCLUSIONS_EDEFAULT.equals(this.inclusions);
            }
            case 4: {
                return EXCLUSIONS_EDEFAULT == null ? this.exclusions != null : !EXCLUSIONS_EDEFAULT.equals(this.exclusions);
            }
            case 5: {
                return !this.getProperties().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.matches((String)arguments.get(0));
            }
            case 2: {
                return this.getProperty((String)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (inclusions: ");
        result.append(this.inclusions);
        result.append(", exclusions: ");
        result.append(this.exclusions);
        result.append(')');
        return result.toString();
    }
}

