/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.http.impl.cookie.DateUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileInfo;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECFURIHandlerImpl
extends URIHandlerImpl {
    public static final String OPTION_CACHE_HANDLING = "OPTION_CACHE_HANDLING";
    public static final String OPTION_AUTHORIZATION_HANDLER = "OPTION_AUTHORIZATION_HANDLER";
    public static final String OPTION_AUTHORIZATION = "OPTION_AUTHORIZATION";
    private static final URI CACHE_FOLDER = SetupContext.GLOBAL_STATE_LOCATION_URI.appendSegment("cache");
    private static final Map<URI, String> EXPECTED_ETAGS = new HashMap<URI, String>();
    private static final boolean TEST_IO_EXCEPTION = false;
    private static final boolean TEST_SLOW_NETWORK = false;
    private static final boolean TRACE = PropertiesUtil.isProperty((String)"oomph.setup.ecf.trace");
    private static final String API_GITHUB_HOST = "api.github.com";
    private static final String CONTENT_TAG = "\"content\":\"";
    private static final int CONNECT_TIMEOUT = PropertiesUtil.getProperty((String)"oomph.setup.ecf.connect.timeout", (int)10000);
    private static final int READ_TIMEOUT = PropertiesUtil.getProperty((String)"oomph.setup.ecf.read.timeout", (int)10000);
    private static boolean loggedBlockedURI;
    private static final String USER_AGENT;
    private AuthorizationHandler defaultAuthorizationHandler;

    static {
        String userAgentProperty = PropertiesUtil.getProperty((String)"oomph.userAgent");
        if (userAgentProperty == null) {
            StringBuilder userAgent = new StringBuilder("eclipse/oomph/");
            if (SetupUtil.INSTALLER_PRODUCT) {
                userAgent.append("installer/");
            } else if (SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                userAgent.append("installer/");
            }
            Version oomphVersion = SetupCorePlugin.INSTANCE.getBundle().getVersion();
            userAgent.append(oomphVersion);
            USER_AGENT = userAgent.toString();
        } else {
            USER_AGENT = userAgentProperty;
        }
    }

    public ECFURIHandlerImpl(AuthorizationHandler defaultAuthorizationHandler) {
        this.defaultAuthorizationHandler = defaultAuthorizationHandler;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        Set requestedAttributes;
        if (uri.scheme().startsWith("http") && (requestedAttributes = this.getRequestedAttributes(options)) != null && requestedAttributes.contains("readOnly") && requestedAttributes.size() == 1) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("readOnly", true);
            return result;
        }
        return this.getRemoteAttributes(uri, options);
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, ?> getRemoteAttributes(URI uri, Map<?, ?> options) {
        if (uri.isPlatform()) {
            return super.getAttributes(uri, options);
        }
        requestedAttributes = this.getRequestedAttributes(options);
        cacheHandling = ECFURIHandlerImpl.getCacheHandling(options);
        uriConverter = this.getURIConverter(options);
        cacheURI = ECFURIHandlerImpl.getCacheFile(uri);
        eTag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getETag(uriConverter, cacheURI);
        expectedETag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getExpectedETag(uri);
        tracePrefix = null;
        if (ECFURIHandlerImpl.TRACE) {
            tracePrefix = ">? ECF: " + uri;
            System.out.println(String.valueOf(tracePrefix) + " uri=" + uri);
            System.out.println(String.valueOf(tracePrefix) + " cacheURI=" + cacheURI);
            System.out.println(String.valueOf(tracePrefix) + " eTag=" + eTag);
            System.out.println(String.valueOf(tracePrefix) + " expectedETag=" + expectedETag);
        }
        if ((expectedETag != null || cacheHandling == CacheHandling.CACHE_ONLY || cacheHandling == CacheHandling.CACHE_WITHOUT_ETAG_CHECKING) && (cacheHandling == CacheHandling.CACHE_ONLY || cacheHandling == CacheHandling.CACHE_WITHOUT_ETAG_CHECKING ? eTag != null : expectedETag.equals(eTag) != false) && !(result = this.handleAttributes((Set<String>)requestedAttributes, uriConverter.getAttributes(cacheURI, options))).isEmpty()) {
            return result;
        }
        host = ECFURIHandlerImpl.getHost(uri);
        if ("git.eclipse.org".equals(host)) {
            return Collections.emptyMap();
        }
        uriString = uri.toString();
        proxy = ProxySetupHelper.getProxy((String)uriString);
        if (proxy != null) {
            username = proxy.getUsername();
            password = proxy.getPassword();
        } else {
            username = null;
            password = null;
        }
        if (ECFURIHandlerImpl.TRACE) {
            System.out.println(String.valueOf(tracePrefix) + " proxy=" + proxy);
            System.out.println(String.valueOf(tracePrefix) + " username=" + username);
            System.out.println(String.valueOf(tracePrefix) + " password=" + PreferencesUtil.encrypt((String)password));
        }
        try {
            container = this.createContainer();
        }
        catch (IOException v0) {
            return Collections.emptyMap();
        }
        authorizatonHandler = this.getAuthorizatonHandler(options);
        authorization = ECFURIHandlerImpl.getAuthorizaton(options);
        if (ECFURIHandlerImpl.TRACE) {
            System.out.println(String.valueOf(tracePrefix) + " authorizationHandler=" + authorizatonHandler);
        }
        triedReauthorization = 0;
        i = 0;
        while (true) {
            block31: {
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " trying=" + i);
                    System.out.println(String.valueOf(tracePrefix) + " triedReauthorization=" + triedReauthorization);
                    System.out.println(String.valueOf(tracePrefix) + " authorization=" + authorization);
                }
                fileBrowser = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
                fileBrowser.setProxy(proxy);
                if (username != null) {
                    fileBrowser.setConnectContextForAuthentication(ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password));
                } else if (password != null) {
                    fileBrowser.setConnectContextForAuthentication(ConnectContextFactory.createPasswordConnectContext((String)password));
                }
                fileSystemListener = new RemoteFileSystemListener();
                try {
                    fileTransferID = new FileTransferID((Namespace)new FileTransferNamespace(), IOUtil.newURI((String)uriString));
                    fileBrowser.sendBrowseRequest((IFileID)fileTransferID, (IRemoteFileSystemListener)fileSystemListener);
                }
                catch (RemoteFileSystemException v1) {
                    return Collections.emptyMap();
                }
                try {
                    fileSystemListener.receiveLatch.await();
                }
                catch (InterruptedException ex) {
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " InterruptedException");
                        ex.printStackTrace(System.out);
                    }
                    return Collections.emptyMap();
                }
                if (fileSystemListener.exception == null) ** GOTO lbl105
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " transferLister.exception");
                    fileSystemListener.exception.printStackTrace(System.out);
                }
                if (fileSystemListener.exception instanceof UserCancelledException) ** GOTO lbl100
                if (fileSystemListener.exception.getCause() instanceof SocketTimeoutException && i <= 2) break block31;
                if (!(fileSystemListener.exception instanceof BrowseFileTransferException)) ** GOTO lbl100
                browseFileTransferException = (BrowseFileTransferException)fileSystemListener.exception;
                errorCode = browseFileTransferException.getErrorCode();
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " errorCode=" + errorCode);
                }
                if (authorizatonHandler == null || errorCode != 401 && (!"api.github.com".equals(ECFURIHandlerImpl.getHost(uri)) || errorCode != 404)) ** GOTO lbl-1000
                if (authorization == null && (authorization = authorizatonHandler.authorize(uri)).isAuthorized()) {
                    --i;
                } else if (!authorization.isUnauthorizeable() && triedReauthorization++ < 3 && (authorization = authorizatonHandler.reauthorize(uri, authorization)).isAuthorized()) {
                    --i;
                } else lbl-1000:
                // 2 sources

                {
                    if (errorCode == 405) {
                        specializedOptions = new HashMap<?, ?>(options);
                        response = new HashMap<Object, Object>();
                        specializedOptions.put("RESPONSE", response);
                        try {
                            inputStream = this.createInputStream(uri, specializedOptions);
                            inputStream.close();
                            return this.handleResponseAttributes(requestedAttributes, response);
                        }
                        catch (IOException v2) {}
                    }
lbl100:
                    // 5 sources

                    if (!(CacheHandling.CACHE_IGNORE.equals((Object)cacheHandling) || !uriConverter.exists(cacheURI, options) || fileSystemListener.exception instanceof RemoteFileSystemException && ((BrowseFileTransferException)fileSystemListener.exception).getErrorCode() == 404)) {
                        return this.handleAttributes((Set<String>)requestedAttributes, uriConverter.getAttributes(cacheURI, options));
                    }
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " failing");
                    }
                    return Collections.emptyMap();
lbl105:
                    // 1 sources

                    "api.github.com".equals(ECFURIHandlerImpl.getHost(uri));
                    return this.handleAttributes((Set<String>)requestedAttributes, fileSystemListener.info);
                }
            }
            ++i;
        }
    }

    private final Map<String, ?> handleResponseAttributes(Set<String> requestedAttributes, Map<Object, Object> response) {
        Object timeStamp;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", true);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("timeStamp")) && (timeStamp = response.get("TIME_STAMP")) != null) {
            result.put("timeStamp", timeStamp);
        }
        return result;
    }

    private final Map<String, ?> handleAttributes(Set<String> requestedAttributes, IRemoteFileInfo info) {
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", Boolean.valueOf(true));
        }
        if (requestedAttributes == null || requestedAttributes.contains("timeStamp")) {
            result.put("timeStamp", Long.valueOf(info.getLastModified()));
        }
        if (requestedAttributes == null || requestedAttributes.contains("length")) {
            result.put("length", Long.valueOf(info.getLength()));
        }
        return result;
    }

    private final Map<String, ?> handleAttributes(Set<String> requestedAttributes, Map<String, ?> attributes) {
        Object length;
        Object timeStamp;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", true);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("timeStamp")) && (timeStamp = attributes.get("timeStamp")) != null) {
            result.put("timeStamp", (Boolean)timeStamp);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("length")) && (length = attributes.get("length")) != null) {
            result.put("length", (Boolean)length);
        }
        return result;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return !this.getAttributes(uri, options).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        block50: {
            if (uri.isPlatform()) {
                return super.createInputStream(uri, options);
            }
            cacheHandling = ECFURIHandlerImpl.getCacheHandling(options);
            uriConverter = this.getURIConverter(options);
            cacheURI = ECFURIHandlerImpl.getCacheFile(uri);
            eTag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getETag(uriConverter, cacheURI);
            expectedETag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getExpectedETag(uri);
            tracePrefix = null;
            if (ECFURIHandlerImpl.TRACE) {
                tracePrefix = "> ECF: " + uri;
                System.out.println(String.valueOf(tracePrefix) + " uri=" + uri);
                System.out.println(String.valueOf(tracePrefix) + " cacheURI=" + cacheURI);
                System.out.println(String.valueOf(tracePrefix) + " eTag=" + eTag);
                System.out.println(String.valueOf(tracePrefix) + " expectedETag=" + expectedETag);
            }
            host = ECFURIHandlerImpl.getHost(uri);
            v0 = isBlockedEclipseGitURI = SetupUtil.SETUP_ARCHIVER_APPLICATION == false && "git.eclipse.org".equals(host) != false;
            if (isBlockedEclipseGitURI && uriConverter.exists(cacheURI, options)) {
                cacheHandling = CacheHandling.CACHE_ONLY;
            }
            if ((expectedETag != null || cacheHandling == CacheHandling.CACHE_ONLY || cacheHandling == CacheHandling.CACHE_WITHOUT_ETAG_CHECKING) && (cacheHandling == CacheHandling.CACHE_ONLY || cacheHandling == CacheHandling.CACHE_WITHOUT_ETAG_CHECKING ? eTag != null : expectedETag.equals(eTag) != false)) {
                try {
                    ECFURIHandlerImpl.setExpectedETag(uri, expectedETag);
                    result = uriConverter.createInputStream(cacheURI, options);
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " returning cached content");
                    }
                    return result;
                }
                catch (IOException v1) {
                    if (!ECFURIHandlerImpl.TRACE) break block50;
                    System.out.println(String.valueOf(tracePrefix) + " unable to load cached content");
                }
            }
        }
        if (isBlockedEclipseGitURI) {
            result = this;
            synchronized (result) {
                if (!ECFURIHandlerImpl.loggedBlockedURI) {
                    launcher = OS.getCurrentLauncher((boolean)true);
                    if (launcher == null) {
                        launcher = "eclipse";
                    }
                    SetupCorePlugin.INSTANCE.log("The Eclipse Git-hosted URI '" + uri + "' is blocked for direct access." + StringUtil.NL + "Please open a Bugzilla to add it to an official Oomph catalog." + StringUtil.NL + "For initial testing, use the file system local version of the resource." + StringUtil.NL + "Alternatively, run the setup archiver application as follows:" + StringUtil.NL + "  " + launcher + " -application org.eclipse.oomph.setup.core.SetupArchiver -consoleLog -noSplash -uris " + uri, 2);
                    ECFURIHandlerImpl.loggedBlockedURI = true;
                }
            }
            throw new IOException("Eclipse Git access blocked: " + uri);
        }
        uriString = uri.toString();
        proxy = ProxySetupHelper.getProxy((String)uriString);
        if (proxy != null) {
            username = proxy.getUsername();
            password = proxy.getPassword();
        } else {
            username = null;
            password = null;
        }
        if (ECFURIHandlerImpl.TRACE) {
            System.out.println(String.valueOf(tracePrefix) + " proxy=" + proxy);
            System.out.println(String.valueOf(tracePrefix) + " username=" + username);
            System.out.println(String.valueOf(tracePrefix) + " password=" + PreferencesUtil.encrypt((String)password));
        }
        container = this.createContainer();
        authorizatonHandler = this.getAuthorizatonHandler(options);
        authorization = ECFURIHandlerImpl.getAuthorizaton(options);
        if (ECFURIHandlerImpl.TRACE) {
            System.out.println(String.valueOf(tracePrefix) + " authorizationHandler=" + authorizatonHandler);
        }
        triedReauthorization = 0;
        i = 0;
        while (true) {
            block53: {
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " trying=" + i);
                    System.out.println(String.valueOf(tracePrefix) + " triedReauthorization=" + triedReauthorization);
                    System.out.println(String.valueOf(tracePrefix) + " authorization=" + authorization);
                }
                fileTransfer = (IRetrieveFileTransferContainerAdapter)container.getAdapter(IRetrieveFileTransferContainerAdapter.class);
                fileTransfer.setProxy(proxy);
                if (username != null) {
                    fileTransfer.setConnectContextForAuthentication(ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password));
                } else if (password != null) {
                    fileTransfer.setConnectContextForAuthentication(ConnectContextFactory.createPasswordConnectContext((String)password));
                }
                transferListener = new FileTransferListener(eTag);
                try {
                    fileTransferID = new FileTransferID((Namespace)new FileTransferNamespace(), IOUtil.newURI((String)uriString));
                    requestOptions = new HashMap<String, Object>();
                    requestOptions.put(IRetrieveFileTransferOptions.CONNECT_TIMEOUT, ECFURIHandlerImpl.CONNECT_TIMEOUT);
                    requestOptions.put(IRetrieveFileTransferOptions.READ_TIMEOUT, ECFURIHandlerImpl.READ_TIMEOUT);
                    if (authorization != null && authorization.isAuthorized()) {
                        requestOptions.put(IRetrieveFileTransferOptions.REQUEST_HEADERS, Collections.singletonMap("Authorization", authorization.getAuthorization()));
                    }
                    if (!StringUtil.isEmpty((String)ECFURIHandlerImpl.USER_AGENT) && host != null && host.endsWith(".eclipse.org")) {
                        requestHeaders = new HashMap<String, String>();
                        requestOptions.put(IRetrieveFileTransferOptions.REQUEST_HEADERS, requestHeaders);
                        requestHeaders.put("User-Agent", ECFURIHandlerImpl.USER_AGENT);
                    }
                    fileTransfer.sendRetrieveRequest((IFileID)fileTransferID, (IFileTransferListener)transferListener, requestOptions);
                }
                catch (IncomingFileTransferException ex) {
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " IncomingFileTransferException");
                        ex.printStackTrace(System.out);
                    }
                    throw ECFURIHandlerImpl.createIOException(uriString, ex);
                }
                try {
                    transferListener.receiveLatch.await();
                }
                catch (InterruptedException ex) {
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " InterruptedException");
                        ex.printStackTrace(System.out);
                    }
                    throw ECFURIHandlerImpl.createIOException(uriString, ex);
                }
                if (transferListener.exception == null) ** GOTO lbl133
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " transferLister.exception");
                    transferListener.exception.printStackTrace(System.out);
                }
                if (transferListener.exception instanceof UserCancelledException) ** GOTO lbl-1000
                if (transferListener.exception.getCause() instanceof SocketTimeoutException && i <= 2) break block53;
                if (authorizatonHandler == null || !(transferListener.exception instanceof IncomingFileTransferException)) ** GOTO lbl-1000
                incomingFileTransferException = (IncomingFileTransferException)transferListener.exception;
                errorCode = incomingFileTransferException.getErrorCode();
                if (ECFURIHandlerImpl.TRACE) {
                    System.out.println(String.valueOf(tracePrefix) + " errorCode=" + errorCode);
                }
                if (errorCode != 401 && (!"api.github.com".equals(ECFURIHandlerImpl.getHost(uri)) || errorCode != 404)) ** GOTO lbl-1000
                if (authorization == null && (authorization = authorizatonHandler.authorize(uri)).isAuthorized()) {
                    --i;
                } else if (!authorization.isUnauthorizeable() && triedReauthorization++ < 3 && (authorization = authorizatonHandler.reauthorize(uri, authorization)).isAuthorized()) {
                    --i;
                } else lbl-1000:
                // 4 sources

                {
                    block52: {
                        if (!CacheHandling.CACHE_IGNORE.equals((Object)cacheHandling) && uriConverter.exists(cacheURI, options) && (!(transferListener.exception instanceof IncomingFileTransferException) || ((IncomingFileTransferException)transferListener.exception).getErrorCode() != 404) || uri.equals(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI)) {
                            ECFURIHandlerImpl.setExpectedETag(uri, transferListener.eTag == null ? eTag : transferListener.eTag);
                            if (ECFURIHandlerImpl.TRACE) {
                                System.out.println(String.valueOf(tracePrefix) + " returning cache content");
                            }
                            return uriConverter.createInputStream(cacheURI, options);
                        }
                        if (ECFURIHandlerImpl.TRACE) {
                            System.out.println(String.valueOf(tracePrefix) + " failing");
                        }
                        throw ECFURIHandlerImpl.createIOException(uriString, transferListener.exception);
lbl133:
                        // 1 sources

                        bytes = transferListener.out.toByteArray();
                        if ("api.github.com".equals(ECFURIHandlerImpl.getHost(uri)) && (start = (value = new String(bytes, "UTF-8")).indexOf("\"content\":\"")) != -1 && (end = value.indexOf(34, start += "\"content\":\"".length())) != -1) {
                            content = value.substring(start, end);
                            split = content.split("\\\\n");
                            out = new ByteArrayOutputStream();
                            var32_39 = split;
                            var31_40 = split.length;
                            var30_41 = 0;
                            while (var30_41 < var31_40) {
                                line = var32_39[var30_41];
                                binary = XMLTypeFactory.eINSTANCE.createBase64Binary(line);
                                out.write(binary);
                                ++var30_41;
                            }
                            out.close();
                            bytes = out.toByteArray();
                        }
                        try {
                            try {
                                if (ECFURIHandlerImpl.TRACE) {
                                    System.out.println(String.valueOf(tracePrefix) + " writing cache");
                                }
                                BaseUtil.writeFile((URIConverter)uriConverter, options, (URI)cacheURI, (byte[])bytes);
                            }
                            catch (IORuntimeException ex) {
                                transferListener.eTag = null;
                                if (ECFURIHandlerImpl.TRACE) {
                                    System.out.println(String.valueOf(tracePrefix) + " failed writing cache");
                                    ex.printStackTrace(System.out);
                                }
                                ECFURIHandlerImpl.setETag(uriConverter, cacheURI, transferListener.eTag);
                                break block52;
                            }
                        }
                        catch (Throwable start) {
                            ECFURIHandlerImpl.setETag(uriConverter, cacheURI, transferListener.eTag);
                            throw start;
                        }
                        ECFURIHandlerImpl.setETag(uriConverter, cacheURI, transferListener.eTag);
                    }
                    ECFURIHandlerImpl.setExpectedETag(uri, transferListener.eTag);
                    response = this.getResponse(options);
                    if (response != null) {
                        response.put("TIME_STAMP", transferListener.lastModified);
                    }
                    if ((etagMirror = (ETagMirror)options.get("OPTION_ETAG_MIRROR")) != null) {
                        etagMirror.cacheUpdated(uri);
                    }
                    if (ECFURIHandlerImpl.TRACE) {
                        System.out.println(String.valueOf(tracePrefix) + " returning successful results");
                    }
                    return new ByteArrayInputStream(bytes);
                }
            }
            ++i;
        }
    }

    private IContainer createContainer() throws IOException {
        try {
            return ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException ex) {
            throw new IOExceptionWithCause((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<? extends URI> clearExpectedETags() {
        HashSet<URI> result;
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            result = new HashSet<URI>(EXPECTED_ETAGS.keySet());
            EXPECTED_ETAGS.clear();
        }
        return result;
    }

    public static Job mirror(final Set<? extends URI> uris) {
        Job job = new Job("ETag Mirror"){

            protected IStatus run(IProgressMonitor monitor) {
                new ETagMirror().begin(uris, monitor);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return job;
    }

    public static URI getCacheFile(URI uri) {
        return CACHE_FOLDER.appendSegment(IOUtil.encodeFileName((String)uri.toString()));
    }

    public static String getETag(URIConverter uriConverter, URI file) {
        URI eTagFile;
        if (uriConverter.exists(file, null) && uriConverter.exists(eTagFile = file.appendFileExtension("etag"), null)) {
            try {
                return new String(BaseUtil.readFile((URIConverter)uriConverter, null, (URI)eTagFile), "UTF-8");
            }
            catch (IORuntimeException iORuntimeException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    public static void setETag(URIConverter uriConverter, URI file, String eTag) {
        try {
            if (eTag != null) {
                BaseUtil.writeFile((URIConverter)uriConverter, null, (URI)file.appendFileExtension("etag"), (byte[])eTag.getBytes("UTF-8"));
            } else {
                BaseUtil.deleteFile((URIConverter)uriConverter, null, (URI)file);
            }
        }
        catch (IORuntimeException iORuntimeException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private AuthorizationHandler getAuthorizatonHandler(Map<?, ?> options) {
        if (options.containsKey(OPTION_AUTHORIZATION_HANDLER)) {
            return (AuthorizationHandler)options.get(OPTION_AUTHORIZATION_HANDLER);
        }
        return this.defaultAuthorizationHandler;
    }

    private static String getHost(URI uri) {
        String authority = uri.authority();
        if (authority != null) {
            int i = authority.indexOf(64);
            int j = authority.indexOf(58, i + 1);
            return j < 0 ? authority.substring(i + 1) : authority.substring(i + 1, j);
        }
        return null;
    }

    private static Date parseHTTPDate(String string) {
        try {
            return DateUtils.parseDate((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getExpectedETag(URI uri) {
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            return EXPECTED_ETAGS.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExpectedETag(URI uri, String eTag) {
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            String originalExpectedETag = EXPECTED_ETAGS.put(uri, eTag);
            if (eTag == null && originalExpectedETag != null) {
                EXPECTED_ETAGS.put(uri, originalExpectedETag);
            }
        }
    }

    private static CacheHandling getCacheHandling(Map<?, ?> options) {
        CacheHandling cacheHandling = (CacheHandling)((Object)options.get(OPTION_CACHE_HANDLING));
        if (cacheHandling == null) {
            cacheHandling = CacheHandling.CACHE_WITH_ETAG_CHECKING;
        }
        return cacheHandling;
    }

    private static AuthorizationHandler.Authorization getAuthorizaton(Map<?, ?> options) {
        return (AuthorizationHandler.Authorization)options.get(OPTION_AUTHORIZATION);
    }

    private static IOException createIOException(String url, Throwable cause) {
        String message = cause.getMessage();
        if (message != null && message.contains(url)) {
            if (cause instanceof IOException) {
                return (IOException)cause;
            }
            return new IOExceptionWithCause(cause);
        }
        return new IOExceptionWithCause(String.valueOf(StringUtil.isEmpty((String)message) ? "Error: " : String.valueOf(message) + ": ") + url, cause);
    }

    public static interface AuthorizationHandler {
        public Authorization authorize(URI var1);

        public Authorization reauthorize(URI var1, Authorization var2);

        public static final class Authorization {
            public static final Authorization UNAUTHORIZED = new Authorization("", "");
            public static final Authorization UNAUTHORIZEABLE = new Authorization("", "");
            private final String user;
            private final String password;

            public Authorization(String user, String password) {
                this.user = user == null ? "" : user;
                this.password = this.obscure(password == null ? "" : password);
            }

            public String getUser() {
                return this.user;
            }

            public String getPassword() {
                return this.unobscure(this.password);
            }

            public String getAuthorization() {
                return "Basic " + this.obscure(this.user.length() == 0 ? this.getPassword() : String.valueOf(this.user) + ":" + this.getPassword());
            }

            public boolean isAuthorized() {
                return !"".equals(this.password);
            }

            public boolean isUnauthorizeable() {
                return this == UNAUTHORIZEABLE;
            }

            private String obscure(String string) {
                return XMLTypeFactory.eINSTANCE.convertBase64Binary(string.getBytes());
            }

            private String unobscure(String string) {
                return new String(XMLTypeFactory.eINSTANCE.createBase64Binary(string));
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
                result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                if (this == UNAUTHORIZEABLE) {
                    return obj == UNAUTHORIZEABLE;
                }
                Authorization other = (Authorization)obj;
                if (!this.user.equals(other.user)) {
                    return false;
                }
                return this.password.equals(other.password);
            }

            public String toString() {
                return this == UNAUTHORIZEABLE ? "Authorization [unauthorizeable]" : "Authorization [user=" + this.user + ", password=" + this.password + "]";
            }
        }
    }

    public static class AuthorizationHandlerImpl
    implements AuthorizationHandler {
        private final Map<String, AuthorizationHandler.Authorization> authorizations = new HashMap<String, AuthorizationHandler.Authorization>();
        private final UIServices uiServices;
        private ISecurePreferences securePreferences;

        public AuthorizationHandlerImpl(UIServices uiServices, ISecurePreferences securePreferences) {
            this.uiServices = uiServices;
            this.securePreferences = securePreferences;
        }

        public synchronized void clearCache() {
            this.authorizations.clear();
        }

        public synchronized AuthorizationHandler.Authorization authorize(URI uri) {
            String host = ECFURIHandlerImpl.getHost(uri);
            if (host != null) {
                AuthorizationHandler.Authorization cachedAuthorization = this.authorizations.get(host);
                if (cachedAuthorization == AuthorizationHandler.Authorization.UNAUTHORIZEABLE) {
                    return cachedAuthorization;
                }
                if (this.securePreferences != null) {
                    try {
                        ISecurePreferences node = this.securePreferences.node(host);
                        String user = node.get("user", "");
                        String password = node.get("password", "");
                        AuthorizationHandler.Authorization authorization = new AuthorizationHandler.Authorization(user, password);
                        if (authorization.isAuthorized()) {
                            this.authorizations.put(host, authorization);
                            return authorization;
                        }
                    }
                    catch (StorageException ex) {
                        SetupCorePlugin.INSTANCE.log(ex);
                    }
                }
                if (cachedAuthorization != null) {
                    return cachedAuthorization;
                }
            }
            return AuthorizationHandler.Authorization.UNAUTHORIZED;
        }

        public synchronized AuthorizationHandler.Authorization reauthorize(URI uri, AuthorizationHandler.Authorization authorization) {
            String host;
            AuthorizationHandler.Authorization currentAuthorization = this.authorize(uri);
            if (!currentAuthorization.equals(authorization) || currentAuthorization == AuthorizationHandler.Authorization.UNAUTHORIZEABLE) {
                return currentAuthorization;
            }
            if (this.uiServices != null && (host = ECFURIHandlerImpl.getHost(uri)) != null) {
                String password;
                UIServices.AuthenticationInfo authenticationInfo = this.uiServices.getUsernamePassword(uri.toString());
                String user = authenticationInfo.getUserName();
                AuthorizationHandler.Authorization reauthorization = new AuthorizationHandler.Authorization(user, password = authenticationInfo.getPassword());
                if (reauthorization.isAuthorized()) {
                    if (authenticationInfo.saveResult() && this.securePreferences != null) {
                        try {
                            ISecurePreferences node = this.securePreferences.node(host);
                            node.put("user", user, false);
                            node.put("password", password, true);
                            node.flush();
                        }
                        catch (IOException ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                        catch (StorageException ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                    }
                    this.authorizations.put(host, reauthorization);
                    return reauthorization;
                }
                this.authorizations.put(host, AuthorizationHandler.Authorization.UNAUTHORIZEABLE);
                return AuthorizationHandler.Authorization.UNAUTHORIZEABLE;
            }
            return currentAuthorization;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheHandling {
        CACHE_ONLY,
        CACHE_WITHOUT_ETAG_CHECKING,
        CACHE_WITH_ETAG_CHECKING,
        CACHE_IGNORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ETagMirror
    extends WorkerPool<ETagMirror, URI, Worker> {
        private static final Map<Object, Object> OPTIONS;
        private static final URIConverter URI_CONVERTER;
        private static final String OPTION_ETAG_MIRROR = "OPTION_ETAG_MIRROR";
        private Set<? extends URI> uris;
        private Map<Object, Object> options = new HashMap<Object, Object>(OPTIONS);

        static {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            OPTIONS = resourceSet.getLoadOptions();
            OPTIONS.put(ECFURIHandlerImpl.OPTION_CACHE_HANDLING, (Object)CacheHandling.CACHE_WITH_ETAG_CHECKING);
            URI_CONVERTER = resourceSet.getURIConverter();
        }

        public ETagMirror() {
            this.options.put(OPTION_ETAG_MIRROR, (Object)this);
        }

        protected Worker createWorker(URI key, int workerID, boolean secondary) {
            return new Worker("ETag Mirror " + key, this, key, workerID, secondary);
        }

        public void begin(Set<? extends URI> uris, IProgressMonitor monitor) {
            this.uris = uris;
            int size = uris.size();
            monitor.beginTask("Mirroring " + size + " resource" + (size == 1 ? "" : "s"), uris.size());
            super.begin("Mirroring", monitor);
        }

        protected void run(String taskName, IProgressMonitor monitor) {
            this.perform(this.uris);
        }

        protected void cacheUpdated(URI uri) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Worker
        extends WorkerPool.Worker<URI, ETagMirror> {
            protected Worker(String name, ETagMirror workPool, URI key, int id, boolean secondary) {
                super(name, (WorkerPool)workPool, (Object)key, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                URI key = (URI)this.getKey();
                ETagMirror workPool = (ETagMirror)this.getWorkPool();
                IProgressMonitor workpoolMonitor = workPool.getMonitor();
                try {
                    workpoolMonitor.subTask("Mirroring " + key);
                }
                catch (Exception ex) {
                    SetupCorePlugin.INSTANCE.log(ex, 2);
                }
                try {
                    try {
                        URI_CONVERTER.createInputStream(key, workPool.options).close();
                    }
                    catch (IOException ex) {
                        SetupCorePlugin.INSTANCE.log(ex, 2);
                        try {
                            workpoolMonitor.worked(1);
                        }
                        catch (Exception ex2) {
                            SetupCorePlugin.INSTANCE.log(ex2, 2);
                        }
                    }
                }
                finally {
                    try {
                        workpoolMonitor.worked(1);
                    }
                    catch (Exception ex) {
                        SetupCorePlugin.INSTANCE.log(ex, 2);
                    }
                }
                return Status.OK_STATUS;
            }
        }
    }

    private static final class FileTransferListener
    implements IFileTransferListener {
        public final CountDownLatch receiveLatch = new CountDownLatch(1);
        public final String expectedETag;
        public String eTag;
        public ByteArrayOutputStream out;
        public long lastModified;
        public Exception exception;

        public FileTransferListener(String expectedETag) {
            this.expectedETag = expectedETag;
        }

        public void handleTransferEvent(IFileTransferEvent event) {
            if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                IIncomingFileTransferReceiveStartEvent receiveStartEvent = (IIncomingFileTransferReceiveStartEvent)event;
                this.out = new ByteArrayOutputStream();
                Map responseHeaders = receiveStartEvent.getResponseHeaders();
                if (responseHeaders != null) {
                    boolean isHTTPS;
                    Date date;
                    this.eTag = (String)responseHeaders.get("ETag");
                    String lastModifiedValue = (String)responseHeaders.get("Last-Modified");
                    if (lastModifiedValue != null && (date = ECFURIHandlerImpl.parseHTTPDate(lastModifiedValue.toString())) != null) {
                        this.lastModified = date.getTime();
                        if (this.eTag == null) {
                            this.eTag = Long.toString(this.lastModified);
                        }
                    }
                    if (this.expectedETag != null && this.expectedETag.equals(this.eTag)) {
                        receiveStartEvent.cancel();
                        this.exception = new UserCancelledException();
                        this.receiveLatch.countDown();
                        return;
                    }
                    try {
                        isHTTPS = "https".equals(receiveStartEvent.getFileID().getURI().getScheme());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        isHTTPS = false;
                    }
                    if (isHTTPS && responseHeaders.get("Set-Cookie") != null) {
                        try {
                            java.net.URI uri = ((IIncomingFileTransferReceiveStartEvent)event).getFileID().getURI();
                            if ("bitbucket.org".equals(uri.getHost())) {
                                IncomingFileTransferException incomingFileTransferException = new IncomingFileTransferException(401);
                                incomingFileTransferException.fillInStackTrace();
                                this.exception = incomingFileTransferException;
                                receiveStartEvent.cancel();
                                this.receiveLatch.countDown();
                                return;
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                }
                try {
                    receiveStartEvent.receive((OutputStream)this.out);
                }
                catch (IOException ex) {
                    this.exception = ex;
                }
            } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                IIncomingFileTransferReceiveDoneEvent done = (IIncomingFileTransferReceiveDoneEvent)event;
                Exception ex = done.getException();
                if (ex != null && this.exception == null) {
                    this.exception = ex;
                }
                this.receiveLatch.countDown();
            }
        }
    }

    private static final class RemoteFileSystemListener
    implements IRemoteFileSystemListener {
        public final CountDownLatch receiveLatch = new CountDownLatch(1);
        public Exception exception;
        public IRemoteFileInfo info;

        public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
            if (event instanceof IRemoteFileSystemBrowseEvent) {
                IRemoteFile[] iRemoteFileArray;
                IRemoteFileSystemBrowseEvent browseEvent = (IRemoteFileSystemBrowseEvent)event;
                this.exception = browseEvent.getException();
                if (this.exception == null && (iRemoteFileArray = browseEvent.getRemoteFiles()).length != 0) {
                    IRemoteFile remoteFile = iRemoteFileArray[0];
                    this.info = remoteFile.getInfo();
                }
                this.receiveLatch.countDown();
            }
        }
    }
}

