/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.jreinfo.JREInfoPlugin;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.ui.JREInfoUIPlugin;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class JREComposite
extends Composite {
    private static final Image IMAGE_GROUP = JREInfoUIPlugin.INSTANCE.getSWTImage("group");
    private static final Image IMAGE_JRE = JREInfoUIPlugin.INSTANCE.getSWTImage("jre");
    private static final Image IMAGE_JDK = JREInfoUIPlugin.INSTANCE.getSWTImage("jdk");
    private static final int EXTRA_WIDTH = OS.INSTANCE.isLinux() ? 10 : 0;
    private static final String[] GROUPS = new String[]{"System", "User"};
    private static final Object[] EMPTY = new Object[0];
    private final JREContentProvider contentProvider = new JREContentProvider();
    private final Request.Handler downloadHandler;
    private Object selectedElement;
    private JREFilter filter;
    private JRE[] extras = new JRE[0];
    private TreeViewer treeViewer;
    private Button browseButton;
    private Button downloadButton;
    private Button removeButton;
    private Button refreshButton;

    public JREComposite(Composite parent, int style, Request.Handler downloadHandler, JREFilter filter, Object selection) {
        super(parent, style);
        this.downloadHandler = downloadHandler;
        this.filter = filter;
        this.selectedElement = selection;
        this.setBackground(this.getDisplay().getSystemColor(37));
        this.setLayout((Layout)UIUtil.createGridLayout((int)2));
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)treeLayout);
        this.treeViewer = new TreeViewer(composite, 2050);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new JRELabelProvider(this.treeViewer.getTree().getFont()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)JREComposite.this.treeViewer.getSelection();
                boolean removable = true;
                int size = selection.size();
                if (size == 0) {
                    JREComposite.this.selectedElement = null;
                    removable = false;
                } else if (size == 1) {
                    JREComposite.this.selectedElement = selection.getFirstElement();
                    removable = JREComposite.this.isExtraJRE(JREComposite.this.selectedElement);
                } else {
                    JREComposite.this.selectedElement = null;
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (!JREComposite.this.isExtraJRE(element)) {
                            removable = false;
                            break;
                        }
                        ++n2;
                    }
                }
                JREComposite.this.removeButton.setEnabled(removable);
                JREComposite.this.elementChanged(JREComposite.this.selectedElement);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (JREComposite.this.selectedElement instanceof JRE) {
                    JREComposite.this.doubleClicked((JRE)JREComposite.this.selectedElement);
                }
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    JREComposite.this.removePressed();
                }
            }
        });
        TreeColumn locationColumn = new TreeColumn(tree, 16384);
        locationColumn.setText("Location");
        treeLayout.setColumnData((Widget)locationColumn, (ColumnLayoutData)new ColumnWeightData(100));
        TreeColumn versionColumn = new TreeColumn(tree, 16384);
        versionColumn.setText("Version");
        treeLayout.setColumnData((Widget)versionColumn, (ColumnLayoutData)new ColumnWeightData(1, 60 + EXTRA_WIDTH));
        TreeColumn bitnessColumn = new TreeColumn(tree, 16384);
        bitnessColumn.setText("Bitness");
        treeLayout.setColumnData((Widget)bitnessColumn, (ColumnLayoutData)new ColumnWeightData(1, 60 + EXTRA_WIDTH));
        TreeColumn typeColumn = new TreeColumn(tree, 16384);
        typeColumn.setText("Type");
        treeLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(1, 50 + EXTRA_WIDTH));
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        buttonComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        this.browseButton = new Button(buttonComposite, 0);
        this.browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.browseButton.setText("&Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREComposite.this.browsePressed();
            }
        });
        if (downloadHandler != null) {
            this.downloadButton = new Button(buttonComposite, 0);
            this.downloadButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.downloadButton.setText("&Download...");
            this.downloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JREComposite.this.downloadPressed();
                }
            });
        }
        this.removeButton = new Button(buttonComposite, 0);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.setText("&Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREComposite.this.removePressed();
            }
        });
        this.refreshButton = new Button(buttonComposite, 0);
        this.refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refreshButton.setText("Re&fresh");
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREComposite.this.refreshPressed();
            }
        });
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)JREComposite.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        JREComposite.this.treeViewer.setInput((Object)JREManager.INSTANCE);
                        JREComposite.this.treeViewer.expandAll();
                    }
                });
                if (JREComposite.this.selectedElement == null) {
                    JREComposite.this.removeButton.setEnabled(false);
                } else {
                    JREComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(JREComposite.this.selectedElement));
                }
            }
        });
    }

    public JREFilter getJREFilter() {
        return this.filter;
    }

    public void setJREFilter(JREFilter filter) {
        this.filter = filter;
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                JREComposite.this.treeViewer.refresh();
            }
        });
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(final Object selectedElement) {
        this.selectedElement = selectedElement;
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                JREComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
                JREComposite.this.elementChanged(selectedElement);
            }
        });
    }

    protected void elementChanged(Object element) {
    }

    protected void browsePressed() {
        File rootFolder = null;
        File file = new File(JREInfoPlugin.INSTANCE.getUserLocation().append("search.txt").toOSString());
        List lines = IOUtil.readLines((File)file, (String)"UTF-8");
        if (!lines.isEmpty()) {
            rootFolder = new File((String)lines.get(0));
        }
        while (rootFolder != null && !rootFolder.isDirectory()) {
            rootFolder = rootFolder.getParentFile();
        }
        String filterPath = rootFolder == null ? PropertiesUtil.getUserHome() : rootFolder.getAbsolutePath();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText("Java Virtual Machines");
        dialog.setMessage("Pick a root folder that will be recursively searched for Java virtual machines...");
        dialog.setFilterPath(filterPath);
        final String dir = dialog.open();
        if (dir != null) {
            if (!dir.equals(filterPath)) {
                IOUtil.writeLines((File)file, (String)"UTF-8", Collections.singletonList(dir));
            }
            try {
                int size;
                final AtomicReference added = new AtomicReference();
                UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        added.set(JREManager.INSTANCE.addExtraJavaHomes(dir, monitor));
                    }
                });
                Set jres = (Set)added.get();
                int n = size = jres == null ? 0 : jres.size();
                if (size != 0) {
                    this.treeViewer.refresh();
                    this.treeViewer.setExpandedState((Object)GROUPS[1], true);
                    this.treeViewer.setSelection((ISelection)new StructuredSelection(new ArrayList(jres)));
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Java Virtual Machines", (String)(String.valueOf(size == 0 ? "No" : Integer.toString(size)) + " new VM" + (size == 1 ? "" : "s") + " found."));
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                JREInfoPlugin.INSTANCE.log(cause);
                ErrorDialog.open((Throwable)cause);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void downloadPressed() {
        Request request = new Request("http://download.eclipse.org/oomph/jre/");
        JREFilter filter = this.getJREFilter();
        if (filter != null) {
            request.put((Object)"vm", (Object)filter.getQuery());
        }
        this.downloadHandler.handleRequest(request);
    }

    protected void removePressed() {
        HashSet<String> javaHomes = new HashSet<String>();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.isExtraJRE(element)) {
                javaHomes.add(((JRE)element).getJavaHome().getAbsolutePath());
            }
            ++n2;
        }
        int size = javaHomes.size();
        if (size != 0) {
            JREManager.INSTANCE.removeExtraJavaHomes(javaHomes.toArray(new String[size]));
            this.treeViewer.refresh();
            this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void refreshPressed() {
        JREManager.INSTANCE.refresh(true);
        this.treeViewer.refresh();
    }

    protected void doubleClicked(JRE jre) {
    }

    private boolean isExtraJRE(Object jre) {
        int i = 0;
        while (i < this.extras.length) {
            if (this.extras[i] == jre) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final class JREContentProvider
    implements ITreeContentProvider {
        private JREContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object element) {
            if (element == JREManager.INSTANCE) {
                return GROUPS;
            }
            if (element == GROUPS[0]) {
                return JREManager.INSTANCE.getJREs(null, false);
            }
            if (element == GROUPS[1]) {
                JREComposite.this.extras = JREManager.INSTANCE.getJREs(null, true);
                return JREComposite.this.extras;
            }
            return EMPTY;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }
    }

    private final class JRELabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    ITableFontProvider {
        private Font font;

        public JRELabelProvider(Font font) {
            this.font = font;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof String) {
                    return IMAGE_GROUP;
                }
                if (element instanceof JRE) {
                    return ((JRE)element).isJDK() ? IMAGE_JDK : IMAGE_JRE;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                if (columnIndex == 0) {
                    return (String)element;
                }
                return null;
            }
            if (element instanceof JRE) {
                JRE jre = (JRE)element;
                switch (columnIndex) {
                    case 0: {
                        return jre.toString();
                    }
                    case 1: {
                        return String.valueOf(jre.getMajor()) + "." + jre.getMinor() + "." + jre.getMicro();
                    }
                    case 2: {
                        return String.valueOf(jre.getBitness()) + " Bit";
                    }
                    case 3: {
                        return jre.isJDK() ? "JDK" : "JRE";
                    }
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            JRE jre;
            if (JREComposite.this.filter != null && element instanceof JRE && !(jre = (JRE)element).isMatch(JREComposite.this.filter)) {
                return JREComposite.this.getDisplay().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            JRE jre;
            if (element instanceof JRE && (jre = (JRE)element).isCurrent()) {
                return ExtendedFontRegistry.INSTANCE.getFont(this.font, (Object)IItemFontProvider.BOLD_FONT);
            }
            return null;
        }
    }
}

