/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;

public final class InternalImage {
    private final String resourceName;
    private final int width;
    private final int height;

    InternalImage(String resourceName, int width, int height) {
        ParamCheck.notNull(resourceName, "resourceName");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Illegal size");
        }
        this.resourceName = resourceName;
        this.width = width;
        this.height = height;
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        return RWTFactory.getImageDataFactory().findImageData(this);
    }

    public String getResourceName() {
        return this.resourceName;
    }
}

