/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

final class SimpleFontDialog
extends Dialog {
    private Text txtName;
    private Spinner spinSize;
    private Button chkBold;
    private Button chkItalic;
    private Font font;
    private Shell shell;
    private Runnable callback;

    public SimpleFontDialog(Shell parent) {
        this(parent, 67696);
    }

    public SimpleFontDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Font Dialog");
        this.shell = new Shell(parent, style);
        this.createControls((Composite)this.shell);
    }

    public void open(Runnable callback) {
        this.callback = callback;
        if (this.getText() != null) {
            this.shell.setText(this.getText());
        }
        this.shell.layout();
        this.shell.setSize(this.shell.computeSize(350, -1));
        Point parentLocation = this.getParent().getLocation();
        this.shell.setLocation(parentLocation.x + 20, parentLocation.y + 20);
        this.shell.open();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateFontControls();
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        SelectionAdapter dummySelectionListener = new SelectionAdapter(){};
        Label lblName = new Label(parent, 0);
        lblName.setText("Name");
        this.txtName = new Text(parent, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, -1, true, false));
        Label lblSize = new Label(parent, 0);
        lblSize.setText("Size");
        this.spinSize = new Spinner(parent, 2048);
        this.spinSize.setMinimum(1);
        this.spinSize.setMaximum(100);
        this.spinSize.setLayoutData((Object)new GridData(50, -1));
        Composite styleComp = new Composite(parent, 0);
        styleComp.setLayout((Layout)new RowLayout(256));
        GridData styleData = new GridData();
        styleData.horizontalSpan = 2;
        styleComp.setLayoutData((Object)styleData);
        this.chkBold = new Button(styleComp, 32);
        this.chkBold.addSelectionListener((SelectionListener)dummySelectionListener);
        this.chkBold.setText("Bold");
        this.chkItalic = new Button(styleComp, 32);
        this.chkItalic.addSelectionListener((SelectionListener)dummySelectionListener);
        this.chkItalic.setText("Italic");
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new RowLayout(256));
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 2;
        buttonData.horizontalAlignment = 3;
        buttonComp.setLayoutData((Object)buttonData);
        Button btnRevert = new Button(buttonComp, 8);
        btnRevert.setText("Revert");
        btnRevert.setToolTipText("Revert to default font");
        btnRevert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SimpleFontDialog.this.revertPressed();
            }
        });
        Button btnCancel = new Button(buttonComp, 8);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SimpleFontDialog.this.cancelPressed();
            }
        });
        Button btnApply = new Button(buttonComp, 8);
        btnApply.setText("Apply");
        btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SimpleFontDialog.this.applyPressed();
            }
        });
        btnApply.getShell().setDefaultButton(btnApply);
    }

    private void updateFontControls() {
        if (this.font != null) {
            FontData data = this.font.getFontData()[0];
            this.txtName.setText(data.getName());
            this.spinSize.setSelection(data.getHeight());
            this.chkBold.setSelection((data.getStyle() & 1) != 0);
            this.chkItalic.setSelection((data.getStyle() & 2) != 0);
        } else {
            this.txtName.setText("");
            this.spinSize.setSelection(0);
            this.chkBold.setSelection(false);
            this.chkItalic.setSelection(false);
        }
    }

    private void revertPressed() {
        this.setFont(null);
        if (this.callback != null) {
            this.callback.run();
        }
        this.shell.close();
    }

    private void cancelPressed() {
        if (this.callback != null) {
            this.callback.run();
        }
        this.shell.close();
    }

    private void applyPressed() {
        String name = this.txtName.getText();
        int height = this.spinSize.getSelection();
        int style = 0;
        if (this.chkBold.getSelection()) {
            style |= 1;
        }
        if (this.chkItalic.getSelection()) {
            style |= 2;
        }
        this.setFont(Graphics.getFont((String)name, (int)height, (int)style));
        if (this.callback != null) {
            this.callback.run();
        }
        this.shell.close();
    }
}

