/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.IGCAdapter;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canvas
extends Composite {
    private transient GCAdapter gcAdapter;

    Canvas(Composite parent) {
        super(parent);
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
        this.repaint();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IGCAdapter.class) {
            if (this.gcAdapter == null) {
                this.gcAdapter = new GCAdapter();
            }
            result = this.gcAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        PaintEvent.addListener(this, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        PaintEvent.removeListener(this, listener);
    }

    @Override
    void notifyResize(Point oldSize) {
        super.notifyResize(oldSize);
        if (!oldSize.equals(this.getSize())) {
            this.repaint();
        }
    }

    @Override
    void internalSetRedraw(boolean redraw) {
        super.internalSetRedraw(redraw);
        if (redraw) {
            this.repaint();
        }
    }

    private void repaint() {
        if (this.gcAdapter != null) {
            this.gcAdapter.clearGCOperations();
            this.gcAdapter.setForceRedraw(true);
        }
        GC gc = new GC(this);
        Rectangle clientArea = this.getClientArea();
        PaintEvent paintEvent = new PaintEvent(this, gc, clientArea);
        paintEvent.processEvent();
        gc.dispose();
    }
}

