/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.UpdateStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateListStrategy<S, D>
extends UpdateStrategy<S, D> {
    public static int POLICY_NEVER = UpdateListStrategy.notInlined(1);
    public static int POLICY_ON_REQUEST = UpdateListStrategy.notInlined(2);
    public static int POLICY_UPDATE = UpdateListStrategy.notInlined(8);
    private int updatePolicy;
    protected boolean provideDefaults;

    private static int notInlined(int i) {
        return i;
    }

    public UpdateListStrategy() {
        this(true, POLICY_UPDATE);
    }

    public UpdateListStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public UpdateListStrategy(boolean provideDefaults, int updatePolicy) {
        this.provideDefaults = provideDefaults;
        this.updatePolicy = updatePolicy;
    }

    protected void fillDefaults(IObservableList<? extends S> source, IObservableList<? super D> destination) {
        Object sourceType = source.getElementType();
        Object destinationType = destination.getElementType();
        if (this.provideDefaults && sourceType != null && destinationType != null && this.converter == null) {
            this.setConverter(this.createConverter(sourceType, destinationType));
        }
        if (this.converter != null) {
            if (sourceType != null) {
                this.checkAssignable(this.converter.getFromType(), sourceType, "converter does not convert from type " + sourceType);
            }
            if (destinationType != null) {
                this.checkAssignable(destinationType, this.converter.getToType(), "converter does not convert to type " + destinationType);
            }
        }
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public UpdateListStrategy<S, D> setConverter(IConverter<? super S, ? extends D> converter) {
        this.converter = converter;
        return this;
    }

    protected IStatus doAdd(IObservableList<? super D> observableList, D element, int index) {
        try {
            observableList.add(index, element);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doRemove(IObservableList<? super D> observableList, int index) {
        try {
            observableList.remove(index);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }

    protected boolean useMoveAndReplace() {
        return this.getClass() == UpdateListStrategy.class;
    }

    protected IStatus doMove(IObservableList<? super D> observableList, int oldIndex, int newIndex) {
        try {
            observableList.move(oldIndex, newIndex);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doReplace(IObservableList<? super D> observableList, int index, D element) {
        try {
            observableList.set(index, element);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }
}

